/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl;

import org.apache.milagro.amcl.RAND;
import org.apache.milagro.amcl.SHA3;

public final class NHS {
    public static final int RLWE_PRIME = 12289;
    public static final int RLWE_LGN = 10;
    public static final long RLWE_ND = 4143984639L;
    public static final int RLWE_ONE = 10952;
    public static final int RLWE_R2MODP = 5664;
    public static final int DEGREE = 1024;
    public static final int WL = 32;
    public static final int[] roots = new int[]{10952, 11183, 10651, 1669, 12036, 5517, 11593, 9397, 7900, 2739, 10901, 589, 971, 1704, 4857, 5562, 6241, 10889, 7260, 3046, 3102, 8228, 519, 6606, 10000, 5956, 6332, 11479, 918, 6357, 7237, 196, 8614, 3587, 11068, 11665, 3165, 1074, 8124, 3246, 9490, 10617, 946, 1812, 2862, 6807, 6659, 7117, 8726, 9985, 10, 9788, 4473, 8204, 11528, 7220, 657, 11417, 10842, 1827, 2845, 7372, 8118, 12120, 11262, 7386, 672, 1521, 734, 8135, 7848, 5913, 12199, 10220, 8447, 4800, 6849, 8754, 12187, 3390, 10989, 5616, 4584, 3792, 618, 7653, 2623, 3907, 3775, 8270, 2759, 11676, 1514, 9681, 182, 1180, 2453, 9557, 9954, 256, 6264, 1450, 11792, 10012, 203, 6988, 12216, 9655, 5443, 11387, 9242, 8739, 8394, 9453, 311, 7013, 7618, 1991, 11971, 3340, 4457, 7290, 7841, 3977, 8601, 10525, 4232, 8262, 9581, 11207, 11931, 1055, 6997, 11064, 208, 11882, 5973, 1724, 10020, 954, 8750, 11356, 11685, 8508, 4350, 5786, 5458, 1491, 768, 7005, 4930, 8196, 9583, 8249, 1639, 9141, 4387, 219, 11680, 3614, 12116, 10087, 5450, 1034, 4563, 10273, 3081, 2420, 1684, 4031, 10170, 306, 2111, 11526, 270, 6207, 10670, 10435, 11721, 4420, 11376, 10826, 3900, 7730, 4465, 7747, 3540, 11743, 10450, 4012, 964, 12057, 4262, 759, 3613, 2088, 5007, 4914, 4011, 3318, 5112, 9376, 4397, 10007, 1767, 4164, 878, 4072, 106, 2983, 7529, 10732, 9138, 2798, 5855, 4200, 6782, 9535, 588, 2867, 9859, 5582, 6867, 6710, 3222, 2794, 9738, 206, 10417, 3663, 11025, 1528, 8132, 3703, 9062, 4601, 5436, 9451, 8397, 5016, 34, 11159, 9371, 2283, 4786, 12259, 10689, 6912, 9827, 3754, 11782, 224, 5481, 4341, 10318, 2616, 8221, 7251, 5761, 8047, 12181, 12264, 2763, 5760, 6141, 11321, 5722, 4283, 10712, 9762, 4502, 2180, 10873, 5134, 11648, 1786, 4530, 9924, 853, 4180, 10729, 9197, 3043, 9466, 8115, 4268, 10521, 9604, 4260, 3717, 1616, 6291, 7617, 3470, 4828, 11586, 10317, 4095, 9487, 2765, 5059, 1740, 6777, 4641, 9748, 9994, 490, 341, 10264, 8748, 11867, 9688, 7615, 6428, 2831, 3500, 4226, 4847, 4534, 4008, 11122, 5533, 8350, 795, 11388, 5367, 3593, 7090, 7879, 9220, 8366, 1709, 3798, 11120, 7291, 6353, 10034, 4826, 3414, 1473, 5704, 6327, 5637, 7108, 640, 11982, 12, 6830, 452, 7387, 8918, 8664, 9596, 1311, 8475, 255, 12000, 9605, 225, 11317, 9947, 10609, 8712, 6113, 8638, 4958, 10454, 10385, 5769, 8504, 2950, 11834, 4612, 11536, 8996, 3903, 9480, 829, 3250, 10538, 3623, 11876, 10744, 11590, 2487, 8427, 7036, 2539, 11050, 1420, 10192, 4635, 10030, 10742, 11709, 9879, 10924, 3439, 7271, 11355, 4237, 867, 9373, 11614, 765, 11442, 8079, 8356, 2585, 10953, 6577, 5505, 6050, 10731, 7026, 5040, 3812, 2703, 8981, 1510, 2385, 11817, 3501, 7979, 8782, 895, 6770, 2705, 5127, 11769, 941, 9207, 6692, 7466, 9035, 7667, 4419, 2047, 6765, 10100, 9872, 10933, 1414, 10113, 8201, 12253, 10369, 921, 12214, 324, 4991, 4000, 11852, 7295, 12204, 2825, 4708, 4731, 6540, 11072, 560, 7412, 6155, 2904, 5194, 10988, 251, 9730, 5358, 1923, 4248, 9176, 515, 233, 4234, 5304, 3820, 3160, 4680, 9276, 10410, 1727, 10180, 10094, 6584, 7441, 11798, 1138, 5220, 9401, 1634, 4247, 8295, 8406, 5916, 4, 1666, 6075, 4486, 1266, 1023, 10819, 7623, 6885, 2252, 11900, 12024, 10976, 10500, 3796, 1733, 5294, 2930, 4547, 823, 11683, 10518, 1752, 7417, 4334, 6144, 6884, 2573, 4123, 6797, 11928, 9421, 2067, 6820, 2489, 1664, 9033, 9425, 8440, 3633, 9375, 8555, 4825, 7457, 6619, 6426, 7632, 1503, 1372, 11142, 531, 3742, 7921, 9866, 7518, 7712, 10433, 4985, 585, 6622, 395, 7745, 10782, 9746, 663, 11926, 8450, 70, 7071, 6733, 8272, 6962, 1384, 4599, 6185, 2160, 500, 7626, 2448, 7670, 11106, 5100, 2546, 4704, 10647, 5138, 7789, 5780, 4524, 11659, 10095, 9973, 9022, 11076, 12122, 11575, 11441, 3189, 2445, 7510, 1966, 4326, 4415, 6072, 2771, 1847, 8734, 7024, 7998, 10598, 6322, 1274, 8260, 4882, 5454, 8233, 1792, 6981, 10150, 8810, 8639, 1421, 12049, 11778, 6140, 1234, 5975, 3249, 12017, 9602, 4726, 2177, 12224, 4170, 1648, 10063, 11091, 6621, 1874, 5731, 3261, 11051, 12230, 5046, 8678, 5622, 4715, 9783, 7385, 12112, 3714, 1456, 9440, 4944, 12068, 8695, 6678, 12094, 5758, 8061, 10400, 5872, 3635, 1339, 10437, 5376, 12168, 9932, 8216, 5636, 8587, 11473, 2542, 6131, 1533, 8026, 720, 11078, 9164, 1283, 7238, 7363, 10466, 9278, 4651, 11788, 3639, 9745, 2142, 2488, 6948, 1890, 6582, 956, 11600, 8313, 6362, 5898, 2048, 2722, 4954, 6677, 5073, 202, 8467, 11705, 3506, 6748, 10665, 5256, 5313, 713, 2327, 10471, 9820, 3499, 10937, 11206, 4187, 6201, 8604, 80, 4570, 6146, 3926, 742, 8592, 3547, 1390, 2521, 7297, 4118, 4822, 10607, 5300, 4116, 7780, 7568, 2207, 11202, 10103, 10265, 7269, 6721, 1442, 11474, 1063, 3441, 10696, 7768, 1343, 1989, 7629, 1185, 4712, 9623, 10534, 238, 4379, 4152, 3692, 8924, 12079, 1089, 11517, 7344, 1700, 8740, 1568, 1500, 5809, 10781, 6023, 8391, 1601, 3460, 7173, 11533, 12114, 7052, 3453, 6120, 5513, 3187, 5403, 1250, 6889, 6936, 2971, 2377, 11360, 7802, 213, 7132, 8023, 5971, 4682, 1369, 2934, 9012, 4817, 7649, 5298, 12202, 5783, 5242, 1441, 11312, 7170, 4163, 12001, 9218, 7368, 10774, 4087, 4964, 7066, 10835, 12180, 10572, 7909, 6791, 8513, 3430, 2387, 10403, 12080, 9335, 6371, 4149, 8129, 7528, 12211, 5004, 9351, 7160, 3478, 4120, 1864, 9294, 5565, 5982, 702, 573, 474, 5997, 3095, 9406, 11963, 2008, 4106, 1881, 7604, 8793, 9204, 11609, 10311, 3061, 7422, 2592, 600, 4480, 10140, 84, 10943, 3164, 2553, 981, 11492, 5727, 9177, 10169, 1785, 10266, 5790, 1575, 5485, 8184, 529, 11828, 5924, 11310, 10128, 11733, 11250, 3516, 10372, 8361, 9104, 7706, 7018, 1527, 2743, 4915, 5803, 10461, 32, 783, 9398, 1474, 7396, 5120, 9833, 96, 5484, 3616, 9940, 9899, 7867, 8765, 1460, 8229, 7708, 2734, 11784, 1741, 5751, 5081, 6069, 4166, 7564, 5355, 6360, 7397, 9336, 5806, 2937, 9172, 1668, 5483, 1383, 26, 10702, 2106, 6632, 1422, 10570, 4406, 8985, 12218, 6697, 29, 6265, 10523, 6646, 11311, 8649, 6587, 3004, 9977, 3106, 1800, 4513, 6355, 2040, 10488, 9255, 7659, 2797, 9898, 9346, 8251, 12037, 11138, 6447, 11764, 2268, 10359, 3422, 9230, 1909, 11694, 7486, 8378, 8539, 8913, 3770, 3920, 2728, 6218, 8039, 11780, 3182, 1757, 6665, 639, 1172, 5158, 2787, 3605, 1631, 5060, 261, 2162, 9831, 8182, 3487, 11425, 12089, 9815, 9213, 9221, 2931, 8852, 7966, 11962, 4362, 11438, 5151, 8909, 9686, 4545, 28, 11662, 5658, 6824, 8862, 7161, 1999, 4205, 11328, 3475, 9566, 10434, 3098, 12055, 1994, 12131, 191};
    public static final int[] iroots = new int[]{10952, 1106, 10620, 1638, 2892, 696, 6772, 253, 6727, 7432, 10585, 11318, 11700, 1388, 9550, 4389, 12093, 5052, 5932, 11371, 810, 5957, 6333, 2289, 5683, 11770, 4061, 9187, 9243, 5029, 1400, 6048, 169, 4171, 4917, 9444, 10462, 1447, 872, 11632, 5069, 761, 4085, 7816, 2501, 12279, 2304, 3563, 5172, 5630, 5482, 9427, 10477, 11343, 1672, 2799, 9043, 4165, 11215, 9124, 624, 1221, 8702, 3675, 4027, 8057, 1764, 3688, 8312, 4448, 4999, 7832, 8949, 318, 10298, 4671, 5276, 11978, 2836, 3895, 3550, 3047, 902, 6846, 2634, 73, 5301, 12086, 2277, 497, 10839, 6025, 12033, 2335, 2732, 9836, 11109, 12107, 2608, 10775, 613, 9530, 4019, 8514, 8382, 9666, 4636, 11671, 8497, 7705, 6673, 1300, 8899, 102, 3535, 5440, 7489, 3842, 2069, 90, 6376, 4441, 4154, 11555, 10768, 11617, 4903, 1027, 9673, 1971, 7948, 6808, 12065, 507, 8535, 2462, 5377, 1600, 30, 7503, 10006, 2918, 1130, 12255, 7273, 3892, 2838, 6853, 7688, 3227, 8586, 4157, 10761, 1264, 8626, 1872, 12083, 2551, 9495, 9067, 5579, 5422, 6707, 2430, 9422, 11701, 2754, 5507, 8089, 6434, 9491, 3151, 1557, 4760, 9306, 12183, 8217, 11411, 8125, 10522, 2282, 7892, 2913, 7177, 8971, 8278, 7375, 7282, 10201, 8676, 11530, 8027, 232, 11325, 8277, 1839, 546, 8749, 4542, 7824, 4559, 8389, 1463, 913, 7869, 568, 1854, 1619, 6082, 12019, 763, 10178, 11983, 2119, 8258, 10605, 9869, 9208, 2016, 7726, 11255, 6839, 2202, 173, 8675, 609, 12070, 7902, 3148, 10650, 4040, 2706, 4093, 7359, 5284, 11521, 10798, 6831, 6503, 7939, 3781, 604, 933, 3539, 11335, 2269, 10565, 6316, 407, 12081, 1225, 5292, 11234, 358, 1082, 2708, 6995, 10556, 8493, 1789, 1313, 265, 389, 10037, 5404, 4666, 1470, 11266, 11023, 7803, 6214, 10623, 12285, 6373, 3883, 3994, 8042, 10655, 2888, 7069, 11151, 491, 4848, 5705, 2195, 2109, 10562, 1879, 3013, 7609, 9129, 8469, 6985, 8055, 12056, 11774, 3113, 8041, 10366, 6931, 2559, 12038, 1301, 7095, 9385, 6134, 4877, 11729, 1217, 5749, 7558, 7581, 9464, 85, 4994, 437, 8289, 7298, 11965, 75, 11368, 1920, 36, 4088, 2176, 10875, 1356, 2417, 2189, 5524, 10242, 7870, 4622, 3254, 4823, 5597, 3082, 11348, 520, 7162, 9584, 5519, 11394, 3507, 4310, 8788, 472, 9904, 10779, 3308, 9586, 8477, 7249, 5263, 1558, 6239, 6784, 5712, 1336, 9704, 3933, 4210, 847, 11524, 675, 2916, 11422, 8052, 934, 5018, 8850, 1365, 2410, 580, 1547, 2259, 7654, 2097, 10869, 1239, 9750, 5253, 3862, 9802, 699, 1545, 413, 8666, 1751, 9039, 11460, 2809, 8386, 3293, 753, 7677, 455, 9339, 3785, 6520, 1904, 1835, 7331, 3651, 6176, 3577, 1680, 2342, 972, 12064, 2684, 289, 12034, 3814, 10978, 2693, 3625, 3371, 4902, 11837, 5459, 12277, 307, 11649, 5181, 6652, 5962, 6585, 10816, 8875, 7463, 2255, 5936, 4998, 1169, 8491, 10580, 3923, 3069, 4410, 5199, 8696, 6922, 901, 11494, 3939, 6756, 1167, 8281, 7755, 7442, 8063, 8789, 9458, 5861, 4674, 2601, 422, 3541, 2025, 11948, 11799, 2295, 2541, 7648, 5512, 10549, 7230, 9524, 2802, 8194, 1972, 703, 7461, 8819, 4672, 5998, 10673, 8572, 8029, 2685, 1768, 8021, 4174, 2823, 9246, 3092, 1560, 8109, 11436, 2365, 7759, 10503, 641, 7155, 1416, 10109, 7787, 2527, 1577, 8006, 6567, 968, 6148, 6529, 9526, 25, 108, 4242, 6528, 5038, 4068, 12098, 158, 10295, 234, 9191, 1855, 2723, 8814, 961, 8084, 10290, 5128, 3427, 5465, 6631, 627, 12261, 7744, 2603, 3380, 7138, 851, 7927, 327, 4323, 3437, 9358, 3068, 3076, 2474, 200, 864, 8802, 4107, 2458, 10127, 12028, 7229, 10658, 8684, 9502, 7131, 11117, 11650, 5624, 10532, 9107, 509, 4250, 6071, 9561, 8369, 8519, 3376, 3750, 3911, 4803, 595, 10380, 3059, 8867, 1930, 10021, 525, 5842, 1151, 252, 4038, 2943, 2391, 9492, 4630, 3034, 1801, 10249, 5934, 7776, 10489, 9183, 2312, 9285, 5702, 3640, 978, 5643, 1766, 6024, 12260, 5592, 71, 3304, 7883, 1719, 10867, 5657, 10183, 1587, 12263, 10906, 6806, 10621, 3117, 9352, 6483, 2953, 4892, 5929, 6934, 4725, 8123, 6220, 7208, 6538, 10548, 505, 9555, 4581, 4060, 10829, 3524, 4422, 2390, 2349, 8673, 6805, 12193, 2456, 7169, 4893, 10815, 2891, 11506, 12257, 1828, 6486, 7374, 9546, 10762, 5271, 4583, 3185, 3928, 1917, 8773, 1039, 556, 2161, 979, 6365, 461, 11760, 4105, 6804, 10714, 6499, 2023, 10504, 2120, 3112, 6562, 797, 11308, 9736, 9125, 1346, 12205, 2149, 7809, 11689, 9697, 4867, 9228, 1978, 680, 3085, 3496, 4685, 10408, 8183, 10281, 326, 2883, 9194, 6292, 11815, 11716, 11587, 6307, 6724, 2995, 10425, 8169, 8811, 5129, 2938, 7285, 78, 4761, 4160, 8140, 5918, 2954, 209, 1886, 9902, 8859, 3776, 5498, 4380, 1717, 109, 1454, 5223, 7325, 8202, 1515, 4921, 3071, 288, 8126, 5119, 977, 10848, 7047, 6506, 87, 6991, 4640, 7472, 3277, 9355, 10920, 7607, 6318, 4266, 5157, 12076, 4487, 929, 9912, 9318, 5353, 5400, 11039, 6886, 9102, 6776, 6169, 8836, 5237, 175, 756, 5116, 8829, 10688, 3898, 6266, 1508, 6480, 10789, 10721, 3549, 10589, 4945, 772, 11200, 210, 3365, 8597, 8137, 7910, 12051, 1755, 2666, 7577, 11104, 4660, 10300, 10946, 4521, 1593, 8848, 11226, 815, 10847, 5568, 5020, 2024, 2186, 1087, 10082, 4721, 4509, 8173, 6989, 1682, 7467, 8171, 4992, 9768, 10899, 8742, 3697, 11547, 8363, 6143, 7719, 12209, 3685, 6088, 8102, 1083, 1352, 8790, 2469, 1818, 9962, 11576, 6976, 7033, 1624, 5541, 8783, 584, 3822, 12087, 7216, 5612, 7335, 9567, 10241, 6391, 5927, 3976, 689, 11333, 5707, 10399, 5341, 9801, 10147, 2544, 8650, 501, 7638, 3011, 1823, 4926, 5051, 11006, 3125, 1211, 11569, 4263, 10756, 6158, 9747, 816, 3702, 6653, 4073, 2357, 121, 6913, 1852, 10950, 8654, 6417, 1889, 4228, 6531, 195, 5611, 3594, 221, 7345, 2849, 10833, 8575, 177, 4904, 2506, 7574, 6667, 3611, 7243, 59, 1238, 9028, 6558, 10415, 5668, 1198, 2226, 10641, 8119, 65, 10112, 7563, 2687, 272, 9040, 6314, 11055, 6149, 511, 240, 10868, 3650, 3479, 2139, 5308, 10497, 4056, 6835, 7407, 4029, 11015, 5967, 1691, 4291, 5265, 3555, 10442, 9518, 6217, 7874, 7963, 10323, 4779, 9844, 9100, 848, 714, 167, 1213, 3267, 2316, 2194, 630, 7765, 6509, 4500, 7151, 1642, 7585, 9743, 7189, 1183, 4619, 9841, 4663, 11789, 10129, 6104, 7690, 10905, 5327, 4017, 5556, 5218, 12219, 3839, 363, 11626, 2543, 1507, 4544, 11894, 5667, 11704, 7304, 1856, 4577, 4771, 2423, 4368, 8547, 11758, 1147, 10917, 10786, 4657, 5863, 5670, 4832, 7464, 3734, 2914, 8656, 3849, 2864, 3256, 10625, 9800, 5469, 10222, 2868, 361, 5492, 8166, 9716, 5405, 6145, 7955, 4872, 10537, 1771, 606, 11466, 7742, 9359};
    public static final int inv = 3755;
    public static final int invpr = 11306;

    static int round(int a, int b) {
        return (a + b / 2) / b;
    }

    static int nabs(int x) {
        int mask = x >> 31;
        return x + mask ^ mask;
    }

    static int redc(long T) {
        long m = T * 4143984639L & 0xFFFFFFFFL;
        return (int)(m * 12289L + T >>> 32);
    }

    static int nres(int x) {
        return NHS.redc((long)x * 5664L);
    }

    static int modmul(int a, int b) {
        return NHS.redc((long)a * (long)b);
    }

    static void ntt(int[] x) {
        int j;
        int t = 512;
        int q = 12289;
        for (j = 0; j < 1024; ++j) {
            x[j] = NHS.nres(x[j]);
        }
        for (int m = 1; m < 1024; m *= 2) {
            int k = 0;
            for (int i = 0; i < m; ++i) {
                int S = roots[m + i];
                for (j = k; j < k + t; ++j) {
                    int U = x[j];
                    int V = NHS.modmul(x[j + t], S);
                    x[j] = U + V;
                    x[j + t] = U + 2 * q - V;
                }
                k += 2 * t;
            }
            t /= 2;
        }
    }

    static void intt(int[] x) {
        int W;
        int V;
        int U;
        int j;
        int t = 1;
        int q = 12289;
        for (int m = 512; m > 1; m /= 2) {
            int k = 0;
            for (int i = 0; i < m; ++i) {
                int S = iroots[m + i];
                for (j = k; j < k + t; ++j) {
                    U = x[j];
                    V = x[j + t];
                    x[j] = U + V;
                    W = U + 1024 * q - V;
                    x[j + t] = NHS.modmul(W, S);
                }
                k += 2 * t;
            }
            t *= 2;
        }
        t = 512;
        for (j = 0; j < t; ++j) {
            U = x[j];
            V = x[j + t];
            W = U + 1024 * q - V;
            x[j + t] = NHS.modmul(W, 11306);
            x[j] = NHS.modmul(U + V, 3755);
        }
        for (j = 0; j < 1024; ++j) {
            x[j] = NHS.redc(x[j]);
            int n = j;
            x[n] = x[n] - q;
            int n2 = j;
            x[n2] = x[n2] + (x[j] >> 31 & q);
        }
    }

    static void Encode(byte[] key, int[] poly) {
        int q2 = 6144;
        int j = 0;
        int i = 0;
        while (i < 256) {
            int kj = key[j++];
            for (int k = 0; k < 8; ++k) {
                int b = kj & 1;
                poly[i] = b * q2;
                poly[i + 256] = b * q2;
                poly[i + 512] = b * q2;
                poly[i + 768] = b * q2;
                kj >>= 1;
                ++i;
            }
        }
    }

    static void Decode(int[] poly, byte[] key) {
        int i;
        int q2 = 6144;
        for (i = 0; i < 32; ++i) {
            key[i] = 0;
        }
        int j = 0;
        i = 0;
        while (i < 256) {
            for (int k = 0; k < 8; ++k) {
                int t = NHS.nabs(poly[i] - q2) + NHS.nabs(poly[i + 256] - q2) + NHS.nabs(poly[i + 512] - q2) + NHS.nabs(poly[i + 768] - q2);
                int b = t - 12289;
                b = b >> 31 & 1;
                key[j] = (byte)(((key[j] & 0xFF) >> 1) + (b << 7));
                ++i;
            }
            ++j;
        }
    }

    static void Parse(byte[] seed, int[] poly) {
        int i;
        byte[] hash = new byte[4096];
        SHA3 sh = new SHA3(16);
        for (i = 0; i < 32; ++i) {
            sh.process(seed[i]);
        }
        sh.shake(hash, 4096);
        int j = 0;
        for (i = 0; i < 1024; ++i) {
            int n = hash[j] & 0x7F;
            n <<= 8;
            n += hash[j + 1] & 0xFF;
            n <<= 8;
            n += hash[j + 2] & 0xFF;
            n <<= 8;
            poly[i] = NHS.nres(n += hash[(j += 4) + 3] & 0xFF);
        }
    }

    static void pack(int[] poly, byte[] array) {
        int j = 0;
        int i = 0;
        while (i < 1024) {
            int a = poly[i++];
            int b = poly[i++];
            int c = poly[i++];
            int d = poly[i++];
            array[j++] = (byte)(a & 0xFF);
            array[j++] = (byte)((a >> 8 | b << 6) & 0xFF);
            array[j++] = (byte)(b >> 2 & 0xFF);
            array[j++] = (byte)((b >> 10 | c << 4) & 0xFF);
            array[j++] = (byte)(c >> 4 & 0xFF);
            array[j++] = (byte)((c >> 12 | d << 2) & 0xFF);
            array[j++] = (byte)(d >> 6);
        }
    }

    static void unpack(byte[] array, int[] poly) {
        int j = 0;
        int i = 0;
        while (i < 1024) {
            int a = array[j++] & 0xFF;
            int b = array[j++] & 0xFF;
            int c = array[j++] & 0xFF;
            int d = array[j++] & 0xFF;
            int e = array[j++] & 0xFF;
            int f = array[j++] & 0xFF;
            int g = array[j++] & 0xFF;
            poly[i++] = a | (b & 0x3F) << 8;
            poly[i++] = b >> 6 | c << 2 | (d & 0xF) << 10;
            poly[i++] = d >> 4 | e << 4 | (f & 3) << 12;
            poly[i++] = f >> 2 | g << 6;
        }
    }

    static void Compress(int[] poly, byte[] array) {
        int col = 0;
        int j = 0;
        int i = 0;
        while (i < 1024) {
            for (int k = 0; k < 8; ++k) {
                int b = NHS.round(poly[i] * 8, 12289) & 7;
                col = (col << 3) + b;
                ++i;
            }
            array[j] = (byte)(col & 0xFF);
            array[j + 1] = (byte)(col >>> 8 & 0xFF);
            array[j + 2] = (byte)(col >>> 16 & 0xFF);
            j += 3;
            col = 0;
        }
    }

    static void Decompress(byte[] array, int[] poly) {
        int col = 0;
        int j = 0;
        int i = 0;
        while (i < 1024) {
            col = array[j + 2] & 0xFF;
            col = (col << 8) + (array[j + 1] & 0xFF);
            col = (col << 8) + (array[j] & 0xFF);
            j += 3;
            for (int k = 0; k < 8; ++k) {
                int b = (col & 0xE00000) >>> 21;
                col <<= 3;
                poly[i] = NHS.round(b * 12289, 8);
                ++i;
            }
        }
    }

    static void Error(RAND RNG, int[] poly) {
        for (int i = 0; i < 1024; ++i) {
            int n1 = RNG.getByte() + (RNG.getByte() << 8);
            int n2 = RNG.getByte() + (RNG.getByte() << 8);
            int r = 0;
            for (int j = 0; j < 16; ++j) {
                r += (n1 & 1) - (n2 & 1);
                n1 >>= 1;
                n2 >>= 1;
            }
            poly[i] = r + 12289;
        }
    }

    static void redc_it(int[] p) {
        for (int i = 0; i < 1024; ++i) {
            p[i] = NHS.redc(p[i]);
        }
    }

    static void nres_it(int[] p) {
        for (int i = 0; i < 1024; ++i) {
            p[i] = NHS.nres(p[i]);
        }
    }

    static void poly_mul(int[] p1, int[] p2, int[] p3) {
        for (int i = 0; i < 1024; ++i) {
            p1[i] = NHS.modmul(p2[i], p3[i]);
        }
    }

    static void poly_add(int[] p1, int[] p2, int[] p3) {
        for (int i = 0; i < 1024; ++i) {
            p1[i] = p2[i] + p3[i];
        }
    }

    static void poly_sub(int[] p1, int[] p2, int[] p3) {
        for (int i = 0; i < 1024; ++i) {
            p1[i] = p2[i] + 12289 - p3[i];
        }
    }

    static void poly_soft_reduce(int[] poly) {
        for (int i = 0; i < 1024; ++i) {
            int e = poly[i] - 12289;
            poly[i] = e + (e >> 31 & 0x3001);
        }
    }

    static void poly_hard_reduce(int[] poly) {
        for (int i = 0; i < 1024; ++i) {
            int e = NHS.modmul(poly[i], 10952);
            poly[i] = (e -= 12289) + (e >> 31 & 0x3001);
        }
    }

    public static void SERVER_1(RAND RNG, byte[] SB, byte[] S) {
        int i;
        byte[] seed = new byte[32];
        byte[] array = new byte[1792];
        int[] s = new int[1024];
        int[] e = new int[1024];
        int[] b = new int[1024];
        for (i = 0; i < 32; ++i) {
            seed[i] = (byte)RNG.getByte();
        }
        NHS.Parse(seed, b);
        NHS.Error(RNG, e);
        NHS.Error(RNG, s);
        NHS.ntt(s);
        NHS.ntt(e);
        NHS.poly_mul(b, b, s);
        NHS.poly_add(b, b, e);
        NHS.poly_hard_reduce(b);
        NHS.redc_it(b);
        NHS.pack(b, array);
        for (i = 0; i < 32; ++i) {
            SB[i] = seed[i];
        }
        for (i = 0; i < 1792; ++i) {
            SB[i + 32] = array[i];
        }
        NHS.poly_hard_reduce(s);
        NHS.pack(s, array);
        for (i = 0; i < 1792; ++i) {
            S[i] = array[i];
        }
    }

    public static void CLIENT(RAND RNG, byte[] SB, byte[] UC, byte[] KEY) {
        int i;
        SHA3 sh = new SHA3(32);
        byte[] seed = new byte[32];
        byte[] array = new byte[1792];
        byte[] key = new byte[32];
        byte[] cc = new byte[384];
        int[] sd = new int[1024];
        int[] ed = new int[1024];
        int[] u = new int[1024];
        int[] k = new int[1024];
        int[] c = new int[1024];
        NHS.Error(RNG, sd);
        NHS.Error(RNG, ed);
        NHS.ntt(sd);
        NHS.ntt(ed);
        for (i = 0; i < 32; ++i) {
            seed[i] = SB[i];
        }
        for (i = 0; i < 1792; ++i) {
            array[i] = SB[i + 32];
        }
        NHS.Parse(seed, u);
        NHS.poly_mul(u, u, sd);
        NHS.poly_add(u, u, ed);
        NHS.poly_hard_reduce(u);
        for (i = 0; i < 32; ++i) {
            key[i] = (byte)RNG.getByte();
        }
        for (i = 0; i < 32; ++i) {
            sh.process(key[i]);
        }
        sh.hash(key);
        NHS.Encode(key, k);
        NHS.unpack(array, c);
        NHS.nres_it(c);
        NHS.poly_mul(c, c, sd);
        NHS.intt(c);
        NHS.Error(RNG, ed);
        NHS.poly_add(c, c, ed);
        NHS.poly_add(c, c, k);
        NHS.Compress(c, cc);
        sh.init(32);
        for (i = 0; i < 32; ++i) {
            sh.process(key[i]);
        }
        sh.hash(key);
        for (i = 0; i < 32; ++i) {
            KEY[i] = key[i];
        }
        NHS.redc_it(u);
        NHS.pack(u, array);
        for (i = 0; i < 1792; ++i) {
            UC[i] = array[i];
        }
        for (i = 0; i < 384; ++i) {
            UC[i + 1792] = cc[i];
        }
    }

    public static void SERVER_2(byte[] S, byte[] UC, byte[] KEY) {
        int i;
        SHA3 sh = new SHA3(32);
        int[] c = new int[1024];
        int[] s = new int[1024];
        int[] k = new int[1024];
        byte[] array = new byte[1792];
        byte[] key = new byte[32];
        byte[] cc = new byte[384];
        for (i = 0; i < 1792; ++i) {
            array[i] = UC[i];
        }
        NHS.unpack(array, k);
        NHS.nres_it(k);
        for (i = 0; i < 384; ++i) {
            cc[i] = UC[i + 1792];
        }
        NHS.Decompress(cc, c);
        for (i = 0; i < 1792; ++i) {
            array[i] = S[i];
        }
        NHS.unpack(array, s);
        NHS.poly_mul(k, k, s);
        NHS.intt(k);
        NHS.poly_sub(k, c, k);
        NHS.poly_soft_reduce(k);
        NHS.Decode(k, key);
        for (i = 0; i < 32; ++i) {
            sh.process(key[i]);
        }
        sh.hash(key);
        for (i = 0; i < 32; ++i) {
            KEY[i] = key[i];
        }
    }
}

