/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl;

public class HASH256 {
    private int[] length = new int[2];
    private int[] h = new int[8];
    private int[] w = new int[80];
    public static final int H0 = 1779033703;
    public static final int H1 = -1150833019;
    public static final int H2 = 1013904242;
    public static final int H3 = -1521486534;
    public static final int H4 = 1359893119;
    public static final int H5 = -1694144372;
    public static final int H6 = 528734635;
    public static final int H7 = 1541459225;
    public static final int len = 32;
    public static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    private static int S(int n, int x) {
        return x >>> n | x << 32 - n;
    }

    private static int R(int n, int x) {
        return x >>> n;
    }

    private static int Ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private static int Maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private static int Sig0(int x) {
        return HASH256.S(2, x) ^ HASH256.S(13, x) ^ HASH256.S(22, x);
    }

    private static int Sig1(int x) {
        return HASH256.S(6, x) ^ HASH256.S(11, x) ^ HASH256.S(25, x);
    }

    private static int theta0(int x) {
        return HASH256.S(7, x) ^ HASH256.S(18, x) ^ HASH256.R(3, x);
    }

    private static int theta1(int x) {
        return HASH256.S(17, x) ^ HASH256.S(19, x) ^ HASH256.R(10, x);
    }

    private void transform() {
        int j;
        for (j = 16; j < 64; ++j) {
            this.w[j] = HASH256.theta1(this.w[j - 2]) + this.w[j - 7] + HASH256.theta0(this.w[j - 15]) + this.w[j - 16];
        }
        int a = this.h[0];
        int b = this.h[1];
        int c = this.h[2];
        int d = this.h[3];
        int e = this.h[4];
        int f = this.h[5];
        int g = this.h[6];
        int hh = this.h[7];
        for (j = 0; j < 64; ++j) {
            int t1 = hh + HASH256.Sig1(e) + HASH256.Ch(e, f, g) + K[j] + this.w[j];
            int t2 = HASH256.Sig0(a) + HASH256.Maj(a, b, c);
            hh = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        this.h[0] = this.h[0] + a;
        this.h[1] = this.h[1] + b;
        this.h[2] = this.h[2] + c;
        this.h[3] = this.h[3] + d;
        this.h[4] = this.h[4] + e;
        this.h[5] = this.h[5] + f;
        this.h[6] = this.h[6] + g;
        this.h[7] = this.h[7] + hh;
    }

    public void init() {
        for (int i = 0; i < 64; ++i) {
            this.w[i] = 0;
        }
        this.length[1] = 0;
        this.length[0] = 0;
        this.h[0] = 1779033703;
        this.h[1] = -1150833019;
        this.h[2] = 1013904242;
        this.h[3] = -1521486534;
        this.h[4] = 1359893119;
        this.h[5] = -1694144372;
        this.h[6] = 528734635;
        this.h[7] = 1541459225;
    }

    public HASH256() {
        this.init();
    }

    public void process(int byt) {
        int cnt;
        int n = cnt = this.length[0] / 32 % 16;
        this.w[n] = this.w[n] << 8;
        int n2 = cnt;
        this.w[n2] = this.w[n2] | byt & 0xFF;
        this.length[0] = this.length[0] + 8;
        if (this.length[0] == 0) {
            this.length[1] = this.length[1] + 1;
            this.length[0] = 0;
        }
        if (this.length[0] % 512 == 0) {
            this.transform();
        }
    }

    public void process_array(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.process(b[i]);
        }
    }

    public void process_num(int n) {
        this.process(n >> 24 & 0xFF);
        this.process(n >> 16 & 0xFF);
        this.process(n >> 8 & 0xFF);
        this.process(n & 0xFF);
    }

    public byte[] hash() {
        byte[] digest = new byte[32];
        int len0 = this.length[0];
        int len1 = this.length[1];
        this.process(128);
        while (this.length[0] % 512 != 448) {
            this.process(0);
        }
        this.w[14] = len1;
        this.w[15] = len0;
        this.transform();
        for (int i = 0; i < 32; ++i) {
            digest[i] = (byte)(this.h[i / 4] >> 8 * (3 - i % 4) & 0xFF);
        }
        this.init();
        return digest;
    }

    public static void main(String[] args) {
        int i;
        byte[] test = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq".getBytes();
        HASH256 sh = new HASH256();
        for (i = 0; i < test.length; ++i) {
            sh.process(test[i]);
        }
        byte[] digest = sh.hash();
        for (i = 0; i < 32; ++i) {
            System.out.format("%02x", digest[i]);
        }
        System.out.println("");
    }
}

