/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BN254CX;

import org.apache.milagro.amcl.BN254CX.BIG;
import org.apache.milagro.amcl.BN254CX.FP2;
import org.apache.milagro.amcl.BN254CX.ROM;

public final class ECP2 {
    private FP2 x;
    private FP2 y;
    private FP2 z;

    public ECP2() {
        this.x = new FP2(0);
        this.y = new FP2(1);
        this.z = new FP2(0);
    }

    public ECP2(ECP2 e) {
        this.x = new FP2(e.x);
        this.y = new FP2(e.y);
        this.z = new FP2(e.z);
    }

    public boolean is_infinity() {
        return this.x.iszilch() && this.z.iszilch();
    }

    public void copy(ECP2 P) {
        this.x.copy(P.x);
        this.y.copy(P.y);
        this.z.copy(P.z);
    }

    public void inf() {
        this.x.zero();
        this.y.one();
        this.z.zero();
    }

    public void cmove(ECP2 Q, int d) {
        this.x.cmove(Q.x, d);
        this.y.cmove(Q.y, d);
        this.z.cmove(Q.z, d);
    }

    public static int teq(int b, int c) {
        int x = b ^ c;
        return --x >> 31 & 1;
    }

    public void select(ECP2[] W, int b) {
        ECP2 MP = new ECP2();
        int m = b >> 31;
        int babs = (b ^ m) - m;
        babs = (babs - 1) / 2;
        this.cmove(W[0], ECP2.teq(babs, 0));
        this.cmove(W[1], ECP2.teq(babs, 1));
        this.cmove(W[2], ECP2.teq(babs, 2));
        this.cmove(W[3], ECP2.teq(babs, 3));
        this.cmove(W[4], ECP2.teq(babs, 4));
        this.cmove(W[5], ECP2.teq(babs, 5));
        this.cmove(W[6], ECP2.teq(babs, 6));
        this.cmove(W[7], ECP2.teq(babs, 7));
        MP.copy(this);
        MP.neg();
        this.cmove(MP, m & 1);
    }

    public boolean equals(ECP2 Q) {
        FP2 a = new FP2(this.x);
        FP2 b = new FP2(Q.x);
        a.mul(Q.z);
        b.mul(this.z);
        if (!a.equals(b)) {
            return false;
        }
        a.copy(this.y);
        a.mul(Q.z);
        b.copy(Q.y);
        b.mul(this.z);
        return a.equals(b);
    }

    public void neg() {
        this.y.norm();
        this.y.neg();
        this.y.norm();
    }

    public void affine() {
        if (this.is_infinity()) {
            return;
        }
        FP2 one = new FP2(1);
        if (this.z.equals(one)) {
            this.x.reduce();
            this.y.reduce();
            return;
        }
        this.z.inverse();
        this.x.mul(this.z);
        this.x.reduce();
        this.y.mul(this.z);
        this.y.reduce();
        this.z.copy(one);
    }

    public FP2 getX() {
        ECP2 W = new ECP2(this);
        W.affine();
        return W.x;
    }

    public FP2 getY() {
        ECP2 W = new ECP2(this);
        W.affine();
        return W.y;
    }

    public FP2 getx() {
        return this.x;
    }

    public FP2 gety() {
        return this.y;
    }

    public FP2 getz() {
        return this.z;
    }

    public void toBytes(byte[] b) {
        int i;
        byte[] t = new byte[32];
        ECP2 W = new ECP2(this);
        W.affine();
        W.x.getA().toBytes(t);
        for (i = 0; i < 32; ++i) {
            b[i] = t[i];
        }
        W.x.getB().toBytes(t);
        for (i = 0; i < 32; ++i) {
            b[i + 32] = t[i];
        }
        W.y.getA().toBytes(t);
        for (i = 0; i < 32; ++i) {
            b[i + 64] = t[i];
        }
        W.y.getB().toBytes(t);
        for (i = 0; i < 32; ++i) {
            b[i + 96] = t[i];
        }
    }

    public static ECP2 fromBytes(byte[] b) {
        int i;
        int i2;
        byte[] t = new byte[32];
        for (i2 = 0; i2 < 32; ++i2) {
            t[i2] = b[i2];
        }
        BIG ra = BIG.fromBytes(t);
        for (i2 = 0; i2 < 32; ++i2) {
            t[i2] = b[i2 + 32];
        }
        BIG rb = BIG.fromBytes(t);
        FP2 rx = new FP2(ra, rb);
        for (i = 0; i < 32; ++i) {
            t[i] = b[i + 64];
        }
        ra = BIG.fromBytes(t);
        for (i = 0; i < 32; ++i) {
            t[i] = b[i + 96];
        }
        rb = BIG.fromBytes(t);
        FP2 ry = new FP2(ra, rb);
        return new ECP2(rx, ry);
    }

    public String toString() {
        ECP2 W = new ECP2(this);
        W.affine();
        if (W.is_infinity()) {
            return "infinity";
        }
        return "(" + W.x.toString() + "," + W.y.toString() + ")";
    }

    public static FP2 RHS(FP2 x) {
        x.norm();
        FP2 r = new FP2(x);
        r.sqr();
        FP2 b = new FP2(new BIG(ROM.CURVE_B));
        b.div_ip();
        r.mul(x);
        r.add(b);
        r.reduce();
        return r;
    }

    public ECP2(FP2 ix, FP2 iy) {
        this.x = new FP2(ix);
        this.y = new FP2(iy);
        this.z = new FP2(1);
        FP2 rhs = ECP2.RHS(this.x);
        FP2 y2 = new FP2(this.y);
        y2.sqr();
        if (!y2.equals(rhs)) {
            this.inf();
        }
    }

    public ECP2(FP2 ix) {
        this.x = new FP2(ix);
        this.y = new FP2(1);
        this.z = new FP2(1);
        FP2 rhs = ECP2.RHS(this.x);
        if (rhs.sqrt()) {
            this.y.copy(rhs);
        } else {
            this.inf();
        }
    }

    public int dbl() {
        FP2 iy = new FP2(this.y);
        iy.mul_ip();
        iy.norm();
        FP2 t0 = new FP2(this.y);
        t0.sqr();
        t0.mul_ip();
        FP2 t1 = new FP2(iy);
        t1.mul(this.z);
        FP2 t2 = new FP2(this.z);
        t2.sqr();
        this.z.copy(t0);
        this.z.add(t0);
        this.z.norm();
        this.z.add(this.z);
        this.z.add(this.z);
        this.z.norm();
        t2.imul(6);
        FP2 x3 = new FP2(t2);
        x3.mul(this.z);
        FP2 y3 = new FP2(t0);
        y3.add(t2);
        y3.norm();
        this.z.mul(t1);
        t1.copy(t2);
        t1.add(t2);
        t2.add(t1);
        t2.norm();
        t0.sub(t2);
        t0.norm();
        y3.mul(t0);
        y3.add(x3);
        t1.copy(this.x);
        t1.mul(iy);
        this.x.copy(t0);
        this.x.norm();
        this.x.mul(t1);
        this.x.add(this.x);
        this.x.norm();
        this.y.copy(y3);
        this.y.norm();
        return 1;
    }

    public int add(ECP2 Q) {
        int b = 6;
        FP2 t0 = new FP2(this.x);
        t0.mul(Q.x);
        FP2 t1 = new FP2(this.y);
        t1.mul(Q.y);
        FP2 t2 = new FP2(this.z);
        t2.mul(Q.z);
        FP2 t3 = new FP2(this.x);
        t3.add(this.y);
        t3.norm();
        FP2 t4 = new FP2(Q.x);
        t4.add(Q.y);
        t4.norm();
        t3.mul(t4);
        t4.copy(t0);
        t4.add(t1);
        t3.sub(t4);
        t3.norm();
        t3.mul_ip();
        t3.norm();
        t4.copy(this.y);
        t4.add(this.z);
        t4.norm();
        FP2 x3 = new FP2(Q.y);
        x3.add(Q.z);
        x3.norm();
        t4.mul(x3);
        x3.copy(t1);
        x3.add(t2);
        t4.sub(x3);
        t4.norm();
        t4.mul_ip();
        t4.norm();
        x3.copy(this.x);
        x3.add(this.z);
        x3.norm();
        FP2 y3 = new FP2(Q.x);
        y3.add(Q.z);
        y3.norm();
        x3.mul(y3);
        y3.copy(t0);
        y3.add(t2);
        y3.rsub(x3);
        y3.norm();
        t0.mul_ip();
        t0.norm();
        t1.mul_ip();
        t1.norm();
        x3.copy(t0);
        x3.add(t0);
        t0.add(x3);
        t0.norm();
        t2.imul(b);
        FP2 z3 = new FP2(t1);
        z3.add(t2);
        z3.norm();
        t1.sub(t2);
        t1.norm();
        y3.imul(b);
        x3.copy(y3);
        x3.mul(t4);
        t2.copy(t3);
        t2.mul(t1);
        x3.rsub(t2);
        y3.mul(t0);
        t1.mul(z3);
        y3.add(t1);
        t0.mul(t3);
        z3.mul(t4);
        z3.add(t0);
        this.x.copy(x3);
        this.x.norm();
        this.y.copy(y3);
        this.y.norm();
        this.z.copy(z3);
        this.z.norm();
        return 0;
    }

    public int sub(ECP2 Q) {
        ECP2 NQ = new ECP2(Q);
        NQ.neg();
        int D = this.add(NQ);
        return D;
    }

    public void frob(FP2 X) {
        FP2 X2 = new FP2(X);
        X2.sqr();
        this.x.conj();
        this.y.conj();
        this.z.conj();
        this.z.reduce();
        this.x.mul(X2);
        this.y.mul(X2);
        this.y.mul(X);
    }

    public ECP2 mul(BIG e) {
        int i;
        BIG mt = new BIG();
        BIG t = new BIG();
        ECP2 P = new ECP2();
        ECP2 Q = new ECP2();
        ECP2 C = new ECP2();
        ECP2[] W = new ECP2[8];
        byte[] w = new byte[71];
        if (this.is_infinity()) {
            return new ECP2();
        }
        Q.copy(this);
        Q.dbl();
        W[0] = new ECP2();
        W[0].copy(this);
        for (i = 1; i < 8; ++i) {
            W[i] = new ECP2();
            W[i].copy(W[i - 1]);
            W[i].add(Q);
        }
        t.copy(e);
        int s = t.parity();
        t.inc(1);
        t.norm();
        int ns = t.parity();
        mt.copy(t);
        mt.inc(1);
        mt.norm();
        t.cmove(mt, s);
        Q.cmove(this, ns);
        C.copy(Q);
        int nb = 1 + (t.nbits() + 3) / 4;
        for (i = 0; i < nb; ++i) {
            w[i] = (byte)(t.lastbits(5) - 16);
            t.dec(w[i]);
            t.norm();
            t.fshr(4);
        }
        w[nb] = (byte)t.lastbits(5);
        P.copy(W[(w[nb] - 1) / 2]);
        for (i = nb - 1; i >= 0; --i) {
            Q.select(W, w[i]);
            P.dbl();
            P.dbl();
            P.dbl();
            P.dbl();
            P.add(Q);
        }
        P.sub(C);
        P.affine();
        return P;
    }

    public static ECP2 mul4(ECP2[] Q, BIG[] u) {
        int i;
        ECP2 W = new ECP2();
        ECP2 P = new ECP2();
        ECP2[] T = new ECP2[8];
        BIG mt = new BIG();
        BIG[] t = new BIG[4];
        byte[] w = new byte[281];
        byte[] s = new byte[281];
        for (i = 0; i < 4; ++i) {
            t[i] = new BIG(u[i]);
            t[i].norm();
        }
        T[0] = new ECP2();
        T[0].copy(Q[0]);
        T[1] = new ECP2();
        T[1].copy(T[0]);
        T[1].add(Q[1]);
        T[2] = new ECP2();
        T[2].copy(T[0]);
        T[2].add(Q[2]);
        T[3] = new ECP2();
        T[3].copy(T[1]);
        T[3].add(Q[2]);
        T[4] = new ECP2();
        T[4].copy(T[0]);
        T[4].add(Q[3]);
        T[5] = new ECP2();
        T[5].copy(T[1]);
        T[5].add(Q[3]);
        T[6] = new ECP2();
        T[6].copy(T[2]);
        T[6].add(Q[3]);
        T[7] = new ECP2();
        T[7].copy(T[3]);
        T[7].add(Q[3]);
        int pb = 1 - t[0].parity();
        t[0].inc(pb);
        t[0].norm();
        mt.zero();
        for (i = 0; i < 4; ++i) {
            mt.or(t[i]);
        }
        int nb = 1 + mt.nbits();
        s[nb - 1] = 1;
        for (i = 0; i < nb - 1; ++i) {
            t[0].fshr(1);
            s[i] = (byte)(2 * t[0].parity() - 1);
        }
        for (i = 0; i < nb; ++i) {
            w[i] = 0;
            int k = 1;
            for (int j = 1; j < 4; ++j) {
                byte bt = (byte)(s[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w[n] = (byte)(w[n] + bt * (byte)k);
                k *= 2;
            }
        }
        P.select(T, 2 * w[nb - 1] + 1);
        for (i = nb - 2; i >= 0; --i) {
            P.dbl();
            W.select(T, 2 * w[i] + s[i]);
            P.add(W);
        }
        W.copy(P);
        W.sub(Q[0]);
        P.cmove(W, pb);
        P.affine();
        return P;
    }

    public static ECP2 mapit(byte[] h) {
        FP2 X;
        ECP2 Q;
        BIG q = new BIG(ROM.Modulus);
        BIG x = BIG.fromBytes(h);
        BIG one = new BIG(1);
        x.mod(q);
        while ((Q = new ECP2(X = new FP2(one, x))).is_infinity()) {
            x.inc(1);
            x.norm();
        }
        BIG Fra = new BIG(ROM.Fra);
        BIG Frb = new BIG(ROM.Frb);
        X = new FP2(Fra, Frb);
        x = new BIG(ROM.CURVE_Bnx);
        ECP2 T = new ECP2();
        T.copy(Q);
        T = T.mul(x);
        T.neg();
        ECP2 K = new ECP2();
        K.copy(T);
        K.dbl();
        K.add(T);
        K.frob(X);
        Q.frob(X);
        Q.frob(X);
        Q.frob(X);
        Q.add(T);
        Q.add(K);
        T.frob(X);
        T.frob(X);
        Q.add(T);
        Q.affine();
        return Q;
    }

    public static ECP2 generator() {
        return new ECP2(new FP2(new BIG(ROM.CURVE_Pxa), new BIG(ROM.CURVE_Pxb)), new FP2(new BIG(ROM.CURVE_Pya), new BIG(ROM.CURVE_Pyb)));
    }
}

