/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BN254CX;

import org.apache.milagro.amcl.BN254CX.BIG;
import org.apache.milagro.amcl.BN254CX.FP;
import org.apache.milagro.amcl.BN254CX.ROM;

public final class ECP {
    public static final int WEIERSTRASS = 0;
    public static final int EDWARDS = 1;
    public static final int MONTGOMERY = 2;
    public static final int NOT = 0;
    public static final int BN = 1;
    public static final int BLS = 2;
    public static final int D_TYPE = 0;
    public static final int M_TYPE = 1;
    public static final int POSITIVEX = 0;
    public static final int NEGATIVEX = 1;
    public static final int CURVETYPE = 0;
    public static final int CURVE_PAIRING_TYPE = 1;
    public static final int SEXTIC_TWIST = 0;
    public static final int SIGN_OF_X = 1;
    public static final int SHA256 = 32;
    public static final int SHA384 = 48;
    public static final int SHA512 = 64;
    public static final int HASH_TYPE = 32;
    public static final int AESKEY = 16;
    private FP x;
    private FP y;
    private FP z;

    public ECP() {
        this.x = new FP(0);
        this.y = new FP(1);
        this.z = new FP(0);
    }

    public ECP(ECP e) {
        this.x = new FP(e.x);
        this.y = new FP(e.y);
        this.z = new FP(e.z);
    }

    public boolean is_infinity() {
        return this.x.iszilch() && this.z.iszilch();
    }

    private void cswap(ECP Q, int d) {
        this.x.cswap(Q.x, d);
        this.y.cswap(Q.y, d);
        this.z.cswap(Q.z, d);
    }

    private void cmove(ECP Q, int d) {
        this.x.cmove(Q.x, d);
        this.y.cmove(Q.y, d);
        this.z.cmove(Q.z, d);
    }

    private static int teq(int b, int c) {
        int x = b ^ c;
        return --x >> 31 & 1;
    }

    private void select(ECP[] W, int b) {
        ECP MP = new ECP();
        int m = b >> 31;
        int babs = (b ^ m) - m;
        babs = (babs - 1) / 2;
        this.cmove(W[0], ECP.teq(babs, 0));
        this.cmove(W[1], ECP.teq(babs, 1));
        this.cmove(W[2], ECP.teq(babs, 2));
        this.cmove(W[3], ECP.teq(babs, 3));
        this.cmove(W[4], ECP.teq(babs, 4));
        this.cmove(W[5], ECP.teq(babs, 5));
        this.cmove(W[6], ECP.teq(babs, 6));
        this.cmove(W[7], ECP.teq(babs, 7));
        MP.copy(this);
        MP.neg();
        this.cmove(MP, m & 1);
    }

    public boolean equals(ECP Q) {
        FP a = new FP(0);
        FP b = new FP(0);
        a.copy(this.x);
        a.mul(Q.z);
        b.copy(Q.x);
        b.mul(this.z);
        if (!a.equals(b)) {
            return false;
        }
        a.copy(this.y);
        a.mul(Q.z);
        b.copy(Q.y);
        b.mul(this.z);
        return a.equals(b);
    }

    public void copy(ECP P) {
        this.x.copy(P.x);
        this.y.copy(P.y);
        this.z.copy(P.z);
    }

    public void neg() {
        this.y.neg();
        this.y.norm();
    }

    public void inf() {
        this.x.zero();
        this.y.one();
        this.z.zero();
    }

    public static FP RHS(FP x) {
        x.norm();
        FP r = new FP(x);
        r.sqr();
        FP b = new FP(new BIG(ROM.CURVE_B));
        r.mul(x);
        r.add(b);
        r.reduce();
        return r;
    }

    public ECP(BIG ix, BIG iy) {
        this.x = new FP(ix);
        this.y = new FP(iy);
        this.z = new FP(1);
        FP rhs = ECP.RHS(this.x);
        FP y2 = new FP(this.y);
        y2.sqr();
        if (!y2.equals(rhs)) {
            this.inf();
        }
    }

    public ECP(BIG ix, int s) {
        this.x = new FP(ix);
        FP rhs = ECP.RHS(this.x);
        this.y = new FP(0);
        this.z = new FP(1);
        if (rhs.jacobi() == 1) {
            FP ny = rhs.sqrt();
            if (ny.redc().parity() != s) {
                ny.neg();
            }
            this.y.copy(ny);
        } else {
            this.inf();
        }
    }

    public ECP(BIG ix) {
        this.x = new FP(ix);
        FP rhs = ECP.RHS(this.x);
        this.y = new FP(0);
        this.z = new FP(1);
        if (rhs.jacobi() == 1) {
            this.y.copy(rhs.sqrt());
        } else {
            this.inf();
        }
    }

    public void affine() {
        if (this.is_infinity()) {
            return;
        }
        FP one = new FP(1);
        if (this.z.equals(one)) {
            return;
        }
        this.z.inverse();
        this.x.mul(this.z);
        this.x.reduce();
        this.y.mul(this.z);
        this.y.reduce();
        this.z.copy(one);
    }

    public BIG getX() {
        ECP W = new ECP(this);
        W.affine();
        return W.x.redc();
    }

    public BIG getY() {
        ECP W = new ECP(this);
        W.affine();
        return W.y.redc();
    }

    public int getS() {
        BIG y = this.getY();
        return y.parity();
    }

    public FP getx() {
        return this.x;
    }

    public FP gety() {
        return this.y;
    }

    public FP getz() {
        return this.z;
    }

    public void toBytes(byte[] b, boolean compress) {
        int i;
        byte[] t = new byte[32];
        ECP W = new ECP(this);
        W.affine();
        W.x.redc().toBytes(t);
        for (i = 0; i < 32; ++i) {
            b[i + 1] = t[i];
        }
        if (compress) {
            b[0] = 2;
            if (this.y.redc().parity() == 1) {
                b[0] = 3;
            }
            return;
        }
        b[0] = 4;
        W.y.redc().toBytes(t);
        for (i = 0; i < 32; ++i) {
            b[i + 32 + 1] = t[i];
        }
    }

    public static ECP fromBytes(byte[] b) {
        byte[] t = new byte[32];
        BIG p = new BIG(ROM.Modulus);
        for (int i = 0; i < 32; ++i) {
            t[i] = b[i + 1];
        }
        BIG px = BIG.fromBytes(t);
        if (BIG.comp(px, p) >= 0) {
            return new ECP();
        }
        if (b[0] == 4) {
            for (int i = 0; i < 32; ++i) {
                t[i] = b[i + 32 + 1];
            }
            BIG py = BIG.fromBytes(t);
            if (BIG.comp(py, p) >= 0) {
                return new ECP();
            }
            return new ECP(px, py);
        }
        if (b[0] == 2 || b[0] == 3) {
            return new ECP(px, b[0] & 1);
        }
        return new ECP();
    }

    public String toString() {
        ECP W = new ECP(this);
        W.affine();
        if (W.is_infinity()) {
            return "infinity";
        }
        return "(" + W.x.redc().toString() + "," + W.y.redc().toString() + ")";
    }

    public String toRawString() {
        ECP W = new ECP(this);
        return "(" + W.x.redc().toString() + "," + W.y.redc().toString() + "," + W.z.redc().toString() + ")";
    }

    public void dbl() {
        FP t0 = new FP(this.y);
        t0.sqr();
        FP t1 = new FP(this.y);
        t1.mul(this.z);
        FP t2 = new FP(this.z);
        t2.sqr();
        this.z.copy(t0);
        this.z.add(t0);
        this.z.norm();
        this.z.add(this.z);
        this.z.add(this.z);
        this.z.norm();
        t2.imul(6);
        FP x3 = new FP(t2);
        x3.mul(this.z);
        FP y3 = new FP(t0);
        y3.add(t2);
        y3.norm();
        this.z.mul(t1);
        t1.copy(t2);
        t1.add(t2);
        t2.add(t1);
        t0.sub(t2);
        t0.norm();
        y3.mul(t0);
        y3.add(x3);
        t1.copy(this.x);
        t1.mul(this.y);
        this.x.copy(t0);
        this.x.norm();
        this.x.mul(t1);
        this.x.add(this.x);
        this.x.norm();
        this.y.copy(y3);
        this.y.norm();
    }

    public void add(ECP Q) {
        int b = 6;
        FP t0 = new FP(this.x);
        t0.mul(Q.x);
        FP t1 = new FP(this.y);
        t1.mul(Q.y);
        FP t2 = new FP(this.z);
        t2.mul(Q.z);
        FP t3 = new FP(this.x);
        t3.add(this.y);
        t3.norm();
        FP t4 = new FP(Q.x);
        t4.add(Q.y);
        t4.norm();
        t3.mul(t4);
        t4.copy(t0);
        t4.add(t1);
        t3.sub(t4);
        t3.norm();
        t4.copy(this.y);
        t4.add(this.z);
        t4.norm();
        FP x3 = new FP(Q.y);
        x3.add(Q.z);
        x3.norm();
        t4.mul(x3);
        x3.copy(t1);
        x3.add(t2);
        t4.sub(x3);
        t4.norm();
        x3.copy(this.x);
        x3.add(this.z);
        x3.norm();
        FP y3 = new FP(Q.x);
        y3.add(Q.z);
        y3.norm();
        x3.mul(y3);
        y3.copy(t0);
        y3.add(t2);
        y3.rsub(x3);
        y3.norm();
        x3.copy(t0);
        x3.add(t0);
        t0.add(x3);
        t0.norm();
        t2.imul(b);
        FP z3 = new FP(t1);
        z3.add(t2);
        z3.norm();
        t1.sub(t2);
        t1.norm();
        y3.imul(b);
        x3.copy(y3);
        x3.mul(t4);
        t2.copy(t3);
        t2.mul(t1);
        x3.rsub(t2);
        y3.mul(t0);
        t1.mul(z3);
        y3.add(t1);
        t0.mul(t3);
        z3.mul(t4);
        z3.add(t0);
        this.x.copy(x3);
        this.x.norm();
        this.y.copy(y3);
        this.y.norm();
        this.z.copy(z3);
        this.z.norm();
    }

    public void dadd(ECP Q, ECP W) {
        FP A = new FP(this.x);
        FP B = new FP(this.x);
        FP C = new FP(Q.x);
        FP D = new FP(Q.x);
        FP DA = new FP(0);
        FP CB = new FP(0);
        A.add(this.z);
        B.sub(this.z);
        C.add(Q.z);
        D.sub(Q.z);
        A.norm();
        D.norm();
        DA.copy(D);
        DA.mul(A);
        C.norm();
        B.norm();
        CB.copy(C);
        CB.mul(B);
        A.copy(DA);
        A.add(CB);
        A.norm();
        A.sqr();
        B.copy(DA);
        B.sub(CB);
        B.norm();
        B.sqr();
        this.x.copy(A);
        this.z.copy(W.x);
        this.z.mul(B);
    }

    public void sub(ECP Q) {
        ECP NQ = new ECP(Q);
        NQ.neg();
        this.add(NQ);
    }

    public ECP pinmul(int e, int bts) {
        ECP P = new ECP();
        ECP R0 = new ECP();
        ECP R1 = new ECP();
        R1.copy(this);
        for (int i = bts - 1; i >= 0; --i) {
            int b = e >> i & 1;
            P.copy(R1);
            P.add(R0);
            R0.cswap(R1, b);
            R1.copy(P);
            R0.dbl();
            R0.cswap(R1, b);
        }
        P.copy(R0);
        P.affine();
        return P;
    }

    public ECP mul(BIG e) {
        int i;
        if (e.iszilch() || this.is_infinity()) {
            return new ECP();
        }
        ECP P = new ECP();
        BIG mt = new BIG();
        BIG t = new BIG();
        ECP Q = new ECP();
        ECP C = new ECP();
        ECP[] W = new ECP[8];
        byte[] w = new byte[71];
        Q.copy(this);
        Q.dbl();
        W[0] = new ECP();
        W[0].copy(this);
        for (i = 1; i < 8; ++i) {
            W[i] = new ECP();
            W[i].copy(W[i - 1]);
            W[i].add(Q);
        }
        t.copy(e);
        int s = t.parity();
        t.inc(1);
        t.norm();
        int ns = t.parity();
        mt.copy(t);
        mt.inc(1);
        mt.norm();
        t.cmove(mt, s);
        Q.cmove(this, ns);
        C.copy(Q);
        int nb = 1 + (t.nbits() + 3) / 4;
        for (i = 0; i < nb; ++i) {
            w[i] = (byte)(t.lastbits(5) - 16);
            t.dec(w[i]);
            t.norm();
            t.fshr(4);
        }
        w[nb] = (byte)t.lastbits(5);
        P.copy(W[(w[nb] - 1) / 2]);
        for (i = nb - 1; i >= 0; --i) {
            Q.select(W, w[i]);
            P.dbl();
            P.dbl();
            P.dbl();
            P.dbl();
            P.add(Q);
        }
        P.sub(C);
        P.affine();
        return P;
    }

    public ECP mul2(BIG e, ECP Q, BIG f) {
        int i;
        BIG te = new BIG();
        BIG tf = new BIG();
        BIG mt = new BIG();
        ECP S = new ECP();
        ECP T = new ECP();
        ECP C = new ECP();
        ECP[] W = new ECP[8];
        byte[] w = new byte[141];
        te.copy(e);
        tf.copy(f);
        W[1] = new ECP();
        W[1].copy(this);
        W[1].sub(Q);
        W[2] = new ECP();
        W[2].copy(this);
        W[2].add(Q);
        S.copy(Q);
        S.dbl();
        W[0] = new ECP();
        W[0].copy(W[1]);
        W[0].sub(S);
        W[3] = new ECP();
        W[3].copy(W[2]);
        W[3].add(S);
        T.copy(this);
        T.dbl();
        W[5] = new ECP();
        W[5].copy(W[1]);
        W[5].add(T);
        W[6] = new ECP();
        W[6].copy(W[2]);
        W[6].add(T);
        W[4] = new ECP();
        W[4].copy(W[5]);
        W[4].sub(S);
        W[7] = new ECP();
        W[7].copy(W[6]);
        W[7].add(S);
        int s = te.parity();
        te.inc(1);
        te.norm();
        int ns = te.parity();
        mt.copy(te);
        mt.inc(1);
        mt.norm();
        te.cmove(mt, s);
        T.cmove(this, ns);
        C.copy(T);
        s = tf.parity();
        tf.inc(1);
        tf.norm();
        ns = tf.parity();
        mt.copy(tf);
        mt.inc(1);
        mt.norm();
        tf.cmove(mt, s);
        S.cmove(Q, ns);
        C.add(S);
        mt.copy(te);
        mt.add(tf);
        mt.norm();
        int nb = 1 + (mt.nbits() + 1) / 2;
        for (i = 0; i < nb; ++i) {
            byte a = (byte)(te.lastbits(3) - 4);
            te.dec(a);
            te.norm();
            te.fshr(2);
            byte b = (byte)(tf.lastbits(3) - 4);
            tf.dec(b);
            tf.norm();
            tf.fshr(2);
            w[i] = (byte)(4 * a + b);
        }
        w[nb] = (byte)(4 * te.lastbits(3) + tf.lastbits(3));
        S.copy(W[(w[nb] - 1) / 2]);
        for (i = nb - 1; i >= 0; --i) {
            T.select(W, w[i]);
            S.dbl();
            S.dbl();
            S.add(T);
        }
        S.sub(C);
        S.affine();
        return S;
    }

    public void cfp() {
        int cf = 1;
        if (cf == 1) {
            return;
        }
        if (cf == 4) {
            this.dbl();
            this.dbl();
            return;
        }
        if (cf == 8) {
            this.dbl();
            this.dbl();
            this.dbl();
            return;
        }
        BIG c = new BIG(ROM.CURVE_Cof);
        this.copy(this.mul(c));
    }

    /*
     * Unable to fully structure code
     */
    public static ECP mapit(byte[] h) {
        q = new BIG(ROM.Modulus);
        x = BIG.fromBytes(h);
        x.mod(q);
        do lbl-1000:
        // 3 sources

        {
            P = new ECP(x, 0);
            x.inc(1);
            x.norm();
            if (P.is_infinity()) ** GOTO lbl-1000
            P.cfp();
        } while (P.is_infinity());
        return P;
    }

    public static ECP generator() {
        BIG gx = new BIG(ROM.CURVE_Gx);
        BIG gy = new BIG(ROM.CURVE_Gy);
        ECP G = new ECP(gx, gy);
        return G;
    }
}

