/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BN254CX;

import org.apache.milagro.amcl.BN254CX.DBIG;
import org.apache.milagro.amcl.RAND;

public class BIG {
    public static final int CHUNK = 64;
    public static final int MODBYTES = 32;
    public static final int BASEBITS = 56;
    public static final int NLEN = 5;
    public static final int DNLEN = 10;
    public static final long BMASK = 0xFFFFFFFFFFFFFFL;
    public static final int HBITS = 28;
    public static final long HMASK = 0xFFFFFFFL;
    public static final int NEXCESS = 128;
    public static final int BIGBITS = 256;
    protected long[] w = new long[5];

    public BIG() {
        for (int i = 0; i < 5; ++i) {
            this.w[i] = 0L;
        }
    }

    public BIG(int x) {
        this.w[0] = x;
        for (int i = 1; i < 5; ++i) {
            this.w[i] = 0L;
        }
    }

    public BIG(BIG x) {
        for (int i = 0; i < 5; ++i) {
            this.w[i] = x.w[i];
        }
    }

    public BIG(DBIG x) {
        for (int i = 0; i < 5; ++i) {
            this.w[i] = x.w[i];
        }
    }

    public BIG(long[] x) {
        for (int i = 0; i < 5; ++i) {
            this.w[i] = x[i];
        }
    }

    public long get(int i) {
        return this.w[i];
    }

    public void set(int i, long x) {
        this.w[i] = x;
    }

    public void cswap(BIG b, int d) {
        long c = d;
        c = c - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        int i = 0;
        while (i < 5) {
            long t = c & (this.w[i] ^ b.w[i]);
            int n = i;
            this.w[n] = this.w[n] ^ t;
            int n2 = i++;
            b.w[n2] = b.w[n2] ^ t;
        }
    }

    public void cmove(BIG g, int d) {
        long b = -d;
        for (int i = 0; i < 5; ++i) {
            int n = i;
            this.w[n] = this.w[n] ^ (this.w[i] ^ g.w[i]) & b;
        }
    }

    public static long cast_to_chunk(int x) {
        return x;
    }

    public long norm() {
        long carry = 0L;
        for (int i = 0; i < 4; ++i) {
            long d = this.w[i] + carry;
            this.w[i] = d & 0xFFFFFFFFFFFFFFL;
            carry = d >> 56;
        }
        this.w[4] = this.w[4] + carry;
        return this.w[4] >> 32;
    }

    public int nbits() {
        int k;
        BIG t = new BIG(this);
        t.norm();
        for (k = 4; k >= 0 && t.w[k] == 0L; --k) {
        }
        if (k < 0) {
            return 0;
        }
        int bts = 56 * k;
        long c = t.w[k];
        while (c != 0L) {
            c /= 2L;
            ++bts;
        }
        return bts;
    }

    public String toRawString() {
        BIG b = new BIG(this);
        String s = "(";
        for (int i = 0; i < 4; ++i) {
            s = s + Long.toHexString(b.w[i]);
            s = s + ",";
        }
        s = s + Long.toHexString(b.w[4]);
        s = s + ")";
        return s;
    }

    public String toString() {
        String s = "";
        int len = this.nbits();
        if (len % 4 == 0) {
            len /= 4;
        } else {
            len /= 4;
            ++len;
        }
        if (len < 64) {
            len = 64;
        }
        for (int i = len - 1; i >= 0; --i) {
            BIG b = new BIG(this);
            b.shr(i * 4);
            s = s + Long.toHexString(b.w[0] & 0xFL);
        }
        return s;
    }

    public static long[] muladd(long a, long b, long c, long r) {
        long[] tb = new long[2];
        long x0 = a & 0xFFFFFFFL;
        long x1 = a >> 28;
        long y0 = b & 0xFFFFFFFL;
        long y1 = b >> 28;
        long bot = x0 * y0;
        long top = x1 * y1;
        long mid = x0 * y1 + x1 * y0;
        x0 = mid & 0xFFFFFFFL;
        x1 = mid >> 28;
        bot += x0 << 28;
        bot += c;
        top += x1;
        long carry = (bot += r) >> 56;
        tb[0] = top += carry;
        tb[1] = bot &= 0xFFFFFFFFFFFFFFL;
        return tb;
    }

    public long pmul(int c) {
        long carry = 0L;
        long[] cr = new long[2];
        for (int i = 0; i < 5; ++i) {
            long ak = this.w[i];
            this.w[i] = 0L;
            cr = BIG.muladd(ak, c, carry, this.w[i]);
            carry = cr[0];
            this.w[i] = cr[1];
        }
        return carry;
    }

    public DBIG pxmul(int c) {
        DBIG m = new DBIG(0);
        long[] cr = new long[2];
        long carry = 0L;
        for (int j = 0; j < 5; ++j) {
            cr = BIG.muladd(this.w[j], c, carry, m.w[j]);
            carry = cr[0];
            m.w[j] = cr[1];
        }
        m.w[5] = carry;
        return m;
    }

    public int div3() {
        long carry = 0L;
        this.norm();
        long base = 0x100000000000000L;
        for (int i = 4; i >= 0; --i) {
            long ak = carry * base + this.w[i];
            this.w[i] = ak / 3L;
            carry = ak % 3L;
        }
        return (int)carry;
    }

    public static BIG smul(BIG a, BIG b) {
        long[] cr = new long[2];
        BIG c = new BIG(0);
        for (int i = 0; i < 5; ++i) {
            long carry = 0L;
            for (int j = 0; j < 5; ++j) {
                if (i + j >= 5) continue;
                cr = BIG.muladd(a.w[i], b.w[j], carry, c.w[i + j]);
                carry = cr[0];
                c.w[i + j] = cr[1];
            }
        }
        return c;
    }

    public static DBIG mul(BIG a, BIG b) {
        DBIG c = new DBIG(0);
        long[] cr = new long[2];
        for (int i = 0; i < 5; ++i) {
            long carry = 0L;
            for (int j = 0; j < 5; ++j) {
                cr = BIG.muladd(a.w[i], b.w[j], carry, c.w[i + j]);
                carry = cr[0];
                c.w[i + j] = cr[1];
            }
            c.w[5 + i] = carry;
        }
        return c;
    }

    public static DBIG sqr(BIG a) {
        int i;
        DBIG c = new DBIG(0);
        long[] cr = new long[2];
        for (i = 0; i < 5; ++i) {
            long carry = 0L;
            for (int j = i + 1; j < 5; ++j) {
                cr = BIG.muladd(2L * a.w[i], a.w[j], carry, c.w[i + j]);
                carry = cr[0];
                c.w[i + j] = cr[1];
            }
            c.w[5 + i] = carry;
        }
        for (i = 0; i < 5; ++i) {
            cr = BIG.muladd(a.w[i], a.w[i], 0L, c.w[2 * i]);
            int n = 2 * i + 1;
            c.w[n] = c.w[n] + cr[0];
            c.w[2 * i] = cr[1];
        }
        c.norm();
        return c;
    }

    static BIG monty(BIG md, long MC, DBIG d) {
        int i;
        long[] cr = new long[2];
        for (i = 0; i < 5; ++i) {
            long m = MC == -1L ? -d.w[i] & 0xFFFFFFFFFFFFFFL : (MC == 1L ? d.w[i] : MC * d.w[i] & 0xFFFFFFFFFFFFFFL);
            long carry = 0L;
            for (int j = 0; j < 5; ++j) {
                cr = BIG.muladd(m, md.w[j], carry, d.w[i + j]);
                carry = cr[0];
                d.w[i + j] = cr[1];
            }
            int n = 5 + i;
            d.w[n] = d.w[n] + carry;
        }
        BIG b = new BIG(0);
        for (i = 0; i < 5; ++i) {
            b.w[i] = d.w[5 + i];
        }
        b.norm();
        return b;
    }

    public void xortop(long x) {
        this.w[4] = this.w[4] ^ x;
    }

    public void mod2m(int m) {
        int wd = m / 56;
        int bt = m % 56;
        int n = wd;
        this.w[n] = this.w[n] & (BIG.cast_to_chunk(1) << bt) - 1L;
        for (int i = wd + 1; i < 5; ++i) {
            this.w[i] = 0L;
        }
    }

    public int bit(int n) {
        if ((this.w[n / 56] & BIG.cast_to_chunk(1) << n % 56) > 0L) {
            return 1;
        }
        return 0;
    }

    public int fshr(int k) {
        int r = (int)(this.w[0] & (BIG.cast_to_chunk(1) << k) - 1L);
        for (int i = 0; i < 4; ++i) {
            this.w[i] = this.w[i] >> k | this.w[i + 1] << 56 - k & 0xFFFFFFFFFFFFFFL;
        }
        this.w[4] = this.w[4] >> k;
        return r;
    }

    public int fshl(int k) {
        this.w[4] = this.w[4] << k | this.w[3] >> 56 - k;
        for (int i = 3; i > 0; --i) {
            this.w[i] = this.w[i] << k & 0xFFFFFFFFFFFFFFL | this.w[i - 1] >> 56 - k;
        }
        this.w[0] = this.w[0] << k & 0xFFFFFFFFFFFFFFL;
        return (int)(this.w[4] >> 32);
    }

    public boolean iszilch() {
        for (int i = 0; i < 5; ++i) {
            if (this.w[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public void zero() {
        for (int i = 0; i < 5; ++i) {
            this.w[i] = 0L;
        }
    }

    public void one() {
        this.w[0] = 1L;
        for (int i = 1; i < 5; ++i) {
            this.w[i] = 0L;
        }
    }

    public boolean isunity() {
        for (int i = 1; i < 5; ++i) {
            if (this.w[i] == 0L) continue;
            return false;
        }
        return this.w[0] == 1L;
    }

    public void copy(BIG x) {
        for (int i = 0; i < 5; ++i) {
            this.w[i] = x.w[i];
        }
    }

    public void copy(DBIG x) {
        for (int i = 0; i < 5; ++i) {
            this.w[i] = x.w[i];
        }
    }

    public void shr(int k) {
        int i;
        int n = k % 56;
        int m = k / 56;
        for (i = 0; i < 5 - m - 1; ++i) {
            this.w[i] = this.w[m + i] >> n | this.w[m + i + 1] << 56 - n & 0xFFFFFFFFFFFFFFL;
        }
        if (5 > m) {
            this.w[5 - m - 1] = this.w[4] >> n;
        }
        for (i = 5 - m; i < 5; ++i) {
            this.w[i] = 0L;
        }
    }

    public void shl(int k) {
        int i;
        int n = k % 56;
        int m = k / 56;
        this.w[4] = this.w[4 - m] << n;
        if (5 >= m + 2) {
            this.w[4] = this.w[4] | this.w[5 - m - 2] >> 56 - n;
        }
        for (i = 3; i > m; --i) {
            this.w[i] = this.w[i - m] << n & 0xFFFFFFFFFFFFFFL | this.w[i - m - 1] >> 56 - n;
        }
        this.w[m] = this.w[0] << n & 0xFFFFFFFFFFFFFFL;
        for (i = 0; i < m; ++i) {
            this.w[i] = 0L;
        }
    }

    public BIG plus(BIG x) {
        BIG s = new BIG(0);
        for (int i = 0; i < 5; ++i) {
            s.w[i] = this.w[i] + x.w[i];
        }
        return s;
    }

    public void add(BIG x) {
        for (int i = 0; i < 5; ++i) {
            int n = i;
            this.w[n] = this.w[n] + x.w[i];
        }
    }

    public void or(BIG x) {
        for (int i = 0; i < 5; ++i) {
            int n = i;
            this.w[n] = this.w[n] | x.w[i];
        }
    }

    public void inc(int x) {
        this.norm();
        this.w[0] = this.w[0] + (long)x;
    }

    public void incl(long x) {
        this.norm();
        this.w[0] = this.w[0] + x;
    }

    public BIG minus(BIG x) {
        BIG d = new BIG(0);
        for (int i = 0; i < 5; ++i) {
            d.w[i] = this.w[i] - x.w[i];
        }
        return d;
    }

    public void sub(BIG x) {
        for (int i = 0; i < 5; ++i) {
            int n = i;
            this.w[n] = this.w[n] - x.w[i];
        }
    }

    public void rsub(BIG x) {
        for (int i = 0; i < 5; ++i) {
            this.w[i] = x.w[i] - this.w[i];
        }
    }

    public void dec(int x) {
        this.norm();
        this.w[0] = this.w[0] - (long)x;
    }

    public void imul(int c) {
        int i = 0;
        while (i < 5) {
            int n = i++;
            this.w[n] = this.w[n] * (long)c;
        }
    }

    public void tobytearray(byte[] b, int n) {
        BIG c = new BIG(this);
        c.norm();
        for (int i = 31; i >= 0; --i) {
            b[i + n] = (byte)c.w[0];
            c.fshr(8);
        }
    }

    public static BIG frombytearray(byte[] b, int n) {
        BIG m = new BIG(0);
        for (int i = 0; i < 32; ++i) {
            m.fshl(8);
            m.w[0] = m.w[0] + (long)(b[i + n] & 0xFF);
        }
        return m;
    }

    public void toBytes(byte[] b) {
        this.tobytearray(b, 0);
    }

    public static BIG fromBytes(byte[] b) {
        return BIG.frombytearray(b, 0);
    }

    public static int comp(BIG a, BIG b) {
        for (int i = 4; i >= 0; --i) {
            if (a.w[i] == b.w[i]) continue;
            if (a.w[i] > b.w[i]) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public static int invmod256(int a) {
        int t1 = 0;
        int c = a >> 1 & 1;
        t1 += c;
        t1 &= 1;
        t1 = 2 - t1;
        int U = (t1 <<= 1) + 1;
        int b = a & 3;
        t1 = U * b;
        t1 >>= 2;
        c = a >> 2 & 3;
        int t2 = U * c & 3;
        t1 += t2;
        t1 *= U;
        t1 &= 3;
        t1 = 4 - t1;
        b = a & 0xF;
        t1 = (U += (t1 <<= 2)) * b;
        t1 >>= 4;
        c = a >> 4 & 0xF;
        t2 = U * c & 0xF;
        t1 += t2;
        t1 *= U;
        t1 &= 0xF;
        t1 = 16 - t1;
        return U += (t1 <<= 4);
    }

    public void invmod2m() {
        BIG U = new BIG(0);
        BIG b = new BIG(0);
        BIG c = new BIG(0);
        U.inc(BIG.invmod256(this.lastbits(8)));
        for (int i = 8; i < 256; i <<= 1) {
            U.norm();
            b.copy(this);
            b.mod2m(i);
            BIG t1 = BIG.smul(U, b);
            t1.shr(i);
            c.copy(this);
            c.shr(i);
            c.mod2m(i);
            BIG t2 = BIG.smul(U, c);
            t2.mod2m(i);
            t1.add(t2);
            t1.norm();
            b = BIG.smul(t1, U);
            t1.copy(b);
            t1.mod2m(i);
            t2.one();
            t2.shl(i);
            t1.rsub(t2);
            t1.norm();
            t1.shl(i);
            U.add(t1);
        }
        U.mod2m(256);
        this.copy(U);
        this.norm();
    }

    public void mod(BIG m1) {
        int k = 0;
        BIG r = new BIG(0);
        BIG m = new BIG(m1);
        this.norm();
        if (BIG.comp(this, m) < 0) {
            return;
        }
        do {
            m.fshl(1);
            ++k;
        } while (BIG.comp(this, m) >= 0);
        while (k > 0) {
            m.fshr(1);
            r.copy(this);
            r.sub(m);
            r.norm();
            this.cmove(r, (int)(1L - (r.w[4] >> 63 & 1L)));
            --k;
        }
    }

    public void div(BIG m1) {
        int k = 0;
        this.norm();
        BIG e = new BIG(1);
        BIG m = new BIG(m1);
        BIG b = new BIG(this);
        BIG r = new BIG(0);
        this.zero();
        while (BIG.comp(b, m) >= 0) {
            e.fshl(1);
            m.fshl(1);
            ++k;
        }
        while (k > 0) {
            m.fshr(1);
            e.fshr(1);
            r.copy(b);
            r.sub(m);
            r.norm();
            int d = (int)(1L - (r.w[4] >> 63 & 1L));
            b.cmove(r, d);
            r.copy(this);
            r.add(e);
            r.norm();
            this.cmove(r, d);
            --k;
        }
    }

    public int parity() {
        return (int)(this.w[0] % 2L);
    }

    public int lastbits(int n) {
        int msk = (1 << n) - 1;
        this.norm();
        return (int)this.w[0] & msk;
    }

    public static BIG random(RAND rng) {
        BIG m = new BIG(0);
        int j = 0;
        int r = 0;
        for (int i = 0; i < 256; ++i) {
            r = j == 0 ? rng.getByte() : (r >>= 1);
            int b = r & 1;
            m.shl(1);
            m.w[0] = m.w[0] + (long)b;
            ++j;
            j &= 7;
        }
        return m;
    }

    public static BIG randomnum(BIG q, RAND rng) {
        DBIG d = new DBIG(0);
        int j = 0;
        int r = 0;
        for (int i = 0; i < 2 * q.nbits(); ++i) {
            r = j == 0 ? rng.getByte() : (r >>= 1);
            int b = r & 1;
            d.shl(1);
            d.w[0] = d.w[0] + (long)b;
            ++j;
            j &= 7;
        }
        BIG m = d.mod(q);
        return m;
    }

    public static BIG modmul(BIG a1, BIG b1, BIG m) {
        BIG a = new BIG(a1);
        BIG b = new BIG(b1);
        a.mod(m);
        b.mod(m);
        DBIG d = BIG.mul(a, b);
        return d.mod(m);
    }

    public static BIG modsqr(BIG a1, BIG m) {
        BIG a = new BIG(a1);
        a.mod(m);
        DBIG d = BIG.sqr(a);
        return d.mod(m);
    }

    public static BIG modneg(BIG a1, BIG m) {
        BIG a = new BIG(a1);
        a.mod(m);
        return m.minus(a);
    }

    public BIG powmod(BIG e1, BIG m) {
        BIG e = new BIG(e1);
        this.norm();
        e.norm();
        BIG a = new BIG(1);
        BIG z = new BIG(e);
        BIG s = new BIG(this);
        while (true) {
            int bt = z.parity();
            z.fshr(1);
            if (bt == 1) {
                a = BIG.modmul(a, s, m);
            }
            if (z.iszilch()) break;
            s = BIG.modsqr(s, m);
        }
        return a;
    }

    public int jacobi(BIG p) {
        int m = 0;
        BIG t = new BIG(0);
        BIG x = new BIG(0);
        BIG n = new BIG(0);
        BIG zilch = new BIG(0);
        BIG one = new BIG(1);
        if (p.parity() == 0 || BIG.comp(this, zilch) == 0 || BIG.comp(p, one) <= 0) {
            return 0;
        }
        this.norm();
        x.copy(this);
        n.copy(p);
        x.mod(p);
        while (BIG.comp(n, one) > 0) {
            if (BIG.comp(x, zilch) == 0) {
                return 0;
            }
            int n8 = n.lastbits(3);
            int k = 0;
            while (x.parity() == 0) {
                ++k;
                x.shr(1);
            }
            if (k % 2 == 1) {
                m += (n8 * n8 - 1) / 8;
            }
            m += (n8 - 1) * (x.lastbits(2) - 1) / 4;
            t.copy(n);
            t.mod(x);
            n.copy(x);
            x.copy(t);
            m %= 2;
        }
        if (m == 0) {
            return 1;
        }
        return -1;
    }

    public void invmodp(BIG p) {
        this.mod(p);
        BIG u = new BIG(this);
        BIG v = new BIG(p);
        BIG x1 = new BIG(1);
        BIG x2 = new BIG(0);
        BIG t = new BIG(0);
        BIG one = new BIG(1);
        while (BIG.comp(u, one) != 0 && BIG.comp(v, one) != 0) {
            while (u.parity() == 0) {
                u.fshr(1);
                if (x1.parity() != 0) {
                    x1.add(p);
                    x1.norm();
                }
                x1.fshr(1);
            }
            while (v.parity() == 0) {
                v.fshr(1);
                if (x2.parity() != 0) {
                    x2.add(p);
                    x2.norm();
                }
                x2.fshr(1);
            }
            if (BIG.comp(u, v) >= 0) {
                u.sub(v);
                u.norm();
                if (BIG.comp(x1, x2) >= 0) {
                    x1.sub(x2);
                } else {
                    t.copy(p);
                    t.sub(x2);
                    x1.add(t);
                }
                x1.norm();
                continue;
            }
            v.sub(u);
            v.norm();
            if (BIG.comp(x2, x1) >= 0) {
                x2.sub(x1);
            } else {
                t.copy(p);
                t.sub(x1);
                x2.add(t);
            }
            x2.norm();
        }
        if (BIG.comp(u, one) == 0) {
            this.copy(x1);
        } else {
            this.copy(x2);
        }
    }
}

