/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BLS48;

import org.apache.milagro.amcl.BLS48.BIG;
import org.apache.milagro.amcl.BLS48.FP16;
import org.apache.milagro.amcl.BLS48.FP2;
import org.apache.milagro.amcl.BLS48.FP4;
import org.apache.milagro.amcl.BLS48.FP8;
import org.apache.milagro.amcl.BLS48.ROM;

public final class FP48 {
    private final FP16 a;
    private final FP16 b;
    private final FP16 c;

    public void reduce() {
        this.a.reduce();
        this.b.reduce();
        this.c.reduce();
    }

    public void norm() {
        this.a.norm();
        this.b.norm();
        this.c.norm();
    }

    public boolean iszilch() {
        return this.a.iszilch() && this.b.iszilch() && this.c.iszilch();
    }

    public void cmove(FP48 g, int d) {
        this.a.cmove(g.a, d);
        this.b.cmove(g.b, d);
        this.c.cmove(g.c, d);
    }

    public static int teq(int b, int c) {
        int x = b ^ c;
        return --x >> 31 & 1;
    }

    public void select(FP48[] g, int b) {
        int m = b >> 31;
        int babs = (b ^ m) - m;
        babs = (babs - 1) / 2;
        this.cmove(g[0], FP48.teq(babs, 0));
        this.cmove(g[1], FP48.teq(babs, 1));
        this.cmove(g[2], FP48.teq(babs, 2));
        this.cmove(g[3], FP48.teq(babs, 3));
        this.cmove(g[4], FP48.teq(babs, 4));
        this.cmove(g[5], FP48.teq(babs, 5));
        this.cmove(g[6], FP48.teq(babs, 6));
        this.cmove(g[7], FP48.teq(babs, 7));
        FP48 invf = new FP48(this);
        invf.conj();
        this.cmove(invf, m & 1);
    }

    public boolean isunity() {
        FP16 one = new FP16(1);
        return this.a.equals(one) && this.b.iszilch() && this.c.iszilch();
    }

    public boolean equals(FP48 x) {
        return this.a.equals(x.a) && this.b.equals(x.b) && this.c.equals(x.c);
    }

    public FP16 geta() {
        return this.a;
    }

    public FP16 getb() {
        return this.b;
    }

    public FP16 getc() {
        return this.c;
    }

    public void copy(FP48 x) {
        this.a.copy(x.a);
        this.b.copy(x.b);
        this.c.copy(x.c);
    }

    public void one() {
        this.a.one();
        this.b.zero();
        this.c.zero();
    }

    public void conj() {
        this.a.conj();
        this.b.nconj();
        this.c.conj();
    }

    public FP48(FP16 d) {
        this.a = new FP16(d);
        this.b = new FP16(0);
        this.c = new FP16(0);
    }

    public FP48(int d) {
        this.a = new FP16(d);
        this.b = new FP16(0);
        this.c = new FP16(0);
    }

    public FP48(FP16 d, FP16 e, FP16 f) {
        this.a = new FP16(d);
        this.b = new FP16(e);
        this.c = new FP16(f);
    }

    public FP48(FP48 x) {
        this.a = new FP16(x.a);
        this.b = new FP16(x.b);
        this.c = new FP16(x.c);
    }

    public void usqr() {
        FP16 A = new FP16(this.a);
        FP16 B = new FP16(this.c);
        FP16 C = new FP16(this.b);
        FP16 D = new FP16(0);
        this.a.sqr();
        D.copy(this.a);
        D.add(this.a);
        this.a.add(D);
        this.a.norm();
        A.nconj();
        A.add(A);
        this.a.add(A);
        B.sqr();
        B.times_i();
        D.copy(B);
        D.add(B);
        B.add(D);
        B.norm();
        C.sqr();
        D.copy(C);
        D.add(C);
        C.add(D);
        C.norm();
        this.b.conj();
        this.b.add(this.b);
        this.c.nconj();
        this.c.add(this.c);
        this.b.add(B);
        this.c.add(C);
        this.reduce();
    }

    public void sqr() {
        FP16 A = new FP16(this.a);
        FP16 B = new FP16(this.b);
        FP16 C = new FP16(this.c);
        FP16 D = new FP16(this.a);
        A.sqr();
        B.mul(this.c);
        B.add(B);
        B.norm();
        C.sqr();
        D.mul(this.b);
        D.add(D);
        this.c.add(this.a);
        this.c.add(this.b);
        this.c.norm();
        this.c.sqr();
        this.a.copy(A);
        A.add(B);
        A.norm();
        A.add(C);
        A.add(D);
        A.norm();
        A.neg();
        B.times_i();
        C.times_i();
        this.a.add(B);
        this.b.copy(C);
        this.b.add(D);
        this.c.add(A);
        this.norm();
    }

    public void mul(FP48 y) {
        FP16 z0 = new FP16(this.a);
        FP16 z1 = new FP16(0);
        FP16 z2 = new FP16(this.b);
        FP16 z3 = new FP16(0);
        FP16 t0 = new FP16(this.a);
        FP16 t1 = new FP16(y.a);
        z0.mul(y.a);
        z2.mul(y.b);
        t0.add(this.b);
        t1.add(y.b);
        t0.norm();
        t1.norm();
        z1.copy(t0);
        z1.mul(t1);
        t0.copy(this.b);
        t0.add(this.c);
        t1.copy(y.b);
        t1.add(y.c);
        t0.norm();
        t1.norm();
        z3.copy(t0);
        z3.mul(t1);
        t0.copy(z0);
        t0.neg();
        t1.copy(z2);
        t1.neg();
        z1.add(t0);
        this.b.copy(z1);
        this.b.add(t1);
        z3.add(t1);
        z2.add(t0);
        t0.copy(this.a);
        t0.add(this.c);
        t1.copy(y.a);
        t1.add(y.c);
        t0.norm();
        t1.norm();
        t0.mul(t1);
        z2.add(t0);
        t0.copy(this.c);
        t0.mul(y.c);
        t1.copy(t0);
        t1.neg();
        this.c.copy(z2);
        this.c.add(t1);
        z3.add(t1);
        t0.times_i();
        this.b.add(t0);
        z3.norm();
        z3.times_i();
        this.a.copy(z0);
        this.a.add(z3);
        this.norm();
    }

    public void smul(FP48 y, int type) {
        FP16 z0;
        if (type == 0) {
            z0 = new FP16(this.a);
            FP16 z2 = new FP16(this.b);
            FP16 z3 = new FP16(this.b);
            FP16 t0 = new FP16(0);
            FP16 t1 = new FP16(y.a);
            z0.mul(y.a);
            z2.pmul(y.b.real());
            this.b.add(this.a);
            t1.real().add(y.b.real());
            t1.norm();
            this.b.norm();
            this.b.mul(t1);
            z3.add(this.c);
            z3.norm();
            z3.pmul(y.b.real());
            t0.copy(z0);
            t0.neg();
            t1.copy(z2);
            t1.neg();
            this.b.add(t0);
            this.b.add(t1);
            z3.add(t1);
            z2.add(t0);
            t0.copy(this.a);
            t0.add(this.c);
            t0.norm();
            z3.norm();
            t0.mul(y.a);
            this.c.copy(z2);
            this.c.add(t0);
            z3.times_i();
            this.a.copy(z0);
            this.a.add(z3);
        }
        if (type == 1) {
            z0 = new FP16(this.a);
            FP16 z1 = new FP16(0);
            FP16 z2 = new FP16(0);
            FP16 z3 = new FP16(0);
            FP16 t0 = new FP16(this.a);
            FP16 t1 = new FP16(0);
            z0.mul(y.a);
            t0.add(this.b);
            t0.norm();
            z1.copy(t0);
            z1.mul(y.a);
            t0.copy(this.b);
            t0.add(this.c);
            t0.norm();
            z3.copy(t0);
            z3.pmul(y.c.getb());
            z3.times_i();
            t0.copy(z0);
            t0.neg();
            z1.add(t0);
            this.b.copy(z1);
            z2.copy(t0);
            t0.copy(this.a);
            t0.add(this.c);
            t1.copy(y.a);
            t1.add(y.c);
            t0.norm();
            t1.norm();
            t0.mul(t1);
            z2.add(t0);
            t0.copy(this.c);
            t0.pmul(y.c.getb());
            t0.times_i();
            t1.copy(t0);
            t1.neg();
            this.c.copy(z2);
            this.c.add(t1);
            z3.add(t1);
            t0.times_i();
            this.b.add(t0);
            z3.norm();
            z3.times_i();
            this.a.copy(z0);
            this.a.add(z3);
        }
        this.norm();
    }

    public void inverse() {
        FP16 f0 = new FP16(this.a);
        FP16 f1 = new FP16(this.b);
        FP16 f2 = new FP16(this.a);
        FP16 f3 = new FP16(0);
        this.norm();
        f0.sqr();
        f1.mul(this.c);
        f1.times_i();
        f0.sub(f1);
        f0.norm();
        f1.copy(this.c);
        f1.sqr();
        f1.times_i();
        f2.mul(this.b);
        f1.sub(f2);
        f1.norm();
        f2.copy(this.b);
        f2.sqr();
        f3.copy(this.a);
        f3.mul(this.c);
        f2.sub(f3);
        f2.norm();
        f3.copy(this.b);
        f3.mul(f2);
        f3.times_i();
        this.a.mul(f0);
        f3.add(this.a);
        this.c.mul(f1);
        this.c.times_i();
        f3.add(this.c);
        f3.norm();
        f3.inverse();
        this.a.copy(f0);
        this.a.mul(f3);
        this.b.copy(f1);
        this.b.mul(f3);
        this.c.copy(f2);
        this.c.mul(f3);
    }

    public void frob(FP2 f, int n) {
        FP2 f2 = new FP2(f);
        FP2 f3 = new FP2(f);
        f2.sqr();
        f3.mul(f2);
        f3.mul_ip();
        f3.norm();
        f3.mul_ip();
        f3.norm();
        for (int i = 0; i < n; ++i) {
            this.a.frob(f3);
            this.b.frob(f3);
            this.c.frob(f3);
            this.b.qmul(f);
            this.b.times_i4();
            this.b.times_i2();
            this.c.qmul(f2);
            this.c.times_i4();
            this.c.times_i4();
            this.c.times_i4();
        }
    }

    public FP16 trace() {
        FP16 t = new FP16(0);
        t.copy(this.a);
        t.imul(3);
        t.reduce();
        return t;
    }

    public static FP48 fromBytes(byte[] w) {
        int i;
        byte[] t = new byte[70];
        for (i = 0; i < 70; ++i) {
            t[i] = w[i];
        }
        BIG a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 70];
        }
        BIG b = BIG.fromBytes(t);
        FP2 c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 140];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 210];
        }
        b = BIG.fromBytes(t);
        FP2 d = new FP2(a, b);
        FP4 ea = new FP4(c, d);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 280];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 350];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 420];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 490];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        FP4 eb = new FP4(c, d);
        FP8 fa = new FP8(ea, eb);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 560];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 630];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 700];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 770];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        ea = new FP4(c, d);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 840];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 910];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 980];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1050];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        eb = new FP4(c, d);
        FP8 fb = new FP8(ea, eb);
        FP16 e = new FP16(fa, fb);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1120];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1190];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1260];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1330];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        ea = new FP4(c, d);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1400];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1470];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1540];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1610];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        eb = new FP4(c, d);
        fa = new FP8(ea, eb);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1680];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1750];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1820];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1890];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        ea = new FP4(c, d);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 1960];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2030];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2100];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2170];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        eb = new FP4(c, d);
        fb = new FP8(ea, eb);
        FP16 f = new FP16(fa, fb);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2240];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2310];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2380];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2450];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        ea = new FP4(c, d);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2520];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2590];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2660];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2730];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        eb = new FP4(c, d);
        fa = new FP8(ea, eb);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2800];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2870];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 2940];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 3010];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        ea = new FP4(c, d);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 3080];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 3150];
        }
        b = BIG.fromBytes(t);
        c = new FP2(a, b);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 3220];
        }
        a = BIG.fromBytes(t);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i + 3290];
        }
        b = BIG.fromBytes(t);
        d = new FP2(a, b);
        eb = new FP4(c, d);
        fb = new FP8(ea, eb);
        FP16 g = new FP16(fa, fb);
        return new FP48(e, f, g);
    }

    public void toBytes(byte[] w) {
        int i;
        byte[] t = new byte[70];
        this.a.geta().geta().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i] = t[i];
        }
        this.a.geta().geta().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 70] = t[i];
        }
        this.a.geta().geta().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 140] = t[i];
        }
        this.a.geta().geta().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 210] = t[i];
        }
        this.a.geta().getb().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 280] = t[i];
        }
        this.a.geta().getb().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 350] = t[i];
        }
        this.a.geta().getb().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 420] = t[i];
        }
        this.a.geta().getb().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 490] = t[i];
        }
        this.a.getb().geta().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 560] = t[i];
        }
        this.a.getb().geta().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 630] = t[i];
        }
        this.a.getb().geta().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 700] = t[i];
        }
        this.a.getb().geta().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 770] = t[i];
        }
        this.a.getb().getb().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 840] = t[i];
        }
        this.a.getb().getb().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 910] = t[i];
        }
        this.a.getb().getb().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 980] = t[i];
        }
        this.a.getb().getb().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1050] = t[i];
        }
        this.b.geta().geta().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1120] = t[i];
        }
        this.b.geta().geta().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1190] = t[i];
        }
        this.b.geta().geta().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1260] = t[i];
        }
        this.b.geta().geta().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1330] = t[i];
        }
        this.b.geta().getb().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1400] = t[i];
        }
        this.b.geta().getb().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1470] = t[i];
        }
        this.b.geta().getb().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1540] = t[i];
        }
        this.b.geta().getb().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1610] = t[i];
        }
        this.b.getb().geta().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1680] = t[i];
        }
        this.b.getb().geta().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1750] = t[i];
        }
        this.b.getb().geta().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1820] = t[i];
        }
        this.b.getb().geta().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1890] = t[i];
        }
        this.b.getb().getb().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 1960] = t[i];
        }
        this.b.getb().getb().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2030] = t[i];
        }
        this.b.getb().getb().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2100] = t[i];
        }
        this.b.getb().getb().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2170] = t[i];
        }
        this.c.geta().geta().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2240] = t[i];
        }
        this.c.geta().geta().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2310] = t[i];
        }
        this.c.geta().geta().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2380] = t[i];
        }
        this.c.geta().geta().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2450] = t[i];
        }
        this.c.geta().getb().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2520] = t[i];
        }
        this.c.geta().getb().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2590] = t[i];
        }
        this.c.geta().getb().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2660] = t[i];
        }
        this.c.geta().getb().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2730] = t[i];
        }
        this.c.getb().geta().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2800] = t[i];
        }
        this.c.getb().geta().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2870] = t[i];
        }
        this.c.getb().geta().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 2940] = t[i];
        }
        this.c.getb().geta().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 3010] = t[i];
        }
        this.c.getb().getb().geta().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 3080] = t[i];
        }
        this.c.getb().getb().geta().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 3150] = t[i];
        }
        this.c.getb().getb().getb().getA().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 3220] = t[i];
        }
        this.c.getb().getb().getb().getB().toBytes(t);
        for (i = 0; i < 70; ++i) {
            w[i + 3290] = t[i];
        }
    }

    public String toString() {
        return "[" + this.a.toString() + "," + this.b.toString() + "," + this.c.toString() + "]";
    }

    public FP48 pow(BIG e) {
        this.norm();
        e.norm();
        BIG e3 = new BIG(e);
        e3.pmul(3);
        e3.norm();
        FP48 w = new FP48(this);
        int nb = e3.nbits();
        for (int i = nb - 2; i >= 1; --i) {
            w.usqr();
            int bt = e3.bit(i) - e.bit(i);
            if (bt == 1) {
                w.mul(this);
            }
            if (bt != -1) continue;
            this.conj();
            w.mul(this);
            this.conj();
        }
        w.reduce();
        return w;
    }

    public void pinpow(int e, int bts) {
        FP48[] R = new FP48[]{new FP48(1), new FP48(this)};
        for (int i = bts - 1; i >= 0; --i) {
            int b = e >> i & 1;
            R[1 - b].mul(R[b]);
            R[b].usqr();
        }
        this.copy(R[0]);
    }

    public FP16 compow(BIG e, BIG r) {
        FP48 g1 = new FP48(0);
        FP48 g2 = new FP48(0);
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        BIG q = new BIG(ROM.Modulus);
        BIG m = new BIG(q);
        m.mod(r);
        BIG a = new BIG(e);
        a.mod(m);
        BIG b = new BIG(e);
        b.div(m);
        g1.copy(this);
        g2.copy(this);
        FP16 c = g1.trace();
        if (b.iszilch()) {
            c = c.xtr_pow(e);
            return c;
        }
        g2.frob(f, 1);
        FP16 cp = g2.trace();
        g1.conj();
        g2.mul(g1);
        FP16 cpm1 = g2.trace();
        g2.mul(g1);
        FP16 cpm2 = g2.trace();
        c = c.xtr_pow2(cp, cpm1, cpm2, a, b);
        return c;
    }

    public static FP48 pow16(FP48[] q, BIG[] u) {
        int i;
        FP48[] g1 = new FP48[8];
        FP48[] g2 = new FP48[8];
        FP48[] g3 = new FP48[8];
        FP48[] g4 = new FP48[8];
        FP48 r = new FP48(1);
        FP48 p = new FP48(0);
        BIG[] t = new BIG[16];
        BIG mt = new BIG(0);
        byte[] w1 = new byte[581];
        byte[] s1 = new byte[581];
        byte[] w2 = new byte[581];
        byte[] s2 = new byte[581];
        byte[] w3 = new byte[581];
        byte[] s3 = new byte[581];
        byte[] w4 = new byte[581];
        byte[] s4 = new byte[581];
        for (i = 0; i < 16; ++i) {
            t[i] = new BIG(u[i]);
            t[i].norm();
        }
        g1[0] = new FP48(q[0]);
        g1[1] = new FP48(g1[0]);
        g1[1].mul(q[1]);
        g1[2] = new FP48(g1[0]);
        g1[2].mul(q[2]);
        g1[3] = new FP48(g1[1]);
        g1[3].mul(q[2]);
        g1[4] = new FP48(q[0]);
        g1[4].mul(q[3]);
        g1[5] = new FP48(g1[1]);
        g1[5].mul(q[3]);
        g1[6] = new FP48(g1[2]);
        g1[6].mul(q[3]);
        g1[7] = new FP48(g1[3]);
        g1[7].mul(q[3]);
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        for (i = 0; i < 8; ++i) {
            g2[i] = new FP48(g1[i]);
            g2[i].frob(f, 4);
            g3[i] = new FP48(g2[i]);
            g3[i].frob(f, 4);
            g4[i] = new FP48(g3[i]);
            g4[i].frob(f, 4);
        }
        int pb1 = 1 - t[0].parity();
        t[0].inc(pb1);
        t[0].norm();
        int pb2 = 1 - t[4].parity();
        t[4].inc(pb2);
        t[4].norm();
        int pb3 = 1 - t[8].parity();
        t[8].inc(pb3);
        t[8].norm();
        int pb4 = 1 - t[12].parity();
        t[12].inc(pb4);
        t[12].norm();
        mt.zero();
        for (i = 0; i < 16; ++i) {
            mt.or(t[i]);
        }
        int nb = 1 + mt.nbits();
        s1[nb - 1] = 1;
        s2[nb - 1] = 1;
        s3[nb - 1] = 1;
        s4[nb - 1] = 1;
        for (i = 0; i < nb - 1; ++i) {
            t[0].fshr(1);
            s1[i] = (byte)(2 * t[0].parity() - 1);
            t[4].fshr(1);
            s2[i] = (byte)(2 * t[4].parity() - 1);
            t[8].fshr(1);
            s3[i] = (byte)(2 * t[8].parity() - 1);
            t[12].fshr(1);
            s4[i] = (byte)(2 * t[12].parity() - 1);
        }
        for (i = 0; i < nb; ++i) {
            byte bt;
            int j;
            w1[i] = 0;
            int k = 1;
            for (j = 1; j < 4; ++j) {
                bt = (byte)(s1[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w1[n] = (byte)(w1[n] + bt * (byte)k);
                k *= 2;
            }
            w2[i] = 0;
            k = 1;
            for (j = 5; j < 8; ++j) {
                bt = (byte)(s2[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w2[n] = (byte)(w2[n] + bt * (byte)k);
                k *= 2;
            }
            w3[i] = 0;
            k = 1;
            for (j = 9; j < 12; ++j) {
                bt = (byte)(s3[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w3[n] = (byte)(w3[n] + bt * (byte)k);
                k *= 2;
            }
            w4[i] = 0;
            k = 1;
            for (j = 13; j < 16; ++j) {
                bt = (byte)(s4[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w4[n] = (byte)(w4[n] + bt * (byte)k);
                k *= 2;
            }
        }
        p.select(g1, 2 * w1[nb - 1] + 1);
        r.select(g2, 2 * w2[nb - 1] + 1);
        p.mul(r);
        r.select(g3, 2 * w3[nb - 1] + 1);
        p.mul(r);
        r.select(g4, 2 * w4[nb - 1] + 1);
        p.mul(r);
        for (i = nb - 2; i >= 0; --i) {
            p.usqr();
            r.select(g1, 2 * w1[i] + s1[i]);
            p.mul(r);
            r.select(g2, 2 * w2[i] + s2[i]);
            p.mul(r);
            r.select(g3, 2 * w3[i] + s3[i]);
            p.mul(r);
            r.select(g4, 2 * w4[i] + s4[i]);
            p.mul(r);
        }
        r.copy(q[0]);
        r.conj();
        r.mul(p);
        p.cmove(r, pb1);
        r.copy(q[4]);
        r.conj();
        r.mul(p);
        p.cmove(r, pb2);
        r.copy(q[8]);
        r.conj();
        r.mul(p);
        p.cmove(r, pb3);
        r.copy(q[12]);
        r.conj();
        r.mul(p);
        p.cmove(r, pb4);
        p.reduce();
        return p;
    }
}

