/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BLS461;

import org.apache.milagro.amcl.BLS461.BIG;
import org.apache.milagro.amcl.BLS461.ECP;
import org.apache.milagro.amcl.BLS461.ECP2;
import org.apache.milagro.amcl.BLS461.FP;
import org.apache.milagro.amcl.BLS461.FP12;
import org.apache.milagro.amcl.BLS461.FP2;
import org.apache.milagro.amcl.BLS461.FP4;
import org.apache.milagro.amcl.BLS461.ROM;

public final class PAIR {
    public static final boolean USE_GLV = true;
    public static final boolean USE_GS_G2 = true;
    public static final boolean USE_GS_GT = true;
    public static final boolean GT_STRONG = false;

    public static FP12 line(ECP2 A, ECP2 B, FP Qx, FP Qy) {
        FP4 c;
        FP4 b;
        FP4 a;
        if (A == B) {
            FP2 XX = new FP2(A.getx());
            FP2 YY = new FP2(A.gety());
            FP2 ZZ = new FP2(A.getz());
            FP2 YZ = new FP2(YY);
            YZ.mul(ZZ);
            XX.sqr();
            YY.sqr();
            ZZ.sqr();
            YZ.imul(4);
            YZ.neg();
            YZ.norm();
            YZ.pmul(Qy);
            XX.imul(6);
            XX.pmul(Qx);
            int sb = 27;
            ZZ.imul(sb);
            ZZ.mul_ip();
            ZZ.add(ZZ);
            YZ.mul_ip();
            YZ.norm();
            ZZ.norm();
            YY.add(YY);
            ZZ.sub(YY);
            ZZ.norm();
            a = new FP4(YZ, ZZ);
            b = new FP4(0);
            c = new FP4(XX);
            c.times_i();
            A.dbl();
        } else {
            FP2 X1 = new FP2(A.getx());
            FP2 Y1 = new FP2(A.gety());
            FP2 T1 = new FP2(A.getz());
            FP2 T2 = new FP2(A.getz());
            T1.mul(B.gety());
            T2.mul(B.getx());
            X1.sub(T2);
            X1.norm();
            Y1.sub(T1);
            Y1.norm();
            T1.copy(X1);
            X1.pmul(Qy);
            X1.mul_ip();
            X1.norm();
            T1.mul(B.gety());
            T2.copy(Y1);
            T2.mul(B.getx());
            T2.sub(T1);
            T2.norm();
            Y1.pmul(Qx);
            Y1.neg();
            Y1.norm();
            a = new FP4(X1, T2);
            b = new FP4(0);
            c = new FP4(Y1);
            c.times_i();
            A.add(B);
        }
        return new FP12(a, b, c);
    }

    public static FP12 ate(ECP2 P1, ECP Q1) {
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG n = new BIG(x);
        ECP2 K = new ECP2();
        ECP2 P = new ECP2(P1);
        ECP Q = new ECP(Q1);
        P.affine();
        Q.affine();
        n.copy(x);
        n.norm();
        BIG n3 = new BIG(n);
        n3.pmul(3);
        n3.norm();
        FP Qx = new FP(Q.getx());
        FP Qy = new FP(Q.gety());
        ECP2 A = new ECP2();
        FP12 r = new FP12(1);
        A.copy(P);
        ECP2 MP = new ECP2();
        MP.copy(P);
        MP.neg();
        int nb = n3.nbits();
        for (int i = nb - 2; i >= 1; --i) {
            r.sqr();
            FP12 lv = PAIR.line(A, A, Qx, Qy);
            r.smul(lv, 1);
            int bt = n3.bit(i) - n.bit(i);
            if (bt == 1) {
                lv = PAIR.line(A, P, Qx, Qy);
                r.smul(lv, 1);
            }
            if (bt != -1) continue;
            lv = PAIR.line(A, MP, Qx, Qy);
            r.smul(lv, 1);
        }
        r.conj();
        return r;
    }

    public static FP12 ate2(ECP2 P1, ECP Q1, ECP2 R1, ECP S1) {
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG n = new BIG(x);
        ECP2 K = new ECP2();
        ECP2 P = new ECP2(P1);
        ECP Q = new ECP(Q1);
        P.affine();
        Q.affine();
        ECP2 R = new ECP2(R1);
        ECP S = new ECP(S1);
        R.affine();
        S.affine();
        n.copy(x);
        n.norm();
        BIG n3 = new BIG(n);
        n3.pmul(3);
        n3.norm();
        FP Qx = new FP(Q.getx());
        FP Qy = new FP(Q.gety());
        FP Sx = new FP(S.getx());
        FP Sy = new FP(S.gety());
        ECP2 A = new ECP2();
        ECP2 B = new ECP2();
        FP12 r = new FP12(1);
        A.copy(P);
        B.copy(R);
        ECP2 MP = new ECP2();
        MP.copy(P);
        MP.neg();
        ECP2 MR = new ECP2();
        MR.copy(R);
        MR.neg();
        int nb = n3.nbits();
        for (int i = nb - 2; i >= 1; --i) {
            r.sqr();
            FP12 lv = PAIR.line(A, A, Qx, Qy);
            r.smul(lv, 1);
            lv = PAIR.line(B, B, Sx, Sy);
            r.smul(lv, 1);
            int bt = n3.bit(i) - n.bit(i);
            if (bt == 1) {
                lv = PAIR.line(A, P, Qx, Qy);
                r.smul(lv, 1);
                lv = PAIR.line(B, R, Sx, Sy);
                r.smul(lv, 1);
            }
            if (bt != -1) continue;
            lv = PAIR.line(A, MP, Qx, Qy);
            r.smul(lv, 1);
            lv = PAIR.line(B, MR, Sx, Sy);
            r.smul(lv, 1);
        }
        r.conj();
        return r;
    }

    public static FP12 fexp(FP12 m) {
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        BIG x = new BIG(ROM.CURVE_Bnx);
        FP12 r = new FP12(m);
        FP12 lv = new FP12(r);
        lv.inverse();
        r.conj();
        r.mul(lv);
        lv.copy(r);
        r.frob(f);
        r.frob(f);
        r.mul(lv);
        FP12 y0 = new FP12(r);
        y0.usqr();
        FP12 y1 = y0.pow(x);
        y1.conj();
        x.fshr(1);
        FP12 y2 = y1.pow(x);
        y2.conj();
        x.fshl(1);
        FP12 y3 = new FP12(r);
        y3.conj();
        y1.mul(y3);
        y1.conj();
        y1.mul(y2);
        y2 = y1.pow(x);
        y2.conj();
        y3 = y2.pow(x);
        y3.conj();
        y1.conj();
        y3.mul(y1);
        y1.conj();
        y1.frob(f);
        y1.frob(f);
        y1.frob(f);
        y2.frob(f);
        y2.frob(f);
        y1.mul(y2);
        y2 = y3.pow(x);
        y2.conj();
        y2.mul(y0);
        y2.mul(r);
        y1.mul(y2);
        y2.copy(y3);
        y2.frob(f);
        y1.mul(y2);
        r.copy(y1);
        r.reduce();
        return r;
    }

    public static BIG[] glv(BIG e) {
        BIG[] u = new BIG[2];
        BIG q = new BIG(ROM.CURVE_Order);
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG x2 = BIG.smul(x, x);
        u[0] = new BIG(e);
        u[0].mod(x2);
        u[1] = new BIG(e);
        u[1].div(x2);
        u[1].rsub(q);
        return u;
    }

    public static BIG[] gs(BIG e) {
        BIG[] u = new BIG[4];
        BIG q = new BIG(ROM.CURVE_Order);
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG w = new BIG(e);
        for (int i = 0; i < 3; ++i) {
            u[i] = new BIG(w);
            u[i].mod(x);
            w.div(x);
        }
        u[3] = new BIG(w);
        u[1].copy(BIG.modneg(u[1], q));
        u[3].copy(BIG.modneg(u[3], q));
        return u;
    }

    public static ECP G1mul(ECP P, BIG e) {
        ECP R = new ECP();
        R.copy(P);
        ECP Q = new ECP();
        Q.copy(P);
        Q.affine();
        BIG q = new BIG(ROM.CURVE_Order);
        FP cru = new FP(new BIG(ROM.CURVE_Cru));
        BIG t = new BIG(0);
        BIG[] u = PAIR.glv(e);
        Q.getx().mul(cru);
        int np = u[0].nbits();
        t.copy(BIG.modneg(u[0], q));
        int nn = t.nbits();
        if (nn < np) {
            u[0].copy(t);
            R.neg();
        }
        np = u[1].nbits();
        t.copy(BIG.modneg(u[1], q));
        nn = t.nbits();
        if (nn < np) {
            u[1].copy(t);
            Q.neg();
        }
        u[0].norm();
        u[1].norm();
        R = R.mul2(u[0], Q, u[1]);
        return R;
    }

    public static ECP2 G2mul(ECP2 P, BIG e) {
        int i;
        ECP2[] Q = new ECP2[4];
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        f.inverse();
        f.norm();
        BIG q = new BIG(ROM.CURVE_Order);
        BIG[] u = PAIR.gs(e);
        BIG t = new BIG(0);
        Q[0] = new ECP2();
        Q[0].copy(P);
        for (i = 1; i < 4; ++i) {
            Q[i] = new ECP2();
            Q[i].copy(Q[i - 1]);
            Q[i].frob(f);
        }
        for (i = 0; i < 4; ++i) {
            int np = u[i].nbits();
            t.copy(BIG.modneg(u[i], q));
            int nn = t.nbits();
            if (nn < np) {
                u[i].copy(t);
                Q[i].neg();
            }
            u[i].norm();
        }
        ECP2 R = ECP2.mul4(Q, u);
        return R;
    }

    public static FP12 GTpow(FP12 d, BIG e) {
        int i;
        FP12[] g = new FP12[4];
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        BIG q = new BIG(ROM.CURVE_Order);
        BIG t = new BIG(0);
        BIG[] u = PAIR.gs(e);
        g[0] = new FP12(d);
        for (i = 1; i < 4; ++i) {
            g[i] = new FP12(0);
            g[i].copy(g[i - 1]);
            g[i].frob(f);
        }
        for (i = 0; i < 4; ++i) {
            int np = u[i].nbits();
            t.copy(BIG.modneg(u[i], q));
            int nn = t.nbits();
            if (nn < np) {
                u[i].copy(t);
                g[i].conj();
            }
            u[i].norm();
        }
        FP12 r = FP12.pow4(g, u);
        return r;
    }
}

