/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms.pool;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import jakarta.jms.XAConnection;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAResource;
import org.messaginghub.pooled.jms.JmsPoolSession;
import org.messaginghub.pooled.jms.pool.PooledConnection;
import org.messaginghub.pooled.jms.pool.PooledSessionKey;

public class PooledXAConnection
extends PooledConnection {
    private final TransactionManager transactionManager;

    public PooledXAConnection(Connection connection, TransactionManager transactionManager) {
        super(connection);
        this.transactionManager = transactionManager;
    }

    @Override
    protected Session makeSession(PooledSessionKey key) throws JMSException {
        return ((XAConnection)this.connection).createXASession();
    }

    @Override
    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        try {
            boolean isXa;
            boolean bl = isXa = this.transactionManager != null && this.transactionManager.getStatus() != 6;
            if (isXa) {
                transacted = false;
                ackMode = 2;
            } else if (this.transactionManager != null) {
                transacted = false;
                if (ackMode == 0) {
                    ackMode = 1;
                }
            }
            JmsPoolSession session = (JmsPoolSession)super.createSession(transacted, ackMode);
            session.setIgnoreClose(isXa);
            session.setIsXa(isXa);
            if (isXa) {
                this.incrementReferenceCount();
                JmsPooledXASessionSynchronization sync = new JmsPooledXASessionSynchronization(session);
                try {
                    this.transactionManager.getTransaction().registerSynchronization((Synchronization)sync);
                    if (!this.transactionManager.getTransaction().enlistResource(this.createXaResource(session))) {
                        throw new JMSException("Enlistment of Pooled Session into transaction failed");
                    }
                }
                catch (Exception ex) {
                    sync.fail();
                    throw ex;
                }
            }
            return session;
        }
        catch (RollbackException e) {
            JMSException jmsException = new JMSException("Rollback Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
        catch (SystemException e) {
            JMSException jmsException = new JMSException("System Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
    }

    protected XAResource createXaResource(JmsPoolSession session) throws JMSException {
        return session.getXAResource();
    }

    protected class JmsPooledXASessionSynchronization
    implements Synchronization {
        private final AtomicBoolean closed = new AtomicBoolean();
        private JmsPoolSession session;

        private JmsPooledXASessionSynchronization(JmsPoolSession session) {
            this.session = session;
        }

        public void fail() throws JMSException {
            if (this.closed.compareAndSet(false, true)) {
                try {
                    this.session.internalClose(true);
                }
                finally {
                    this.session = null;
                    PooledXAConnection.this.decrementReferenceCount();
                }
            }
        }

        public void close() throws JMSException {
            if (this.closed.compareAndSet(false, true)) {
                this.session.setIgnoreClose(false);
                try {
                    this.session.close();
                }
                finally {
                    this.session = null;
                    PooledXAConnection.this.decrementReferenceCount();
                }
            }
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.close();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

