## WeierstrassP

```
WeierstrassP(expr, {n1, n2})
```

> Weierstrass elliptic function.

See
* [Wikipedia - Weierstrass's elliptic functions](https://en.wikipedia.org/wiki/Weierstrass%27s_elliptic_functions)
* [Fungrim - Weierstrass elliptic functions](http://fungrim.org/topic/Weierstrass_elliptic_functions/)

### Examples

```
>> WeierstrassP(z, {3, 1})
1+3/2*Cot(Sqrt(3/2)*z)^2
```

### Github

* [Implementation of WeierstrassP](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/EllipticIntegrals.java#L1763) 
