## Quotient

```
Quotient(m, n)
```

> computes the integer quotient of `m` and `n`.

See 
* [Wikipedia - Quotient](https://en.wikipedia.org/wiki/Quotient)
* [Wikipedia - Remainder](https://en.wikipedia.org/wiki/Remainder)

### Examples

```
>> Quotient(23, 7)
3
```
 
Infinite expression `Quotient(13, 0)` encountered.

```
>> Quotient(13, 0)
ComplexInfinity

>> Quotient(-17, 7)
-3
 
>> Quotient(-17, -4)
4
 
>> Quotient(19, -4)
-5
```

### Github

* [Implementation of Quotient](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/IntegerFunctions.java#L1240) 
