## PrimePi

```
PrimePi(x)
```

> gives the number of primes less than or equal to `x`.


See
* [Wikipedia - Prime-counting function](https://en.wikipedia.org/wiki/Prime-counting_function)
* [Wikipedia - On the Number of Primes Less Than a Given Magnitude](https://en.wikipedia.org/wiki/On_the_Number_of_Primes_Less_Than_a_Given_Magnitude)
* [Fungrim - Prime numbers](http://fungrim.org/topic/Prime_numbers/)

### Examples

```
>> PrimePi(100)
25

>> PrimePi(-1)
0

>> PrimePi(3.5)
2

>> PrimePi(E)
1
```

### Github

* [Implementation of PrimePi](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/NumberTheory.java#L4152) 
