## HermiteH

```
HermiteH(n, x)
```

> returns the Hermite polynomial `H_n(x)`.


See:  
* [Wikipedia - Hermite polynomials](https://en.wikipedia.org/wiki/Hermite_polynomials)

### Examples

```   
>> HermiteH(8, x)    
1680-13440*x^2+13440*x^4-3584*x^6+256*x^8 
 
>> HermiteH(3, 1 + I)
-28+I*4    
```
    

### Github

* [Implementation of HermiteH](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/PolynomialFunctions.java#L1594) 
