## Degree constant

```
Degree
```

> the constant `Degree` converts angles from degree to `Pi/180` radians.
 
See:
* [Wikipedia - Degree (angle)](http://en.wikipedia.org/wiki/Degree_(angle)) 
 
### Examples

```
>> Sin(30*Degree)
1/2
```

Degree has the value of Pi / 180
```
>> Degree == Pi / 180
True

>> Cos(Degree(x))
Cos(Degree(x))
 
>> N(Degree)    
0.017453292519943295   
```

### Github

* [Implementation of Degree](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/ConstantDefinitions.java#L750) 
