## ChebyshevT

```
ChebyshevT(n, x)
```

> returns the Chebyshev polynomial of the first kind `T_n(x)`.

See:  
* [Wikipedia - Chebyshev polynomials](https://en.wikipedia.org/wiki/Chebyshev_polynomials)
* [Fungrim - Chebyshev polynomials](http://fungrim.org/topic/Chebyshev_polynomials/)

### Examples

```
>> ChebyshevT(8, x)    
1-32*x^2+160*x^4-256*x^6+128*x^8  
```

### Github

* [Implementation of ChebyshevT](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/PolynomialFunctions.java#L1201) 
