## ArithmeticGeometricMean

```
ArithmeticGeometricMean({a, b, c,...})
```

> returns the arithmetic geometric mean of `{a, b, c,...}`. 

See:
* [Wikipedia - Arithmetic-geometric mean](https://en.wikipedia.org/wiki/Arithmetic%E2%80%93geometric_mean)
* [Fungrim - Arithmetic-geometric mean](http://fungrim.org/topic/Arithmetic-geometric_mean/)

### Examples

```
>> ArithmeticGeometricMean({1.0, 2.0, 3.0, 4.0}, 42.0)
{12.874,14.88314,16.37375,17.62155}
```

### Related terms 
[GeometricMean](GeometricMean.md), [HarmonicMean](HarmonicMean.md), [Mean](Mean.md), [Median](Median.md)

### Github

* [Implementation of ArithmeticGeometricMean](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/StatisticsFunctions.java#L329) 
