- [Combinatorial](#combinatorial)
- [Comparison](#comparison)
- [Control flow statements](#control-flow-statements)
- [Diophantine Equations](#diophantine-equations)
- [Formatting output](#formatting-output)
- [Graph theory](#graph-theory)
- [Linear algebra](#linear-algebra)
- [Logic](#logic)
- [Number theory](#number-theory)
- [Pattern matching](#pattern-matching)
- [Plot functions](#plot-functions)
- [Solvers](#solvers)

## Combinatorial

* [BernoulliB](functions/BernoulliB.md)
* [Binomial](functions/Binomial.md) 
* [CartesianProduct](functions/CartesianProduct.md)
* [CatalanNumber](functions/CatalanNumber.md)
* [DiceDissimilarity](functions/DiceDissimilarity.md)
* [Factorial](functions/Factorial.md)
* [Factorial2](functions/Factorial2.md)
* [Fibonacci](functions/Fibonacci.md)
* [IntegerPartitions](functions/IntegerPartitions.md)
* [Intersection](functions/Intersection.md)
* [JaccardDissimilarity](functions/JaccardDissimilarity.md)
* [MatchingDissimilarity](functions/MatchingDissimilarity.md)
* [Multinomial](functions/Multinomial.md)
* [Partition](functions/Partition.md)
* [PartitionsP](functions/PartitionsP.md)
* [PartitionsQ](functions/PartitionsQ.md)
* [Permutations](functions/Permutations.md)
* [RogersTanimotoDissimilarity](functions/RogersTanimotoDissimilarity.md)
* [StirlingS1](functions/StirlingS1.md)
* [StirlingS2](functions/StirlingS2.md)
* [Subsets](functions/Subsets.md)
* [RussellRaoDissimilarity](functions/RussellRaoDissimilarity.md)
* [SokalSneathDissimilarity](functions/SokalSneathDissimilarity.md)
* [Tuples](functions/Tuples.md)
* [Union](functions/Union.md)
* [YuleDissimilarity](functions/YuleDissimilarity.md)

## Comparison

* [Equal](functions/Equal.md)
* [Greater](functions/Greater.md)
* [GreaterEqual](functions/GreaterEqual.md)
* [Less](functions/Less.md)
* [LessEqual](functions/LessEqual.md)
* [Max](functions/Max.md) 
* [Min](functions/Min.md) 
* [Negative](functions/Negative.md)
* [NonNegative](functions/NonNegative.md)
* [NonPositive](functions/NonPositive.md)
* [Positive](functions/Positive.md)  
* [SameQ](functions/SameQ.md)
* [True](functions/True.md)
* [TrueQ](functions/TrueQ.md)
* [Unequal](functions/Unequal.md)
* [UnsameQ](functions/UnsameQ.md)
* [ValueQ](functions/ValueQ.md)


## Control flow statements

* [Abort](functions/Abort.md)
* [Block](functions/Block.md)
* [Break](functions/Break.md)
* [CompoundExpression](functions/CompoundExpression.md)
* [Continue](functions/Continue.md)
* [Do](functions/Do.md)
* [FixedPoint](functions/FixedPoint.md)
* [FixedPointList](functions/FixedPointList.md)
* [For](functions/For.md)
* [If](functions/If.md)
* [Nest](functions/Nest.md)
* [NestList](functions/NestList.md)
* [NestWhile](functions/NestWhile.md)
* [Return](functions/Return.md)
* [Switch](functions/Switch.md)
* [Which](functions/Which.md)
* [While](functions/While.md)

## Diophantine Equations

* [ChineseRemainder](functions/ChineseRemainder.md)
* [FrobeniusNumber](functions/FrobeniusNumber.md)
* [FrobeniusSolve](functions/FrobeniusSolve.md)
* [IntegerPartitions](functions/IntegerPartitions.md)
* [MultiplicativeOrder](functions/MultiplicativeOrder.md)
* [PartitionsP](functions/PartitionsP.md)
* [PartitionsQ](functions/PartitionsQ.md)
* [PowerMod](functions/PowerMod.md)

## Formatting output

* [HornerForm](functions/HornerForm.md)
* [InputForm](functions/InputForm.md)
* [MatrixForm](functions/GraphCenter.md)
* [MathMLForm](functions/MathMLForm.md) 
* [TeXForm](functions/TeXForm.md)
* [TreeForm](functions/TreeForm.md)

## Graph theory

* [BetweennessCentrality](functions/BetweennessCentrality.md)
* [ClosenessCentrality](functions/ClosenessCentrality.md)
* [GraphCenter](functions/GraphCenter.md)
* [GraphDiameter](functions/GraphDiameter.md)
* [GraphPeriphery](functions/GraphPeriphery.md)
* [GraphRadius](functions/GraphRadius.md)
* [AdjacencyMatrix](functions/AdjacencyMatrix.md)
* [EdgeList](functions/EdgeList.md)
* [EdgeQ](functions/EdgeQ.md)
* [EulerianGraphQ](functions/EulerianGraphQ.md)
* [FindEulerianCycle](functions/FindEulerianCycle.md)
* [FindHamiltonianCycle](functions/FindHamiltonianCycle.md)
* [FindVertexCover](functions/FindVertexCover.md)
* [FindShortestPath](functions/FindShortestPath.md)
* [FindSpanningTree](functions/FindSpanningTree.md)
* [GraphQ](functions/GraphQ.md)
* [HamiltonianGraphQ](functions/HamiltonianGraphQ.md), 
* [VertexEccentricity](functions/VertexEccentricity.md)
* [VertexList](functions/VertexList.md)
* [VertexQ](functions/VertexQ.md) 

## Linear algebra

* [ArrayDepth](functions/ArrayDepth.md)
* [ArrayQ](functions/ArrayQ.md)
* [BrayCurtisDistance](functions/BrayCurtisDistance.md)
* [CanberraDistance](functions/CanberraDistance.md)
* [CharacteristicPolynomial](functions/CharacteristicPolynomial.md)
* [ChessboardDistance](functions/ChessboardDistance.md)
* [ConjugateTranspose](functions/ConjugateTranspose.md)
* [CosineDistance](functions/CosineDistance.md)
* [Cross](functions/Cross.md)
* [DesignMatrix](functions/DesignMatrix.md)
* [Det](functions/Det.md)
* [DiagonalMatrix](functions/DiagonalMatrix.md)
* [Dimensions](functions/Dimensions.md)
* [Dot](functions/Dot.md) 
* [Eigenvalues](functions/Eigenvalues.md)
* [Eigenvectors](functions/Eigenvectors.md) 
* [EuclideanDistance](functions/EuclideanDistance.md)
* [HilbertMatrix](functions/HilbertMatrix.md)
* [IdentityMatrix](functions/IdentityMatrix.md)
* [Inner](functions/Inner.md)
* [Inverse](functions/Inverse.md)
* [JacobiMatrix](functions/JacobiMatrix.md)
* [LinearProgramming](functions/LinearProgramming.md)
* [LinearSolve](functions/LinearSolve.md)
* [LUDecomposition](functions/LUDecomposition.md)
* [MatrixPower](functions/MatrixPower.md)
* [MatrixQ](functions/MatrixQ.md)
* [MatrixRank](functions/MatrixRank.md)
* [Norm](functions/Norm.md)
* [Normalize](functions/Normalize.md)
* [NullSpace](functions/NullSpace.md)
* [Orthogonalize](functions/Orthogonalize.md)
* [Outer](functions/Outer.md)
* [PseudoInverse](functions/PseudoInverse.md)
* [QRDecomposition](functions/QRDecomposition.md)
* [RowReduce](functions/RowReduce.md)
* [SingularValueDecomposition](functions/SingularValueDecomposition.md)
* [SquaredEuclideanDistance](functions/SquaredEuclideanDistance.md)
* [Transpose](functions/Transpose.md) 
* [VandermondeMatrix](functions/VandermondeMatrix.md)
* [VectorAngle](functions/VectorAngle.md)
* [VectorQ](functions/VectorQ.md)

## Logic

* [AllTrue](functions/AllTrue.md)
* [AnyTrue](functions/AnyTrue.md)
* [And](functions/And.md)
* [Boole](functions/Boole.md)
* [BooleanConvert](functions/BooleanConvert.md)
* [BooleanMinimize](functions/BooleanMinimize.md)
* [BooleanQ](functions/BooleanQ.md)
* [Booleans](functions/Booleans.md)
* [Equivalent](functions/Equivalent.md)
* [False](functions/False.md)
* [Implies](functions/Implies.md) 
* [NoneTrue](functions/NoneTrue.md)
* [Nand](functions/Nand.md)
* [Nor](functions/Nor.md)
* [Not](functions/Not.md)
* [Or](functions/Or.md)
* [SatisfiabilityCount](functions/SatisfiabilityCount.md)
* [SatisfiabilityInstances](functions/SatisfiabilityInstances.md)
* [SatisfiableQ](functions/SatisfiableQ.md)
* [TautologyQ](functions/TautologyQ.md)
* [True](functions/True.md)
* [TrueQ](functions/TrueQ.md)
* [Xor](functions/Xor.md) 

## Number theory

* [CoprimeQ](functions/CoprimeQ.md)
* [ContinuedFraction](functions/ContinuedFraction.md)
* [Divisors](functions/Divisors.md)
* [EvenQ](functions/EvenQ.md)
* [FactorInteger](functions/FactorInteger.md)
* [FromContinuedFraction](functions/FromContinuedFraction.md)
* [GCD](functions/GCD.md)
* [IntegerExponent](functions/IntegerExponent.md)
* [JacobiSymbol](functions/JacobiSymbol.md)
* [LCM](functions/LCM.md)
* [MersennePrimeExponent](functions/MersennePrimeExponent.md)
* [MersennePrimeExponentQ](functions/MersennePrimeExponentQ.md)
* [Mod](functions/Mod.md)
* [NextPrime](functions/NextPrime.md)
* [OddQ](functions/OddQ.md)
* [PerfectNumber](functions/PerfectNumber.md)
* [PerfectNumberQ](functions/PerfectNumberQ.md)
* [Prime](functions/Prime.md)
* [PrimePi](functions/PrimePi.md)
* [PrimePowerQ](functions/PrimePowerQ.md)
* [PrimeQ](functions/PrimeQ.md) 
* [Quotient](functions/Quotient.md) 

## Pattern matching 

* [Alternatives](functions/Alternatives.md)
* [Condition](functions/Condition.md)
* [Except](functions/Except.md)
* [MatchQ](functions/MatchQ.md)
* [Optional](functions/Optional.md)
* [PatternTest](functions/PatternTest.md)
* [Rule](functions/Rule.md)
* [RuleDelayed](functions/RuleDelayed.md)
* [Set](functions/Set.md)
* [SetDelayed](functions/SetDelayed.md)

## Plot functions

* [ListLinePlot](functions/ListLinePlot.md)
* [ListPlot](functions/ListPlot.md)
* [ListPlot3D](functions/ListPlot3D.md)
* [ListPointPlot3D](functions/ListPointPlot3D.md)
* [Manipulate](functions/Manipulate.md)
* [ParametricPlot](functions/ParametricPlot.md) 
* [Plot](functions/Plot.md) 
* [Plot3D](functions/Plot3D.md)

## Solvers

* [DSolve](functions/DSolve.md)
* [Eliminate](functions/Eliminate.md)
* [GroebnerBasis](functions/GroebnerBasis.md)
* [FindInstance](functions/FindInstance.md)
* [FindRoot](functions/FindRoot.md)
* [NRoots](functions/NRoots.md)
* [NSolve](functions/NSolve.md)
