/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTDataset;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.visit.VisitorExpr;

public class VisitorReplaceSlots
extends VisitorExpr {
    final IAST astSlots;

    public VisitorReplaceSlots(IAST ast) {
        this.astSlots = ast;
    }

    private IExpr getSlot(IInteger ii) {
        int i = ii.toIntDefault();
        if (i >= 0 && i < this.astSlots.size()) {
            return this.astSlots.get(i);
        }
        return F.NIL;
    }

    private IExpr getSlot(IStringX str) {
        IExpr arg1 = this.astSlots.arg1();
        if (arg1.isDataset()) {
            return ((IASTDataset)arg1).getValue(str);
        }
        if (arg1.isAST(S.Association)) {
            arg1 = EvalEngine.get().evaluate(arg1);
        }
        if (arg1.isAssociation()) {
            return ((IAssociation)arg1).getValue(str);
        }
        return F.NIL;
    }

    private IExpr getSlotSequence(IInteger ii) {
        int i = ii.toIntDefault();
        if (i >= 0 && i <= this.astSlots.size()) {
            IASTAppendable result = F.ast((IExpr)S.Sequence, this.astSlots.size());
            for (int j = i; j < this.astSlots.size(); ++j) {
                result.append(this.astSlots.get(j));
            }
            return result;
        }
        return F.NIL;
    }

    private int getSlotSequence(IASTAppendable ast, int pos, int startSlot) {
        for (int j = startSlot; j < this.astSlots.size(); ++j) {
            ast.append(pos++, this.astSlots.get(j));
        }
        return pos;
    }

    @Override
    public IExpr visit(IASTMutable ast) {
        if (ast.size() == 2) {
            IExpr arg1 = ast.arg1();
            if (ast.isSlot()) {
                if (arg1.isInteger()) {
                    return this.getSlot((IInteger)arg1);
                }
                if (arg1.isString()) {
                    return this.getSlot((IStringX)arg1);
                }
            } else if (ast.isSlotSequence() && arg1.isInteger()) {
                return this.getSlotSequence((IInteger)arg1);
            }
        }
        return this.visitAST(ast);
    }

    @Override
    protected IExpr visitAST(IAST ast) {
        IExpr temp;
        int sequ;
        IExpr arg;
        int i;
        IASTAppendable result = F.NIL;
        int j = 0;
        int size = ast.size();
        for (i = 0; i < size; ++i) {
            arg = ast.get(i);
            if (!arg.isPureFunction()) {
                if (arg.isSlotSequence()) {
                    sequ = ((IAST)arg).arg1().toIntDefault();
                    result = ast.copyAppendable(this.astSlots.argSize());
                    result.remove(j);
                    if (sequ < 0 || sequ >= this.astSlots.size()) break;
                    j = this.getSlotSequence(result, i, sequ);
                    ++i;
                    break;
                }
                temp = arg.accept(this);
                if (temp.isPresent()) {
                    result = ast.setAtClone(i++, temp);
                    ++j;
                    break;
                }
            }
            ++j;
        }
        if (result.isPresent()) {
            while (i < size) {
                arg = ast.get(i);
                if (!arg.isPureFunction()) {
                    if (arg.isSlotSequence()) {
                        sequ = ((IAST)arg).arg1().toIntDefault();
                        result.remove(j);
                        if (sequ >= 0 && sequ < this.astSlots.size()) {
                            j = this.getSlotSequence(result, j, sequ);
                        }
                        ++i;
                        continue;
                    }
                    temp = arg.accept(this);
                    if (temp.isPresent()) {
                        result.set(j, temp);
                    }
                }
                ++i;
                ++j;
            }
        }
        return result;
    }
}

