/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import java.util.ArrayList;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.visit.AbstractVisitor;

public class VisitorReplacePart
extends AbstractVisitor {
    private ArrayList<IPatternMatcher> patternMatcherList;
    private int offset;
    private final EvalEngine engine = EvalEngine.get();

    public VisitorReplacePart(IAST rule, IExpr.COMPARE_TERNARY heads) {
        if (rule.isRuleAST()) {
            rule = F.list(rule);
        }
        if (rule.isListOfRules()) {
            IAST list = rule;
            this.patternMatcherList = new ArrayList(list.argSize() + 3);
            this.offset = heads == IExpr.COMPARE_TERNARY.TRUE ? 0 : 1;
            for (int i = 1; i < list.size(); ++i) {
                rule = (IAST)list.get(i);
                this.initPatternMatcher(rule, heads);
            }
            if (heads == IExpr.COMPARE_TERNARY.FALSE) {
                this.offset = 1;
            }
        }
    }

    private void initPatternMatcher(IAST rule, IExpr.COMPARE_TERNARY heads) {
        IExpr fromPositions = rule.arg1();
        try {
            if (fromPositions.isList()) {
                IAST list = (IAST)fromPositions;
                if (list.isListOfLists()) {
                    for (int j = 1; j < list.size(); ++j) {
                        IAST subList = list.getAST(j);
                        int[] positions = new int[subList.argSize()];
                        for (int k = 1; k < subList.size(); ++k) {
                            positions[k - 1] = subList.get(k).toIntDefault();
                            if (positions[k - 1] == Integer.MIN_VALUE) {
                                throw ReturnException.RETURN_FALSE;
                            }
                            if (positions[k - 1] != 0) continue;
                            this.offset = 0;
                        }
                        IPatternMatcher evalPatternMatcher = this.engine.evalPatternMatcher(F.Sequence(positions), rule.arg2());
                        this.patternMatcherList.add(evalPatternMatcher);
                    }
                } else if (list.argSize() > 0) {
                    int[] positions = new int[list.argSize()];
                    for (int j = 1; j < list.size(); ++j) {
                        positions[j - 1] = list.get(j).toIntDefault();
                        if (positions[j - 1] == Integer.MIN_VALUE) {
                            throw ReturnException.RETURN_FALSE;
                        }
                        if (positions[j - 1] != 0) continue;
                        this.offset = 0;
                    }
                    IPatternMatcher evalPatternMatcher = this.engine.evalPatternMatcher(F.Sequence(positions), rule.arg2());
                    this.patternMatcherList.add(evalPatternMatcher);
                }
            } else {
                int[] positions = new int[]{rule.arg1().toIntDefault()};
                if (positions[0] == Integer.MIN_VALUE) {
                    throw ReturnException.RETURN_FALSE;
                }
                if (positions[0] == 0) {
                    this.offset = 0;
                }
                IPatternMatcher evalPatternMatcher = this.engine.evalPatternMatcher(F.Sequence(positions), rule.arg2());
                this.patternMatcherList.add(evalPatternMatcher);
            }
        }
        catch (ReturnException rex) {
            if (fromPositions.isList()) {
                IAST list = ((IAST)fromPositions).apply((IExpr)S.Sequence, 1);
                IPatternMatcher evalPatternMatcher = this.engine.evalPatternMatcher(list, rule.arg2());
                this.patternMatcherList.add(evalPatternMatcher);
            }
            IPatternMatcher evalPatternMatcher = this.engine.evalPatternMatcher(fromPositions, rule.arg2());
            this.patternMatcherList.add(evalPatternMatcher);
        }
    }

    private IExpr visitPatternIndexList(IAST ast, IASTAppendable positions) {
        IASTAppendable result = F.NIL;
        block0: for (int i = this.offset; i < ast.size(); ++i) {
            IInteger position = F.ZZ(i);
            for (int j = 0; j < this.patternMatcherList.size(); ++j) {
                IPatternMatcher matcher = this.patternMatcherList.get(j);
                IASTAppendable positionsToMatch = positions.copyAppendable();
                positionsToMatch.append(position);
                IASTAppendable temp = this.patternIndexRecursive(matcher, ast, positionsToMatch, i, result);
                if (temp.isPresent()) {
                    result = temp;
                    continue block0;
                }
                IInteger negativePart = F.ZZUniqueReference(i - ast.size());
                positionsToMatch.set(positionsToMatch.size() - 1, negativePart);
                temp = this.patternIndexRecursive(matcher, ast, positionsToMatch, i, result);
                if (temp.isPresent()) {
                    IExpr ex = temp.replaceAll(x -> {
                        if (x == negativePart) {
                            return position;
                        }
                        return F.NIL;
                    });
                    if (ex.isPresent() && ex instanceof IASTAppendable) {
                        result = (IASTAppendable)ex;
                        continue block0;
                    }
                    result = temp;
                    continue block0;
                }
                if (!ast.isAssociation() || i <= 0) continue;
                positionsToMatch.set(positionsToMatch.size() - 1, ast.getRule(i).first());
                temp = this.patternIndexRecursive(matcher, ast, positionsToMatch, i, result);
                if (!temp.isPresent()) continue;
                result = temp;
                continue block0;
            }
        }
        return result;
    }

    private IASTAppendable patternIndexRecursive(IPatternMatcher matcher, IAST ast, IASTAppendable positionsToMatch, int position, IASTAppendable result) {
        if (matcher.getLHS().isSequence()) {
            IExpr temp = matcher.eval(positionsToMatch, this.engine);
            if (temp.isPresent()) {
                if (!result.isPresent()) {
                    result = ast.copyAppendable();
                }
                if (position == 0 && result.isAssociation()) {
                    result = ((IAssociation)result).copyAST();
                }
                result.setValue(position, temp);
                return result;
            }
            if (ast.get(position).isASTOrAssociation() && (temp = this.visitPatternIndexList((IAST)ast.get(position), positionsToMatch)).isPresent()) {
                if (!result.isPresent()) {
                    result = ast.copyAppendable();
                }
                if (position == 0 && result.isAssociation()) {
                    result = ((IAssociation)result).copyAST();
                }
                result.setValue(position, temp);
                return result;
            }
        } else {
            IExpr temp = matcher.eval(F.ZZ(position), this.engine);
            if (temp.isPresent()) {
                if (!result.isPresent()) {
                    result = ast.copyAppendable();
                }
                result.setValue(position, temp);
                return result;
            }
        }
        return F.NIL;
    }

    @Override
    public IExpr visit(IASTMutable ast) {
        IASTAppendable positionsToMatch = F.ast(S.Sequence);
        for (int j = 0; j < this.patternMatcherList.size(); ++j) {
            IPatternMatcher matcher = this.patternMatcherList.get(j);
            IExpr lhs = matcher.getLHS();
            if (!lhs.isAST(S.Sequence, 1)) continue;
            return matcher.getRHS();
        }
        return this.visitPatternIndexList(ast, positionsToMatch);
    }
}

