/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import java.util.function.Function;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.visit.VisitorReplaceAll;

public class VisitorReplaceAllWithPatternFlags
extends VisitorReplaceAll {
    boolean onlyNamedPatterns;

    public VisitorReplaceAllWithPatternFlags(Function<IExpr, IExpr> function, boolean onlyNamedPatterns) {
        super(function);
        this.onlyNamedPatterns = onlyNamedPatterns;
    }

    private IExpr visitPatternObject(IPatternObject element) {
        IExpr temp = (IExpr)this.fFunction.apply(element);
        if (temp.isPresent() && temp.isOneIdentityAST1()) {
            return temp.first();
        }
        return temp;
    }

    @Override
    public IExpr visit(IPattern element) {
        return this.visitPatternObject(element);
    }

    @Override
    public IExpr visit(IPatternSequence element) {
        return this.visitPatternObject(element);
    }

    @Override
    public IExpr visit(IASTMutable ast) {
        if (ast.isPatternMatchingFunction()) {
            return F.NIL;
        }
        int size = ast.size();
        IASTMutable result = F.NIL;
        for (int i = this.fOffset; i < size; ++i) {
            IExpr temp = ast.get(i).accept(this);
            if (!temp.isPresent()) continue;
            result = ast.setAtCopy(i++, temp);
            while (i < size) {
                temp = ast.get(i).accept(this);
                if (temp.isPresent()) {
                    result.set(i, temp);
                }
                ++i;
            }
            if (result.isAST()) {
                return EvalAttributes.simpleEval(result);
            }
            return result;
        }
        return F.NIL;
    }
}

