/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.data.DispatchExpr;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IDataExpr;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorExpr;

public class VisitorReplaceAll
extends VisitorExpr {
    final Function<IExpr, IExpr> fFunction;
    private Function<IASTMutable, IExpr> fPostProcessing;
    final int fOffset;

    public VisitorReplaceAll(Function<IExpr, IExpr> function) {
        this(function, 0);
    }

    public VisitorReplaceAll(Function<IExpr, IExpr> function, int offset) {
        this.fFunction = function;
        this.fOffset = offset;
    }

    public VisitorReplaceAll(IAST ast) {
        this(ast, 0);
    }

    public VisitorReplaceAll(IAssociation assoc) {
        this(assoc.normal(false), 0);
    }

    public VisitorReplaceAll(IAST ast, int offset) {
        this.fFunction = Functors.rules(ast, EvalEngine.get());
        this.fOffset = offset;
    }

    public VisitorReplaceAll(Map<? extends IExpr, ? extends IExpr> map) {
        this(map, 0);
    }

    public VisitorReplaceAll(Map<? extends IExpr, ? extends IExpr> map, int offset) {
        this.fFunction = x -> {
            IExpr subst = (IExpr)map.get(x);
            if (subst != null) {
                return subst;
            }
            return F.NIL;
        };
        this.fOffset = offset;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VisitorReplaceAll)) {
            return false;
        }
        VisitorReplaceAll other = (VisitorReplaceAll)obj;
        return Objects.equals(this.fFunction, other.fFunction) && this.fOffset == other.fOffset && Objects.equals(this.fPostProcessing, other.fPostProcessing);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fFunction == null ? 0 : this.fFunction.hashCode());
        result = 31 * result + this.fOffset;
        result = 31 * result + (this.fPostProcessing == null ? 0 : this.fPostProcessing.hashCode());
        return result;
    }

    private IExpr postProcessing(IASTMutable result) {
        if (this.fPostProcessing != null) {
            return this.fPostProcessing.apply(result);
        }
        return result;
    }

    public void setPostProcessing(Function<IASTMutable, IExpr> postProcessing) {
        this.fPostProcessing = postProcessing;
    }

    @Override
    public IExpr visit(IASTMutable ast) {
        return this.fFunction.apply(ast).orElseGet(() -> this.visitAST(ast));
    }

    @Override
    public IExpr visit(IComplex element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IComplexNum element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IDataExpr<?> element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IFraction element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IInteger element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(INum element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(ISymbol element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IStringX element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IPattern element) {
        IExpr expr;
        IExpr temp = this.fFunction.apply(element);
        if (temp.isPresent()) {
            return temp;
        }
        ISymbol symbol = element.getSymbol();
        if (symbol != null && (expr = this.fFunction.apply(symbol)).isPresent() && expr.isSymbol()) {
            if (element.isPatternDefault()) {
                return F.$p((ISymbol)expr, element.getHeadTest(), true);
            }
            return F.$p((ISymbol)expr, element.getHeadTest());
        }
        return F.NIL;
    }

    @Override
    public IExpr visit(IPatternSequence element) {
        IExpr expr;
        IExpr temp = this.fFunction.apply(element);
        if (temp.isPresent()) {
            return temp;
        }
        ISymbol symbol = element.getSymbol();
        if (symbol != null && (expr = this.fFunction.apply(symbol)).isPresent() && expr.isSymbol()) {
            return F.$ps((ISymbol)expr, element.getHeadTest(), element.isDefault(), element.isNullSequence());
        }
        return F.NIL;
    }

    @Override
    public IExpr visit(IAssociation assoc) {
        IExpr replacement = this.fFunction.apply(assoc);
        if (replacement.isPresent()) {
            return replacement;
        }
        int size = assoc.size();
        for (int i = this.fOffset; i < size; ++i) {
            IExpr temp = assoc.getValue(i).accept(this);
            if (!temp.isPresent()) continue;
            IAST iRuleOrNIL = assoc.getRule(i);
            IASTMutable result = iRuleOrNIL.isPresent() ? assoc.setAtCopy(i, iRuleOrNIL.setAtCopy(2, temp)) : assoc.copy();
            assoc.forEach(i + 1, size, (x, j) -> {
                IExpr t = x.accept(this);
                if (t.isPresent()) {
                    result.set(j, assoc.getRule(j).setAtCopy(2, t));
                }
            });
            return this.postProcessing(result);
        }
        return F.NIL;
    }

    @Override
    protected IExpr visitAST(IAST ast) {
        int size = ast.size();
        for (int i = this.fOffset; i < size; ++i) {
            IExpr temp = ast.get(i).accept(this);
            if (!temp.isPresent()) continue;
            IASTMutable result = ast.setAtCopy(i, temp);
            ast.forEach(i + 1, size, (x, j) -> {
                IExpr t = x.accept(this);
                if (t.isPresent()) {
                    result.set(j, t);
                }
            });
            return this.postProcessing(result);
        }
        return F.NIL;
    }

    public static VisitorReplaceAll createVisitor(IExpr arg) {
        if (arg instanceof DispatchExpr) {
            return ((DispatchExpr)arg).getVisitor();
        }
        if (arg.isListOfRules(false) || arg.isRuleAST()) {
            return new VisitorReplaceAll((IAST)arg);
        }
        if (arg.isAssociation()) {
            return new VisitorReplaceAll((IAST)arg.normal(false));
        }
        throw new ArgumentTypeException("reps", F.list(arg));
    }
}

