/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import java.util.function.Function;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.FlowControlException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.visit.VisitorLevelSpecification;

public class VisitorRemoveLevelSpecification
extends VisitorLevelSpecification {
    final int maximumRemoved;
    private int removedCounter;

    public VisitorRemoveLevelSpecification(Function<IExpr, IExpr> function, IExpr expr, int maximumRemoved, boolean includeHeads, EvalEngine engine) {
        super(function, expr, includeHeads, engine);
        this.maximumRemoved = maximumRemoved;
        this.removedCounter = 0;
    }

    public VisitorRemoveLevelSpecification(Function<IExpr, IExpr> function, int level) {
        this(function, level, true);
    }

    public VisitorRemoveLevelSpecification(Function<IExpr, IExpr> function, int level, boolean includeHeads) {
        this(function, level, level, includeHeads);
    }

    public VisitorRemoveLevelSpecification(Function<IExpr, IExpr> function, int fromLevel, int toLevel) {
        this(function, fromLevel, toLevel, true);
    }

    public VisitorRemoveLevelSpecification(Function<IExpr, IExpr> function, int fromLevel, int toLevel, boolean includeHeads) {
        this(function, fromLevel, toLevel, Integer.MIN_VALUE, -1, -1, includeHeads);
    }

    public VisitorRemoveLevelSpecification(Function<IExpr, IExpr> function, int fromLevel, int toLevel, int fromDepth, int toDepth, int maximumRemoved, boolean includeHeads) {
        super(function, fromLevel, toLevel, fromDepth, toDepth, includeHeads);
        this.maximumRemoved = maximumRemoved;
        this.removedCounter = 0;
    }

    public int getRemovedCounter() {
        return this.removedCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr visit(IASTMutable astCopy) {
        IASTAppendable ast;
        int minDepth = -1;
        try {
            IExpr temp;
            IExpr arg;
            ast = !(astCopy instanceof IASTAppendable) ? astCopy.copyAppendable() : (IASTAppendable)astCopy;
            ++this.fCurrentLevel;
            if (this.fIncludeHeads) {
                arg = ast.get(0);
                if (arg.isAST()) {
                    arg = ((IAST)arg).copyAppendable();
                }
                if ((temp = arg.accept(this)).isPresent()) {
                    ast.remove(0);
                    ++this.removedCounter;
                    if (this.maximumRemoved >= 0 && this.removedCounter >= this.maximumRemoved) {
                        throw new StopException();
                    }
                } else {
                    ast.set(0, arg);
                }
                if (this.fCurrentDepth < minDepth) {
                    minDepth = this.fCurrentDepth;
                }
            }
            int i = 1;
            while (i < ast.size()) {
                arg = ast.get(i);
                if (arg.isAST()) {
                    arg = ((IAST)arg).copyAppendable();
                }
                if ((temp = arg.accept(this)).isPresent()) {
                    ast.remove(i);
                    ++this.removedCounter;
                    if (this.maximumRemoved < 0 || this.removedCounter < this.maximumRemoved) continue;
                    throw new StopException();
                }
                ast.set(i, arg);
                ++i;
                if (this.fCurrentDepth >= minDepth) continue;
                minDepth = this.fCurrentDepth;
            }
        }
        finally {
            --this.fCurrentLevel;
        }
        this.fCurrentDepth = --minDepth;
        if (this.isInRange(this.fCurrentLevel, minDepth)) {
            return (IExpr)this.fFunction.apply(ast);
        }
        return F.NIL;
    }

    public static class StopException
    extends FlowControlException {
        private static final long serialVersionUID = -8839477630696222675L;

        public StopException() {
            super("Stop VisitorDeleteLevelSpecification evaluation");
        }
    }
}

