/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import java.util.function.Function;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.visit.VisitorReplaceAll;

public class VisitorPlusTimesPowerReplaceAll
extends VisitorReplaceAll {
    public VisitorPlusTimesPowerReplaceAll(Function<IExpr, IExpr> function) {
        super(function, 1);
    }

    public VisitorPlusTimesPowerReplaceAll(IAST ast) {
        super(ast, 1);
    }

    @Override
    public IExpr visit(IASTMutable ast) {
        if (ast.isPlusTimesPower()) {
            return this.visitAST(ast);
        }
        return (IExpr)this.fFunction.apply(ast);
    }

    @Override
    protected IExpr visitAST(IAST ast) {
        if (ast.isPower()) {
            IExpr base = ast.base().accept(this);
            return base.isPresent() ? ast.setAtCopy(1, base) : F.NIL;
        }
        int size = ast.size();
        for (int i = this.fOffset; i < size; ++i) {
            IExpr temp = ast.get(i).accept(this);
            if (!temp.isPresent()) continue;
            IASTMutable result = ast.setAtCopy(i++, temp);
            ast.forEach(i, size, (x, j) -> {
                IExpr t = x.accept(this);
                if (t.isPresent()) {
                    result.set(j, t);
                }
            });
            return result;
        }
        return F.NIL;
    }
}

