/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import java.util.function.Function;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IDataExpr;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.AbstractVisitor;

public class VisitorLevelSpecification
extends AbstractVisitor {
    protected final Function<IExpr, IExpr> fFunction;
    protected int fFromLevel;
    protected int fToLevel;
    protected int fFromDepth;
    protected int fToDepth;
    protected final boolean fIncludeHeads;
    protected int fCurrentLevel;
    protected int fCurrentDepth;

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, IExpr unevaledLevelExpr, boolean includeHeads, EvalEngine engine) {
        IExpr levelExpr = engine.evaluate(unevaledLevelExpr);
        this.fToLevel = -1;
        this.fFromLevel = -1;
        this.fToDepth = 0;
        this.fFromDepth = 0;
        this.fIncludeHeads = includeHeads;
        this.fFunction = function;
        if (levelExpr instanceof IInteger) {
            IInteger value = (IInteger)levelExpr;
            if (value.isNegative()) {
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = Validate.throwIntType(value, Integer.MIN_VALUE, engine);
                this.fFromLevel = 1;
                this.fToLevel = Integer.MAX_VALUE;
            } else {
                this.fToLevel = Validate.throwIntType(value, Integer.MIN_VALUE, engine);
                this.fFromLevel = 1;
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = -1;
            }
            return;
        }
        if (levelExpr.isList()) {
            IAST lst = (IAST)levelExpr;
            if (lst.isAST1()) {
                if (lst.arg1() instanceof IInteger) {
                    IInteger i = (IInteger)lst.arg1();
                    int level = Validate.throwIntType(i, Integer.MIN_VALUE, engine);
                    if (i.isNegative()) {
                        this.fFromDepth = level;
                        this.fToDepth = level;
                        this.fFromLevel = 0;
                        this.fToLevel = Integer.MAX_VALUE;
                    } else {
                        this.fToLevel = level;
                        this.fFromLevel = level;
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = -1;
                    }
                    return;
                }
            } else if (lst.isAST2()) {
                if (lst.arg1() instanceof IInteger && lst.arg2() instanceof IInteger) {
                    IInteger i0 = (IInteger)lst.arg1();
                    IInteger i1 = (IInteger)lst.arg2();
                    if (i0.isNegative() && i1.isNegative()) {
                        this.fFromDepth = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                        this.fToDepth = Validate.throwIntType(i1, Integer.MIN_VALUE, engine);
                        this.fFromLevel = 0;
                        this.fToLevel = Integer.MAX_VALUE;
                    } else if (i0.isNegative()) {
                        this.fFromDepth = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                        this.fToDepth = -1;
                        this.fFromLevel = 0;
                        this.fToLevel = Validate.throwIntType(i1, Integer.MIN_VALUE, engine);
                    } else if (i1.isNegative()) {
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = Validate.throwIntType(i1, Integer.MIN_VALUE, engine);
                        this.fFromLevel = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                        this.fToLevel = Integer.MAX_VALUE;
                    } else {
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = -1;
                        this.fFromLevel = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                        this.fToLevel = Validate.throwIntType(i1, Integer.MIN_VALUE, engine);
                    }
                    return;
                }
                if (lst.arg1() instanceof IInteger && lst.arg2().isInfinity()) {
                    IInteger i0 = (IInteger)lst.arg1();
                    if (i0.isNegative()) {
                        String str = IOFunctions.getMessage("level", F.list(levelExpr), EvalEngine.get());
                        throw new ArgumentTypeException(str);
                    }
                    this.fFromDepth = Integer.MIN_VALUE;
                    this.fToDepth = -1;
                    this.fFromLevel = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                    this.fToLevel = Integer.MAX_VALUE;
                    return;
                }
                if (lst.arg1().isNegativeInfinity() && lst.arg2().isInfinity()) {
                    this.fFromDepth = Integer.MIN_VALUE;
                    this.fToDepth = -1;
                    this.fFromLevel = 0;
                    this.fToLevel = Integer.MAX_VALUE;
                    return;
                }
            }
        }
        if (levelExpr.isInfinity() || levelExpr.equals(S.All)) {
            this.fToLevel = Integer.MAX_VALUE;
            this.fFromLevel = 1;
            this.fFromDepth = Integer.MIN_VALUE;
            this.fToDepth = -1;
            return;
        }
        String str = IOFunctions.getMessage("level", F.list(levelExpr), EvalEngine.get());
        throw new ArgumentTypeException(str);
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int level) {
        this(function, level, true);
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int level, boolean includeHeads) {
        this(function, level, level, includeHeads);
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int fromLevel, int toLevel) {
        this(function, fromLevel, toLevel, true);
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int fromLevel, int toLevel, boolean includeHeads) {
        this(function, fromLevel, toLevel, Integer.MIN_VALUE, -1, includeHeads);
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int fromLevel, int toLevel, int fromDepth, int toDepth, boolean includeHeads) {
        this.fFunction = function;
        this.fFromLevel = fromLevel;
        this.fToLevel = toLevel;
        this.fCurrentLevel = 0;
        this.fIncludeHeads = includeHeads;
        this.fFromDepth = fromDepth;
        this.fCurrentDepth = -1;
        this.fToDepth = toDepth;
    }

    public void incCurrentLevel() {
        ++this.fCurrentLevel;
    }

    public void decCurrentLevel() {
        --this.fCurrentLevel;
    }

    public boolean isInRange(int level, int depth) {
        return level >= this.fFromLevel && level <= this.fToLevel && depth >= this.fFromDepth && depth <= this.fToDepth;
    }

    @Override
    public IExpr visit(IDataExpr<?> element) {
        return this.visitAtom(element);
    }

    @Override
    public IExpr visit(IInteger element) {
        return this.visitAtom(element);
    }

    @Override
    public IExpr visit(IFraction element) {
        return this.visitAtom(element);
    }

    @Override
    public IExpr visit(IComplex element) {
        return this.visitAtom(element);
    }

    @Override
    public IExpr visit(INum element) {
        return this.visitAtom(element);
    }

    @Override
    public IExpr visit(IComplexNum element) {
        return this.visitAtom(element);
    }

    @Override
    public IExpr visit(ISymbol element) {
        return this.visitAtom(element);
    }

    @Override
    public IExpr visit(IPattern element) {
        return this.visitAtom(element);
    }

    @Override
    public IExpr visit(IPatternSequence element) {
        return this.visitAtom(element);
    }

    @Override
    public IExpr visit(IStringX element) {
        return this.visitAtom(element);
    }

    protected final IExpr visitAtom(IExpr element) {
        this.fCurrentDepth = -1;
        return this.isInRange(this.fCurrentLevel, -1) ? this.fFunction.apply(element) : F.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr visit(IAssociation assoc) {
        IAssociation[] result = new IAssociation[]{F.NIL};
        if (assoc.isPresent()) {
            int[] minDepth = new int[]{0};
            try {
                ++this.fCurrentLevel;
                if (this.fIncludeHeads) {
                    // empty if block
                }
                assoc.forEach((x, i) -> {
                    IExpr temp = x.accept(this);
                    if (temp.isPresent()) {
                        if (!result[0].isPresent()) {
                            result[0] = this.createResult(assoc, temp);
                        }
                        result[0].set(i, assoc.getRule(i).setAtCopy(2, temp));
                    }
                    if (this.fCurrentDepth < minDepth[0]) {
                        minDepth[0] = this.fCurrentDepth;
                    }
                });
            }
            finally {
                --this.fCurrentLevel;
            }
            this.fCurrentDepth = minDepth[0] = minDepth[0] - 1;
            if (this.isInRange(this.fCurrentLevel, minDepth[0])) {
                if (!result[0].isPresent()) {
                    return this.fFunction.apply(assoc);
                }
                IExpr temp = this.fFunction.apply(result[0]);
                if (temp.isPresent()) {
                    return temp;
                }
            }
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr visit(IASTMutable ast) {
        IASTMutable[] result = new IASTMutable[]{F.NIL};
        if (ast.isPresent()) {
            IExpr temp;
            int[] minDepth = new int[]{0};
            try {
                ++this.fCurrentLevel;
                if (this.fIncludeHeads) {
                    temp = ast.get(0).accept(this);
                    if (temp.isPresent()) {
                        if (!result[0].isPresent()) {
                            result[0] = this.createResult(ast, temp);
                        }
                        result[0].set(0, temp);
                    }
                    if (this.fCurrentDepth < minDepth[0]) {
                        minDepth[0] = this.fCurrentDepth;
                    }
                }
                ast.forEach((x, i) -> {
                    IExpr temp = x.accept(this);
                    if (temp.isPresent()) {
                        if (!result[0].isPresent()) {
                            result[0] = this.createResult(ast, temp);
                        }
                        result[0].set(i, temp);
                    }
                    if (this.fCurrentDepth < minDepth[0]) {
                        minDepth[0] = this.fCurrentDepth;
                    }
                });
            }
            finally {
                --this.fCurrentLevel;
            }
            this.fCurrentDepth = minDepth[0] = minDepth[0] - 1;
            if (this.isInRange(this.fCurrentLevel, minDepth[0])) {
                if (!result[0].isPresent()) {
                    return this.fFunction.apply(ast);
                }
                temp = this.fFunction.apply(result[0]);
                if (temp.isPresent()) {
                    return temp;
                }
            }
        }
        return result[0];
    }

    public IAssociation createResult(IAssociation assoc, IExpr x) {
        return assoc.copy();
    }

    public IASTMutable createResult(IASTMutable ast, IExpr x) {
        return ast.copyAppendable();
    }
}

