/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import java.util.IdentityHashMap;
import java.util.Map;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorExpr;

public class ModuleReplaceAll
extends VisitorExpr {
    final Map<ISymbol, ? extends IExpr> fModuleVariables;
    final int fOffset;
    final EvalEngine fEngine;
    final String moduleCounter;

    public ModuleReplaceAll(Map<ISymbol, ? extends IExpr> moduleVariables, EvalEngine engine, String moduleCounter) {
        this(moduleVariables, engine, moduleCounter, 0);
    }

    public ModuleReplaceAll(Map<ISymbol, ? extends IExpr> moduleVariables, EvalEngine engine, String moduleCounter, int offset) {
        this.fModuleVariables = moduleVariables;
        this.fOffset = offset;
        this.fEngine = engine;
        this.moduleCounter = moduleCounter;
    }

    private IExpr apply(ISymbol arg) {
        IExpr temp = this.fModuleVariables.get(arg);
        return temp != null ? temp : F.NIL;
    }

    @Override
    public IExpr visit(ISymbol element) {
        return this.apply(element);
    }

    @Override
    public IExpr visit(IPattern element) {
        IExpr expr;
        ISymbol symbol = element.getSymbol();
        if (symbol != null && (expr = this.apply(symbol)).isSymbol()) {
            return F.$p((ISymbol)expr, element.getHeadTest(), element.isPatternDefault());
        }
        return F.NIL;
    }

    @Override
    public IExpr visit(IPatternSequence element) {
        IExpr expr;
        ISymbol symbol = element.getSymbol();
        if (symbol != null && (expr = this.apply(symbol)).isPresent() && expr.isSymbol()) {
            return F.$ps((ISymbol)expr, element.getHeadTest(), element.isDefault(), element.isNullSequence());
        }
        return F.NIL;
    }

    @Override
    public IExpr visit(IASTMutable ast) {
        if (ast.isSameHeadSizeGE(S.Function, 2)) {
            return this.visitNestedScope(ast, true);
        }
        if (ast.isWith()) {
            return this.visitNestedScope(ast, false).orElse(ast);
        }
        if (ast.isModule()) {
            return this.visitNestedScope(ast, false).orElse(ast);
        }
        return this.visitASTModule(ast);
    }

    private IAST visitNestedScope(IAST ast, boolean isFunction) {
        IdentityHashMap<ISymbol, IExpr> variables;
        IAST localVariablesList = F.NIL;
        if (ast.arg1().isSymbol()) {
            localVariablesList = F.list(ast.arg1());
        } else if (ast.arg1().isList()) {
            localVariablesList = (IAST)ast.arg1();
        }
        ModuleReplaceAll visitor = this;
        if (localVariablesList.isPresent() && (variables = this.renamedVariables(localVariablesList, isFunction)) != null) {
            visitor = new ModuleReplaceAll(variables, this.fEngine, this.moduleCounter);
        }
        for (int i = this.fOffset; i < ast.size(); ++i) {
            IExpr temp = ast.get(i).accept(visitor);
            if (!temp.isPresent()) continue;
            IASTMutable result = ast.setAtCopy(i++, temp);
            while (i < ast.size()) {
                temp = ast.get(i).accept(visitor);
                if (temp.isPresent()) {
                    result.set(i, temp);
                }
                ++i;
            }
            return result;
        }
        return F.NIL;
    }

    private IdentityHashMap<ISymbol, IExpr> renamedVariables(IAST localVariablesList, boolean isFunction) {
        IdentityHashMap<ISymbol, IExpr> variables = null;
        String varAppend = this.moduleCounter;
        int size = localVariablesList.size();
        for (int i = 1; i < size; ++i) {
            IAST setFun;
            IExpr temp = localVariablesList.get(i);
            if (temp.isSymbol()) {
                ISymbol symbol = (ISymbol)temp;
                variables = this.putSingleVariable(symbol, variables, varAppend, isFunction);
                continue;
            }
            if (!temp.isAST(S.Set, 3) || !(setFun = (IAST)temp).arg1().isSymbol()) continue;
            ISymbol symbol = (ISymbol)setFun.arg1();
            variables = this.putSingleVariable(symbol, variables, varAppend, isFunction);
        }
        return variables;
    }

    private IdentityHashMap<ISymbol, IExpr> putSingleVariable(ISymbol symbol, IdentityHashMap<ISymbol, IExpr> variables, String varAppend, boolean isFunction) {
        IExpr temp = this.fModuleVariables.get(symbol);
        if (isFunction) {
            if (variables == null) {
                variables = new IdentityHashMap<ISymbol, IExpr>(this.fModuleVariables);
            }
            variables.put(symbol, F.Dummy(symbol.toString() + varAppend));
        } else if (temp != null) {
            if (variables == null) {
                variables = new IdentityHashMap<ISymbol, IExpr>(this.fModuleVariables);
            }
            variables.remove(symbol);
            if (!temp.isPresent()) {
                variables.put(symbol, F.Dummy(symbol.toString() + varAppend));
            }
        }
        return variables;
    }

    private IExpr visitASTModule(IAST ast) {
        int size = ast.size();
        for (int i = this.fOffset; i < size; ++i) {
            IExpr temp = ast.get(i).accept(this);
            if (!temp.isPresent()) continue;
            IASTMutable result = ast.setAtCopy(i++, temp);
            ast.forEach(i, size, (x, j) -> {
                IExpr t = x.accept(this);
                if (t.isPresent()) {
                    result.set(j, t);
                }
            });
            return result;
        }
        return F.NIL;
    }
}

