/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import java.util.function.BiFunction;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.SymjaMathException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class IndexedLevel {
    protected final BiFunction<IExpr, IExpr, IExpr> fFunction;
    protected int fFromLevel;
    protected int fToLevel;
    protected int fFromDepth;
    protected int fToDepth;
    protected final boolean fIncludeHeads;
    protected int fCurrentLevel;
    protected int fCurrentDepth;

    public IndexedLevel(BiFunction<IExpr, IExpr, IExpr> function, IExpr unevaledLevelExpr, boolean includeHeads, EvalEngine engine) {
        IExpr levelExpr = engine.evaluate(unevaledLevelExpr);
        this.fToLevel = -1;
        this.fFromLevel = -1;
        this.fToDepth = 0;
        this.fFromDepth = 0;
        this.fIncludeHeads = includeHeads;
        this.fFunction = function;
        if (levelExpr instanceof IInteger) {
            IInteger value = (IInteger)levelExpr;
            if (value.isNegative()) {
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = Validate.throwIntType(value, Integer.MIN_VALUE, engine);
                this.fFromLevel = 1;
                this.fToLevel = Integer.MAX_VALUE;
            } else {
                this.fToLevel = Validate.throwIntType(value, Integer.MIN_VALUE, engine);
                this.fFromLevel = 1;
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = -1;
            }
            return;
        }
        if (levelExpr.isList()) {
            IAST lst = (IAST)levelExpr;
            if (lst.isAST1()) {
                if (lst.arg1() instanceof IInteger) {
                    IInteger i = (IInteger)lst.arg1();
                    int level = Validate.throwIntType(i, Integer.MIN_VALUE, engine);
                    if (i.isNegative()) {
                        this.fFromDepth = level;
                        this.fToDepth = level;
                        this.fFromLevel = 0;
                        this.fToLevel = Integer.MAX_VALUE;
                    } else {
                        this.fToLevel = level;
                        this.fFromLevel = level;
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = -1;
                    }
                    return;
                }
            } else if (lst.isAST2()) {
                if (lst.arg1() instanceof IInteger && lst.arg2() instanceof IInteger) {
                    IInteger i0 = (IInteger)lst.arg1();
                    IInteger i1 = (IInteger)lst.arg2();
                    if (i0.isNegative() && i1.isNegative()) {
                        this.fFromDepth = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                        this.fToDepth = Validate.throwIntType(i1, Integer.MIN_VALUE, engine);
                        this.fFromLevel = 0;
                        this.fToLevel = Integer.MAX_VALUE;
                    } else if (i0.isNegative()) {
                        this.fFromDepth = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                        this.fToDepth = -1;
                        this.fFromLevel = 0;
                        this.fToLevel = Validate.throwIntType(i1, Integer.MIN_VALUE, engine);
                    } else if (i1.isNegative()) {
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = Validate.throwIntType(i1, Integer.MIN_VALUE, engine);
                        this.fFromLevel = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                        this.fToLevel = Integer.MAX_VALUE;
                    } else {
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = -1;
                        this.fFromLevel = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                        this.fToLevel = Validate.throwIntType(i1, Integer.MIN_VALUE, engine);
                    }
                    return;
                }
                if (lst.arg1() instanceof IInteger && lst.arg2().isInfinity()) {
                    IInteger i0 = (IInteger)lst.arg1();
                    if (i0.isNegative()) {
                        throw new SymjaMathException("Invalid Level specification: " + levelExpr.toString());
                    }
                    this.fFromDepth = Integer.MIN_VALUE;
                    this.fToDepth = -1;
                    this.fFromLevel = Validate.throwIntType(i0, Integer.MIN_VALUE, engine);
                    this.fToLevel = Integer.MAX_VALUE;
                    return;
                }
                if (lst.arg1().isNegativeInfinity() && lst.arg2().isInfinity()) {
                    this.fFromDepth = Integer.MIN_VALUE;
                    this.fToDepth = -1;
                    this.fFromLevel = 0;
                    this.fToLevel = Integer.MAX_VALUE;
                    return;
                }
            }
        }
        if (levelExpr.isInfinity() || levelExpr.equals(S.All)) {
            this.fToLevel = Integer.MAX_VALUE;
            this.fFromLevel = 1;
            this.fFromDepth = Integer.MIN_VALUE;
            this.fToDepth = -1;
            return;
        }
        throw new SymjaMathException("Invalid Level specification: " + levelExpr.toString());
    }

    public IndexedLevel(BiFunction<IExpr, IExpr, IExpr> function, int level, boolean includeHeads) {
        this(function, level, level, includeHeads);
    }

    public IndexedLevel(BiFunction<IExpr, IExpr, IExpr> function, int fromLevel, int toLevel, boolean includeHeads) {
        this(function, fromLevel, toLevel, Integer.MIN_VALUE, -1, includeHeads);
    }

    public IndexedLevel(BiFunction<IExpr, IExpr, IExpr> function, int fromLevel, int toLevel, int fromDepth, int toDepth, boolean includeHeads) {
        this.fFunction = function;
        this.fFromLevel = fromLevel;
        this.fToLevel = toLevel;
        this.fCurrentLevel = 0;
        this.fIncludeHeads = includeHeads;
        this.fFromDepth = fromDepth;
        this.fCurrentDepth = -1;
        this.fToDepth = toDepth;
    }

    public void incCurrentLevel() {
        ++this.fCurrentLevel;
    }

    public void decCurrentLevel() {
        --this.fCurrentLevel;
    }

    public boolean isInRange(int level, int depth) {
        return level >= this.fFromLevel && level <= this.fToLevel && depth >= this.fFromDepth && depth <= this.fToDepth;
    }

    public IExpr visitExpr(IExpr element, int[] indx) {
        if (element.isAtom()) {
            this.fCurrentDepth = -1;
        }
        if (this.isInRange(this.fCurrentLevel, this.fCurrentDepth)) {
            return this.fFunction.apply(element, this.createIndexes(indx));
        }
        return F.NIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr visitAST(IAST ast, int[] indx) {
        int[] minDepth = new int[]{0};
        IASTMutable[] result = new IASTMutable[]{F.NIL};
        try {
            int size = indx.length;
            int[] newIndx = new int[size + 1];
            for (int j = 0; j < size; ++j) {
                newIndx[j] = indx[j];
            }
            ++this.fCurrentLevel;
            if (this.fIncludeHeads) {
                IExpr temp;
                newIndx[size] = 0;
                IExpr element = ast.get(0);
                if (element.isAST() && (temp = this.visitAST((IAST)element, newIndx)).isPresent()) {
                    element = temp;
                }
                if ((temp = this.visitExpr(element, newIndx)).isPresent()) {
                    if (!result[0].isPresent()) {
                        result[0] = this.createResult(ast, temp);
                    }
                    result[0].set(0, temp);
                }
                if (this.fCurrentDepth < minDepth[0]) {
                    minDepth[0] = this.fCurrentDepth;
                }
            }
            ast.forEach((x, i) -> {
                IExpr temp;
                newIndx[size] = i;
                IExpr element = x;
                boolean evaled = false;
                if (element.isAST() && (temp = this.visitAST((IAST)element, newIndx)).isPresent()) {
                    evaled = true;
                    element = temp;
                }
                if ((temp = this.visitExpr(element, newIndx)).isPresent()) {
                    if (!result[0].isPresent()) {
                        result[0] = this.createResult(ast, temp);
                    }
                    result[0].set(i, temp);
                } else if (evaled) {
                    if (!result[0].isPresent()) {
                        result[0] = this.createResult(ast, temp);
                    }
                    result[0].set(i, element);
                }
                if (this.fCurrentDepth < minDepth[0]) {
                    minDepth[0] = this.fCurrentDepth;
                }
            });
            this.fCurrentDepth = minDepth[0] = minDepth[0] - 1;
        }
        finally {
            --this.fCurrentLevel;
        }
        return result[0];
    }

    private IASTAppendable createIndexes(int[] indx) {
        IASTAppendable list = F.ListAlloc(indx.length);
        for (int i = 0; i < indx.length; ++i) {
            list.append(indx[i]);
        }
        return list;
    }

    public IASTMutable createResult(IAST ast, IExpr x) {
        return ast.copy();
    }
}

