/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.tensor.qty;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.tensor.qty.IUnit;
import org.matheclipse.core.tensor.qty.UnitHelper;

class UnitImpl
implements IUnit,
Serializable {
    private static final long serialVersionUID = 2551378967100742904L;
    private final NavigableMap<String, IExpr> navigableMap;

    UnitImpl(NavigableMap<String, IExpr> navigableMap) {
        this.navigableMap = Collections.unmodifiableNavigableMap(navigableMap);
    }

    @Override
    public IUnit negate() {
        return new UnitImpl(this.navigableMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IExpr)entry.getValue()).negate(), (e1, e2) -> null, TreeMap::new)));
    }

    @Override
    public IUnit add(IUnit unit) {
        TreeMap<String, IExpr> map = new TreeMap<String, IExpr>((SortedMap<String, IExpr>)this.navigableMap);
        unit.map().forEach((k, v) -> UnitHelper.addValue(map, k, v));
        return new UnitImpl(map);
    }

    @Override
    public IUnit multiply(IExpr factor) {
        if (factor instanceof ISignedNumber) {
            TreeMap<String, IExpr> map = new TreeMap<String, IExpr>();
            this.navigableMap.forEach((key, value) -> {
                IExpr product = S.Times.of(UnitHelper.ENGINE, (IExpr)value, factor);
                if (!product.isZero()) {
                    map.put((String)key, product);
                }
            });
            return new UnitImpl(map);
        }
        return null;
    }

    public NavigableMap<String, IExpr> map() {
        return this.navigableMap;
    }

    public int hashCode() {
        return this.navigableMap.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof IUnit && this.navigableMap.equals(((IUnit)object).map());
    }

    private static String exponentString(IExpr exponent) {
        String string = exponent.toString();
        return string.equals("1") ? "" : "^" + string;
    }

    public String toString() {
        return this.navigableMap.entrySet().stream().map(entry -> (String)entry.getKey() + UnitImpl.exponentString((IExpr)entry.getValue())).collect(Collectors.joining("*"));
    }

    @Override
    public int compareTo(IUnit o) {
        Map<String, IExpr> map = o.map();
        if (this.navigableMap.size() == map.size()) {
            return this.toString().compareTo(o.toString());
        }
        return this.navigableMap.size() > map.size() ? 1 : -1;
    }
}

