/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.tensor.qty;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.tensor.qty.IUnit;
import org.matheclipse.core.tensor.qty.UnitImpl;

class UnitHelper {
    private static final int SIZE = 500;
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z]+");
    static final EvalEngine ENGINE = new EvalEngine(false);
    private static final Map<String, IUnit> map = new LinkedHashMap<String, IUnit>(666, 0.75f, true){
        private static final long serialVersionUID = -5110699298658386612L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, IUnit> eldest) {
            return this.size() > 500;
        }
    };

    private UnitHelper() {
    }

    static IUnit lookup(String str) {
        IUnit unit = map.get(str);
        if (unit == null) {
            unit = UnitHelper.create(str);
        }
        return unit;
    }

    static IUnit lookupAndPutIfAbsent(String str) {
        return map.computeIfAbsent(str, UnitHelper::create);
    }

    static String requireValid(String key) {
        if (!PATTERN.matcher(key).matches()) {
            throw new IllegalArgumentException(key);
        }
        return key;
    }

    private static IUnit create(String string) {
        String key = string.strip();
        if (key.isEmpty()) {
            return null;
        }
        TreeMap<String, IExpr> map = new TreeMap<String, IExpr>();
        IExpr value = ENGINE.parse(key);
        if (value.isTimes()) {
            for (IExpr factor : (IAST)value) {
                if (factor.isPower()) {
                    UnitHelper.putPowerExponent(map, factor);
                    continue;
                }
                UnitHelper.putKeyExponent(map, factor, F.C1);
            }
        } else if (value.isPower()) {
            UnitHelper.putPowerExponent(map, value);
        } else {
            map.put(key, F.C1);
        }
        return map.isEmpty() ? null : new UnitImpl(map);
    }

    private static void putPowerExponent(NavigableMap<String, IExpr> map, IExpr power) {
        IExpr exponent = power.exponent();
        if (exponent.isOne()) {
            exponent = F.C1;
        }
        UnitHelper.putKeyExponent(map, power.base(), exponent);
    }

    private static void putKeyExponent(NavigableMap<String, IExpr> map, IExpr key, IExpr exponent) {
        if (!exponent.isZero()) {
            UnitHelper.addValue(map, key.toString(), exponent);
        }
    }

    static void addValue(Map<String, IExpr> map, String key, IExpr value) {
        map.merge(key, value, (oldValue, newValue) -> {
            IExpr sum = S.Plus.of(ENGINE, (IExpr)oldValue, (IExpr)newValue);
            return sum.isZero() ? null : sum;
        });
    }
}

