/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.tensor.qty;

import java.util.Objects;
import java.util.function.UnaryOperator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.tensor.qty.BuiltIn;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.core.tensor.qty.IUnit;
import org.matheclipse.core.tensor.qty.UnitSystem;

public class UnitConvert {
    private final UnitSystem unitSystem;

    public static UnitConvert SI() {
        return BuiltIn.unitConvert;
    }

    public UnitConvert(UnitSystem unitSystem) {
        this.unitSystem = Objects.requireNonNull(unitSystem);
    }

    public UnaryOperator<IExpr> to(IUnit unit) {
        IExpr base = (IExpr)this.unitSystem.apply(IQuantity.of(F.C1, unit));
        return scalar -> IQuantity.of(((IExpr)this.unitSystem.apply(scalar)).divide(base), unit);
    }
}

