/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.tensor.qty;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.core.tensor.qty.UnitHelper;
import org.matheclipse.core.tensor.qty.UnitSystem;
import org.matheclipse.parser.client.math.MathException;

public class SimpleUnitSystem
implements UnitSystem {
    private final Map<String, IExpr> map;

    public static UnitSystem from(Properties properties) {
        return new SimpleUnitSystem(properties.stringPropertyNames().stream().collect(Collectors.toMap(UnitHelper::requireValid, key -> SimpleUnitSystem.requireNumeric(F.fromString(properties.getProperty((String)key))))));
    }

    public static UnitSystem from(Map<String, IExpr> map) {
        return new SimpleUnitSystem(map.entrySet().stream().collect(Collectors.toMap(entry -> UnitHelper.requireValid((String)entry.getKey()), entry -> SimpleUnitSystem.requireNumeric((IExpr)entry.getValue()))));
    }

    private SimpleUnitSystem(Map<String, IExpr> map) {
        this.map = map;
    }

    @Override
    public IExpr apply(IExpr scalar) {
        if (scalar instanceof IQuantity) {
            IQuantity quantity = (IQuantity)scalar;
            IExpr value = quantity.value();
            for (Map.Entry<String, IExpr> entry : quantity.unit().map().entrySet()) {
                IExpr lookup = this.map.get(entry.getKey());
                IExpr entryValue = entry.getValue();
                IExpr temp = Objects.isNull(lookup) ? IQuantity.of((IExpr)F.C1, SimpleUnitSystem.format(entry)) : (lookup.isQuantity() ? ((IQuantity)lookup).power(entryValue) : S.Power.of(lookup, entryValue));
                IExpr v1 = temp.isQuantity() ? ((IQuantity)temp).times(value, true) : value.times(temp);
                if (v1.isPresent()) {
                    value = v1;
                    continue;
                }
                if (temp.isQuantity()) {
                    value = F.Times(temp, value);
                    continue;
                }
                value = F.Times(value, temp);
            }
            return value;
        }
        return Objects.requireNonNull(scalar);
    }

    @Override
    public Map<String, IExpr> map() {
        return Collections.unmodifiableMap(this.map);
    }

    private static IExpr requireNumeric(IExpr scalar) {
        IQuantity quantity;
        if (scalar instanceof IStringX) {
            throw MathException.of((Object[])new Object[]{scalar});
        }
        if (scalar instanceof IQuantity && (quantity = (IQuantity)scalar).value() instanceof IStringX) {
            throw MathException.of((Object[])new Object[]{scalar});
        }
        return scalar;
    }

    private static String format(Map.Entry<String, IExpr> entry) {
        return entry.getKey() + "^" + entry.getValue();
    }
}

