/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.tensor.qty;

import java.util.Objects;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.tensor.qty.BuiltIn;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.core.tensor.qty.IUnit;
import org.matheclipse.core.tensor.qty.SimpleUnitSystem;
import org.matheclipse.core.tensor.qty.UnitSystem;

public class QuantityMagnitude {
    private static final QuantityMagnitude EMPTY = new QuantityMagnitude(SimpleUnitSystem.from(new Properties()));
    private final UnitSystem unitSystem;

    public static QuantityMagnitude SI() {
        return BuiltIn.quantityMagnitude;
    }

    private static UnaryOperator<IExpr> singleton(IUnit unit) {
        return EMPTY.in(unit);
    }

    private static UnaryOperator<IExpr> singleton(String string) {
        return QuantityMagnitude.singleton(IUnit.ofPutIfAbsent(string));
    }

    public QuantityMagnitude(UnitSystem unitSystem) {
        this.unitSystem = Objects.requireNonNull(unitSystem);
    }

    public UnaryOperator<IExpr> in(IUnit unit) {
        final IExpr base = (IExpr)this.unitSystem.apply(IQuantity.of(F.C1, unit));
        return new UnaryOperator<IExpr>(){

            @Override
            public IExpr apply(IExpr scalar) {
                IExpr result = ((IExpr)QuantityMagnitude.this.unitSystem.apply(scalar)).divide(base);
                if (result instanceof IQuantity) {
                    return ((IQuantity)result).value();
                }
                return result;
            }
        };
    }
}

