/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.tensor.qty;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.Function;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.core.tensor.qty.IUnit;
import org.matheclipse.core.tensor.qty.UnitSystem;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.client.math.MathException;

public class QuantityImpl
extends DataExpr<IUnit>
implements IQuantity,
Externalizable {
    private IExpr arg1;

    static IExpr of(IExpr value, IUnit unit) {
        return IUnit.ONE.equals(unit) ? value : new QuantityImpl(value, unit);
    }

    public QuantityImpl() {
        super(S.Quantity, null);
    }

    QuantityImpl(IExpr value, IUnit unit) {
        super(S.Quantity, Objects.requireNonNull(unit, "Unit must not be null"));
        this.arg1 = value;
    }

    @Override
    public IExpr abs() {
        return this.ofUnit(this.arg1.abs());
    }

    @Override
    public String unitString() {
        return ((IUnit)this.fData).toString();
    }

    public IExpr ceiling() {
        return this.ofUnit(S.Ceiling.of(this.arg1));
    }

    @Override
    public int compareTo(IExpr scalar) {
        if (scalar instanceof IQuantity) {
            IQuantity quantity = (IQuantity)scalar;
            IUnit unit = quantity.unit();
            if (((IUnit)this.fData).equals(unit)) {
                return this.arg1.compareTo(quantity.value());
            }
            return ((IUnit)this.fData).compareTo(unit);
        }
        return super.compareTo(scalar);
    }

    @Override
    public IExpr conjugate() {
        if (this.arg1.isRealResult()) {
            return this;
        }
        return new QuantityImpl(F.Conjugate(this.arg1), (IUnit)this.fData);
    }

    public IExpr copy() {
        return new QuantityImpl(this.arg1, (IUnit)this.fData);
    }

    @Override
    public IExpr divide(IExpr scalar) {
        if (scalar instanceof IQuantity) {
            IQuantity quantity = (IQuantity)scalar;
            return QuantityImpl.of(this.arg1.divide(quantity.value()), ((IUnit)this.fData).add(quantity.unit().negate()));
        }
        return this.ofUnit(this.arg1.divide(scalar));
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof IQuantity) {
            IQuantity quantity = (IQuantity)object;
            return this.arg1.equals(quantity.value()) && ((IUnit)this.fData).equals(quantity.unit());
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (this.arg1.isIndeterminate()) {
            return this.arg1;
        }
        if (engine.isDoubleMode() && !this.arg1.isInexactNumber()) {
            try {
                double qDouble = this.arg1.evalDouble();
                return new QuantityImpl(F.num(qDouble), (IUnit)this.fData);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return F.NIL;
    }

    @Override
    public IExpr floor() {
        return this.ofUnit(S.Floor.of(this.arg1));
    }

    @Override
    public String fullFormString() {
        String sep = ", ";
        StringBuilder text = new StringBuilder();
        text.append("Quantity");
        text.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)'(' : '[');
        text.append(this.arg1.fullFormString());
        text.append(", \"");
        text.append(((IUnit)this.fData).toString());
        text.append("\"");
        text.append(ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? (char)')' : ']');
        return text.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arg1, this.fData);
    }

    @Override
    public int hierarchy() {
        return 128;
    }

    @Override
    public IExpr im() {
        if (this.arg1.isRealResult()) {
            return new QuantityImpl(F.C0, (IUnit)this.fData);
        }
        return new QuantityImpl(F.Im(this.arg1), (IUnit)this.fData);
    }

    @Override
    public CharSequence internalJavaString(IExpr.SourceCodeProperties properties, int depth, Function<ISymbol, ? extends CharSequence> variables) {
        CharSequence value = this.value().internalJavaString(properties, depth, variables);
        StringBuilder javaForm = new StringBuilder();
        boolean fullName = properties.prefix == IExpr.SourceCodeProperties.Prefix.FULLY_QUALIFIED_CLASS_NAME;
        String pPrefix = fullName ? "org.matheclipse.core.tensor.qty." : "";
        javaForm.append(pPrefix).append("IQuantity.of(").append(value).append(",");
        if (IUnit.ONE.equals(this.unit())) {
            javaForm.append(pPrefix).append("IUnit.ONE");
        } else {
            javaForm.append(pPrefix).append("IUnit.ofPutIfAbsent(\"").append(this.unitString()).append("\")");
        }
        return javaForm.append(")");
    }

    @Override
    public boolean isAST0() {
        return false;
    }

    @Override
    public boolean isAST1() {
        return false;
    }

    @Override
    public boolean isAST2() {
        return false;
    }

    @Override
    public boolean isAST3() {
        return false;
    }

    @Override
    public boolean isExactNumber() {
        return this.arg1.isExactNumber();
    }

    @Override
    public boolean isNegative() {
        return this.arg1.isNegative();
    }

    @Override
    public boolean isNegativeInfinity() {
        return this.arg1.isNegativeInfinity();
    }

    @Override
    public boolean isNegativeResult() {
        return this.arg1.isNegativeResult();
    }

    @Override
    public boolean isNonNegativeResult() {
        return this.arg1.isNonNegativeResult();
    }

    @Override
    public boolean isNumericFunction(boolean allowList) {
        return this.arg1.isNumericFunction(true);
    }

    @Override
    public boolean isInexactNumber() {
        return false;
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public boolean isPositive() {
        return this.arg1.isPositive();
    }

    @Override
    public boolean isPositiveResult() {
        return this.arg1.isPositiveResult();
    }

    @Override
    public boolean isQuantity() {
        return true;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public IExpr times(IExpr scalar) {
        return this.times(scalar, false);
    }

    @Override
    public IExpr times(IExpr scalar, boolean nilIfUnevaluated) {
        if (scalar instanceof IQuantity) {
            IQuantity quantity = (IQuantity)scalar;
            return QuantityImpl.of(this.arg1.times(quantity.value()), ((IUnit)this.fData).add(quantity.unit()));
        }
        if (scalar.isReal()) {
            return this.ofUnit(this.arg1.times(scalar));
        }
        return nilIfUnevaluated ? F.NIL : F.Times((IExpr)this, scalar);
    }

    public IExpr n() {
        return this.ofUnit(EvalEngine.get().evalN(this.arg1));
    }

    @Override
    public IExpr negate() {
        return this.ofUnit(this.arg1.negate());
    }

    @Override
    public IQuantity ofUnit(IExpr scalar) {
        return new QuantityImpl(scalar, (IUnit)this.fData);
    }

    @Override
    public IExpr plus(IExpr scalar) {
        return this.plus(scalar, false);
    }

    @Override
    public IExpr plus(IExpr scalar, boolean nilIfUnevaluated) {
        boolean azero = this.isZero();
        boolean bzero = scalar.isZero();
        if (azero && !bzero) {
            return scalar;
        }
        if (!azero && bzero) {
            return this;
        }
        if (scalar instanceof IQuantity) {
            IQuantity quantity = (IQuantity)scalar;
            IUnit unit = quantity.unit();
            if (!((IUnit)this.fData).equals(unit)) {
                IExpr lhs = (IExpr)UnitSystem.SI().apply(this);
                IExpr rhs = (IExpr)UnitSystem.SI().apply(quantity);
                if (!this.equals(lhs) || !quantity.equals(rhs)) {
                    return lhs.plus(rhs);
                }
                throw new ArgumentTypeException("compat", F.list(F.stringx(((IUnit)this.fData).toString()), F.stringx(unit.toString())));
            }
            if (((IUnit)this.fData).equals(unit)) {
                return this.ofUnit(this.arg1.plus(quantity.value()));
            }
            if (azero) {
                return this.arg1.plus(quantity.value());
            }
        } else if (azero) {
            return this;
        }
        return nilIfUnevaluated ? F.NIL : F.Plus((IExpr)this, scalar);
    }

    @Override
    public IExpr power(IExpr exponent) {
        if (exponent instanceof IQuantity) {
            throw MathException.of((Object[])new Object[]{this, exponent});
        }
        IUnit product = ((IUnit)this.fData).multiply(exponent);
        if (product == null) {
            return F.NIL;
        }
        return QuantityImpl.of(S.Power.of(this.arg1, exponent), product);
    }

    @Override
    public IExpr re() {
        if (this.arg1.isRealResult()) {
            return this;
        }
        return new QuantityImpl(F.Re(this.arg1), (IUnit)this.fData);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.arg1 = (IExpr)objectInput.readObject();
        this.fData = (IUnit)objectInput.readObject();
    }

    @Override
    public IExpr reciprocal() {
        return new QuantityImpl(this.arg1.reciprocal(), ((IUnit)this.fData).negate());
    }

    public IExpr roundExpr() {
        return this.ofUnit(S.Round.of(this.arg1));
    }

    @Override
    public IExpr sqrt() {
        IUnit product = ((IUnit)this.fData).multiply(F.C1D2);
        if (product == null) {
            return F.NIL;
        }
        return QuantityImpl.of(S.Sqrt.of(this.arg1), product);
    }

    @Override
    public String toString() {
        return this.arg1.toString() + "[" + this.fData + "]";
    }

    @Override
    public IUnit unit() {
        return (IUnit)this.fData;
    }

    @Override
    public IExpr value() {
        return this.arg1;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.arg1);
        objectOutput.writeObject(this.fData);
    }

    private Object writeReplace() {
        return this.optional();
    }
}

