/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.tensor.qty;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.tensor.qty.IUnit;
import org.matheclipse.core.tensor.qty.QuantityImpl;
import org.matheclipse.parser.client.math.MathException;

public interface IQuantity
extends IExpr,
Comparable<IExpr> {
    public static final char UNIT_OPENING_BRACKET = '[';
    public static final char UNIT_CLOSING_BRACKET = ']';

    public static IExpr of(IExpr value, IUnit unit) {
        if (value instanceof IQuantity) {
            throw MathException.of((Object[])new Object[]{value});
        }
        return QuantityImpl.of(value, unit);
    }

    public static IQuantity of(INumber value, IUnit unit) {
        return new QuantityImpl(value, unit);
    }

    public static IExpr of(IExpr value, String unit) {
        return IQuantity.of(value, IUnit.ofPutIfAbsent(unit));
    }

    public static IExpr of(Number number, IUnit unit) {
        return QuantityImpl.of((IExpr)F.expr(number), unit);
    }

    public static IExpr of(Number number, String unit) {
        return IQuantity.of((IExpr)F.expr(number), unit);
    }

    public IQuantity ofUnit(IExpr var1);

    public IExpr plus(IExpr var1, boolean var2);

    public IExpr times(IExpr var1, boolean var2);

    public IUnit unit();

    public String unitString();

    public IExpr value();
}

