/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.tensor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.core.tensor.qty.IUnit;

public class QuantityParser {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IExpr of(String string) {
        int index = string.indexOf(91);
        if (0 < index) {
            int last = string.indexOf(93);
            if (index < last && string.substring(last + 1).trim().isEmpty()) {
                return IQuantity.of(F.fromString(string.substring(0, index)), IUnit.ofPutIfAbsent(string.substring(index + 1, last)));
            }
            throw new IllegalArgumentException(string);
        }
        try {
            EvalEngine engine = new EvalEngine(true);
            return engine.evaluate(string, true);
        }
        catch (RuntimeException rex) {
            LOGGER.error("QuantityParser.of() failed", (Throwable)rex);
            throw new IllegalArgumentException(string, rex);
        }
    }
}

