/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.builtin.StructureFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.hash.HashedOrderlessMatcher;
import org.matheclipse.core.visit.VisitorExpr;

public class TrigReduce
extends AbstractEvaluator {
    private static HashedOrderlessMatcher ORDERLESS_MATCHER = new HashedOrderlessMatcher();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr temp = StructureFunctions.threadLogicEquationOperators(ast.arg1(), ast, 1);
        if (temp.isPresent()) {
            return temp;
        }
        TrigReduceVisitor trigReduceVisitor = new TrigReduceVisitor(engine);
        IExpr result = temp = ast.arg1();
        while (temp.isPresent()) {
            result = temp;
            if (temp.isPlus() || temp.isTimes() || temp.isPower()) {
                result = F.evalExpand(temp);
            }
            if (!(temp = result.accept(trigReduceVisitor)).isPresent()) continue;
            result = temp;
        }
        return result;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_1;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        ORDERLESS_MATCHER.defineHashRule(F.Sin(F.x_), F.Cos(F.y_), F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.Sin(F.Plus((IExpr)S.x, (IExpr)S.y)), (IExpr)F.Sin(F.Subtract(S.x, S.y)))));
        ORDERLESS_MATCHER.defineHashRule(F.Sin(F.x_), F.Sin(F.y_), F.Times((IExpr)F.C1D2, (IExpr)F.Subtract(F.Cos(F.Subtract(S.x, S.y)), F.Cos(F.Plus((IExpr)S.x, (IExpr)S.y)))));
        ORDERLESS_MATCHER.defineHashRule(F.Cos(F.x_), F.Cos(F.y_), F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.Cos(F.Plus((IExpr)S.x, (IExpr)S.y)), (IExpr)F.Cos(F.Subtract(S.x, S.y)))));
        ORDERLESS_MATCHER.defineHashRule(F.Sinh(F.x_), F.Cosh(F.y_), F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.Sinh(F.Subtract(S.x, S.y)), (IExpr)F.Sinh(F.Plus((IExpr)S.x, (IExpr)S.y)))));
        ORDERLESS_MATCHER.defineHashRule(F.Sin(F.x_), F.Tan(F.y_), F.Times((IExpr)F.C1D2, (IExpr)F.Subtract(F.Cos(F.Subtract(S.x, S.y)), F.Cos(F.Plus((IExpr)S.x, (IExpr)S.y))), (IExpr)F.Sec(S.y)));
        ORDERLESS_MATCHER.defineHashRule(F.Cos(F.x_), F.Tan(F.y_), F.Times((IExpr)F.CN1D2, (IExpr)F.Subtract(F.Sin(F.Subtract(S.x, S.y)), F.Sin(F.Plus((IExpr)S.x, (IExpr)S.y))), (IExpr)F.Sec(S.y)));
        ORDERLESS_MATCHER.defineHashRule(F.Cos(F.x_), F.Cot(F.y_), F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.Cos(F.Subtract(S.x, S.y)), (IExpr)F.Cos(F.Plus((IExpr)S.x, (IExpr)S.y))), (IExpr)F.Csc(S.y)));
        ORDERLESS_MATCHER.defineHashRule(F.Sin(F.x_), F.Cot(F.y_), F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.Sin(F.Subtract(S.x, S.y)), (IExpr)F.Sin(F.Plus((IExpr)S.x, (IExpr)S.y))), (IExpr)F.Csc(S.y)));
    }

    static class TrigReduceVisitor
    extends VisitorExpr {
        final EvalEngine fEngine;

        public TrigReduceVisitor(EvalEngine engine) {
            this.fEngine = engine;
        }

        @Override
        public IExpr visit(IASTMutable ast) {
            int n;
            if (ast.isTimes()) {
                IAST result = ORDERLESS_MATCHER.evaluate(ast, this.fEngine);
                if (result.isPresent()) {
                    return result;
                }
            } else if (ast.isPower() && ast.base().isAST() && (n = ast.exponent().toIntDefault()) > 1) {
                IAST base = (IAST)ast.base();
                if (base.isSin()) {
                    return TrigReduceVisitor.trigReduceSinPower(base, n);
                }
                if (base.isCos()) {
                    return TrigReduceVisitor.trigReduceCosPower(base, n);
                }
            }
            return this.visitAST(ast);
        }

        private static IExpr trigReduceCosPower(IAST base, int i) {
            IExpr x = base.arg1();
            IInteger n = F.ZZ(i);
            return F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Cos(F.Times((IExpr)F.C2, x))), (IExpr)F.Power((IExpr)F.Cos(x), n.subtract(F.C2)));
        }

        private static IExpr trigReduceSinPower(IAST base, int i) {
            IExpr x = base.arg1();
            IInteger n = F.ZZ(i);
            return F.Times((IExpr)F.C1D2, (IExpr)F.Subtract(F.C1, F.Cos(F.Times((IExpr)F.C2, x))), (IExpr)F.Power((IExpr)F.Sin(x), n.subtract(F.C2)));
        }
    }
}

