/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.function.Function;
import org.matheclipse.core.builtin.StructureFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.visit.VisitorPlusTimesPowerReplaceAll;

public class TrigExpand
extends AbstractEvaluator {
    private static final Function<IExpr, IExpr> function = new TrigExpandFunction();
    private static final VisitorPlusTimesPowerReplaceAll visitor = new VisitorPlusTimesPowerReplaceAll(function);

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr result;
        IExpr temp = StructureFunctions.threadLogicEquationOperators(ast.arg1(), ast, 1);
        if (temp.isPresent()) {
            return temp;
        }
        temp = ast.arg1();
        while ((temp = (result = F.evalExpandAll(temp, engine)).accept(visitor)).isPresent()) {
        }
        return result;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_1;
    }

    private static final class TrigExpandFunction
    implements Function<IExpr, IExpr> {
        private TrigExpandFunction() {
        }

        @Override
        public IExpr apply(IExpr ast) {
            if (ast.isAST1()) {
                IExpr first = ast.first();
                if (first.isPlus()) {
                    return this.expandPlus((IAST)ast, (IAST)first);
                }
                if (first.isTimes()) {
                    return this.expandTimes((IAST)ast, (IAST)first);
                }
            }
            return F.NIL;
        }

        private IExpr expandPlus(IAST ast, IAST plusAST) {
            if (ast.isSin()) {
                return TrigExpandFunction.expandSinPlus(plusAST, 1);
            }
            if (ast.isCos()) {
                return TrigExpandFunction.expandCosPlus(plusAST, 1);
            }
            if (ast.isAST(S.Cot, 2)) {
                return F.Divide(TrigExpandFunction.expandCosPlus(plusAST, 1), TrigExpandFunction.expandSinPlus(plusAST, 1));
            }
            if (ast.isTan()) {
                return F.Divide(TrigExpandFunction.expandSinPlus(plusAST, 1), TrigExpandFunction.expandCosPlus(plusAST, 1));
            }
            if (ast.isAST(S.Csc, 2)) {
                return F.Divide(F.C1, TrigExpandFunction.expandSinPlus(plusAST, 1));
            }
            if (ast.isAST(S.Sec, 2)) {
                return F.Divide(F.C1, TrigExpandFunction.expandCosPlus(plusAST, 1));
            }
            if (ast.isAST(S.Sech, 2)) {
                return TrigExpandFunction.expandSechPlus(plusAST, 1);
            }
            if (ast.isSinh()) {
                return TrigExpandFunction.expandSinhPlus(plusAST, 1);
            }
            if (ast.isCosh()) {
                return TrigExpandFunction.expandCoshPlus(plusAST, 1);
            }
            if (ast.isAST(S.Csch, 2)) {
                return TrigExpandFunction.expandCschPlus(plusAST, 1);
            }
            if (ast.isTanh()) {
                return TrigExpandFunction.expandTanhPlus(plusAST, 1);
            }
            return F.NIL;
        }

        private IExpr expandTimes(IAST ast, IAST timesAST) {
            IInteger n;
            if (timesAST.arg1().isInteger() && (n = (IInteger)timesAST.arg1()).compareInt(0) > 0) {
                try {
                    IExpr theta = timesAST.rest().oneIdentity1();
                    if (ast.isSin()) {
                        return TrigExpandFunction.expandSinTimes(n, theta);
                    }
                    if (ast.isCos()) {
                        return TrigExpandFunction.expandCosTimes(n, theta);
                    }
                    if (ast.isAST(S.Cot, 2)) {
                        return F.Divide(TrigExpandFunction.expandCosTimes(n, theta), TrigExpandFunction.expandSinTimes(n, theta));
                    }
                    if (ast.isTan()) {
                        return F.Divide(TrigExpandFunction.expandSinTimes(n, theta), TrigExpandFunction.expandCosTimes(n, theta));
                    }
                    if (ast.isAST(S.Csc, 2)) {
                        return F.Divide(F.C1, TrigExpandFunction.expandSinTimes(n, theta));
                    }
                    if (ast.isAST(S.Sec, 2)) {
                        return F.Divide(F.C1, TrigExpandFunction.expandCosTimes(n, theta));
                    }
                    if (ast.isSinh()) {
                        int nInt = n.toInt();
                        return TrigExpandFunction.expandSinhPlus(theta.constantArray(S.Plus, 0, nInt), 1);
                    }
                    if (ast.isCosh()) {
                        int nInt = n.toInt();
                        return TrigExpandFunction.expandCoshPlus(theta.constantArray(S.Plus, 0, nInt), 1);
                    }
                    if (ast.isAST(S.Csch, 2)) {
                        return F.TrigExpand(F.Times((IExpr)F.Csch(theta), (IExpr)F.Power((IExpr)F.ChebyshevU(F.Subtract(n, F.C1), F.Cosh(theta)), F.CN1)));
                    }
                    if (ast.isAST(S.Sech, 2)) {
                        int nInt = n.toInt();
                        return TrigExpandFunction.expandSechPlus(theta.constantArray(S.Plus, 0, nInt), 1);
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            return F.NIL;
        }

        private static IExpr expandCosTimes(IInteger n, IExpr theta) {
            int ni = n.toIntDefault();
            if (ni > Integer.MIN_VALUE) {
                return F.sum(i -> F.Times((IExpr)F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.CN1, F.Times(i, (IExpr)F.C1D2)), (IExpr)F.Binomial(n, i)), (IExpr)F.Power((IExpr)F.Cos(theta), F.Plus((IExpr)n, (IExpr)F.Times((IExpr)F.CN1, i)))), (IExpr)F.Power((IExpr)F.Sin(theta), i)), 0, ni, 2);
            }
            return F.NIL;
        }

        private static IExpr expandSinTimes(IInteger n, IExpr theta) {
            int ni = n.toIntDefault();
            if (ni > Integer.MIN_VALUE) {
                return F.sum(i -> F.Times((IExpr)F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.CN1, F.Times((IExpr)F.Plus(i, (IExpr)F.CN1), (IExpr)F.C1D2)), (IExpr)F.Binomial(n, i)), (IExpr)F.Power((IExpr)F.Cos(theta), F.Plus((IExpr)n, (IExpr)F.Times((IExpr)F.CN1, i)))), (IExpr)F.Power((IExpr)F.Sin(theta), i)), 1, ni, 2);
            }
            return F.NIL;
        }

        private static IExpr expandSinPlus(IAST plusAST, int startPosition) {
            IASTAppendable result = F.PlusAlloc(2);
            IExpr lhs = plusAST.get(startPosition);
            if (startPosition == plusAST.size() - 2) {
                IExpr rhs = plusAST.get(startPosition + 1);
                result.append(F.Times((IExpr)F.Sin(lhs), (IExpr)F.Cos(rhs)));
                result.append(F.Times((IExpr)F.Cos(lhs), (IExpr)F.Sin(rhs)));
            } else {
                result.append(F.Times((IExpr)F.Sin(lhs), TrigExpandFunction.expandCosPlus(plusAST, startPosition + 1)));
                result.append(F.Times((IExpr)F.Cos(lhs), TrigExpandFunction.expandSinPlus(plusAST, startPosition + 1)));
            }
            return result;
        }

        private static IExpr expandSinhPlus(IAST plusAST, int startPosition) {
            IASTAppendable result = F.PlusAlloc(2);
            IExpr lhs = plusAST.get(startPosition);
            if (startPosition == plusAST.size() - 2) {
                IExpr rhs = plusAST.get(startPosition + 1);
                result.append(F.Times((IExpr)F.Sinh(lhs), (IExpr)F.Cosh(rhs)));
                result.append(F.Times((IExpr)F.Cosh(lhs), (IExpr)F.Sinh(rhs)));
            } else {
                result.append(F.Times((IExpr)F.Sinh(lhs), TrigExpandFunction.expandCoshPlus(plusAST, startPosition + 1)));
                result.append(F.Times((IExpr)F.Cosh(lhs), TrigExpandFunction.expandSinhPlus(plusAST, startPosition + 1)));
            }
            return result;
        }

        private static IExpr expandCosPlus(IAST plusAST, int startPosition) {
            IASTAppendable result = F.PlusAlloc(2);
            IExpr lhs = plusAST.get(startPosition);
            if (startPosition == plusAST.size() - 2) {
                IExpr rhs = plusAST.get(startPosition + 1);
                result.append(F.Times((IExpr)F.Cos(lhs), (IExpr)F.Cos(rhs)));
                result.append(F.Times((IExpr)F.CN1, (IExpr)F.Sin(lhs), (IExpr)F.Sin(rhs)));
            } else {
                result.append(F.Times((IExpr)F.Cos(lhs), TrigExpandFunction.expandCosPlus(plusAST, startPosition + 1)));
                result.append(F.Times((IExpr)F.CN1, (IExpr)F.Sin(lhs), TrigExpandFunction.expandSinPlus(plusAST, startPosition + 1)));
            }
            return result;
        }

        private static IExpr expandCoshPlus(IAST plusAST, int startPosition) {
            IASTAppendable result = F.PlusAlloc(2);
            IExpr lhs = plusAST.get(startPosition);
            if (startPosition == plusAST.size() - 2) {
                IExpr rhs = plusAST.get(startPosition + 1);
                result.append(F.Times((IExpr)F.Cosh(lhs), (IExpr)F.Cosh(rhs)));
                result.append(F.Times((IExpr)F.Sinh(lhs), (IExpr)F.Sinh(rhs)));
            } else {
                result.append(F.Times((IExpr)F.Cosh(lhs), TrigExpandFunction.expandCoshPlus(plusAST, startPosition + 1)));
                result.append(F.Times((IExpr)F.Sinh(lhs), TrigExpandFunction.expandSinhPlus(plusAST, startPosition + 1)));
            }
            return result;
        }

        private static IExpr expandCschPlus(IAST plusAST, int startPosition) {
            IExpr a = plusAST.get(startPosition);
            if (startPosition != plusAST.size() - 2) {
                return F.NIL;
            }
            IExpr b = plusAST.get(startPosition + 1);
            return F.eval(F.Plus((IExpr)F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.Cosh(b), (IExpr)F.Sinh(a)), (IExpr)F.Times((IExpr)F.Cosh(a), (IExpr)F.Sinh(b))), F.CN1)));
        }

        private static IExpr expandSechPlus(IAST plusAST, int startPosition) {
            IExpr a = plusAST.get(startPosition);
            if (startPosition != plusAST.size() - 2) {
                return F.NIL;
            }
            IExpr b = plusAST.get(startPosition + 1);
            return F.eval(F.Plus((IExpr)F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.Cosh(b), (IExpr)F.Cosh(a)), (IExpr)F.Times((IExpr)F.Sinh(a), (IExpr)F.Sinh(b))), F.CN1)));
        }

        private static IExpr expandTanhPlus(IAST plusAST, int startPosition) {
            IASTAppendable result = F.TimesAlloc(2);
            IExpr lhs = plusAST.get(startPosition);
            if (startPosition == plusAST.size() - 2) {
                IExpr rhs = plusAST.get(startPosition + 1);
                result.append(F.Plus((IExpr)F.Tanh(lhs), (IExpr)F.Tanh(rhs)));
                result.append(F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.Tanh(lhs), (IExpr)F.Tanh(rhs))), F.CN1));
            } else {
                result.append(F.Plus((IExpr)F.Tanh(lhs), TrigExpandFunction.expandTanhPlus(plusAST, startPosition + 1)));
                result.append(F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.Tanh(lhs), TrigExpandFunction.expandTanhPlus(plusAST, startPosition + 1))), F.CN1));
            }
            return result;
        }
    }
}

