/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;

public class Taylor
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (ast.isAST2() && ast.arg2().isVector() == 3) {
            IAST list = (IAST)ast.arg2();
            int upperLimit = Validate.checkIntType(list, 3, 0);
            if (upperLimit < 0) {
                return F.NIL;
            }
            IASTAppendable fadd = F.PlusAlloc(upperLimit + 2);
            fadd.append(F.ReplaceAll(ast.arg1(), F.Rule(list.arg1(), list.arg2())));
            IExpr temp = ast.arg1();
            IASTMutable factor = null;
            for (int i = 1; i <= upperLimit; ++i) {
                temp = F.D(temp, list.arg1());
                factor = F.Times((IExpr)F.Power((IExpr)F.Factorial(F.ZZ(i)), F.CN1), (IExpr)F.Power((IExpr)F.Plus(list.arg1(), (IExpr)F.Times((IExpr)F.CN1, list.arg2())), F.ZZ(i)));
                fadd.append(F.Times((IExpr)F.ReplaceAll(temp, F.Rule(list.arg1(), list.arg2())), (IExpr)factor));
            }
            return fadd;
        }
        return F.NIL;
    }
}

