/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Suppliers;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.ListFunctions;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.Iterator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IIterator;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.Matcher;
import org.matheclipse.core.reflection.system.rulesets.SumRules;

public class Sum
extends ListFunctions.Table
implements SumRules {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Supplier<Matcher> MATCHER1;

    private static Matcher matcher1() {
        return MATCHER1.get();
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr arg1 = ast.arg1();
        if (arg1.isAST()) {
            arg1 = F.expand(arg1, false, false, false);
        }
        if (arg1.isPlus()) {
            return ((IAST)arg1).mapThread(ast, 1);
        }
        IAST preevaledSum = engine.preevalForwardBackwardAST(ast, 1);
        return Sum.evaluateSum(preevaledSum, engine);
    }

    private static IExpr evaluateSum(IAST preevaledSum, EvalEngine engine) {
        if (preevaledSum.size() > 2) {
            try {
                IExpr arg1;
                IExpr result;
                IAST list = preevaledSum.last().isList() ? (IAST)preevaledSum.last() : F.list(preevaledSum.last());
                if (list.isAST1()) {
                    IExpr variable = list.arg1();
                    if (preevaledSum.arg1().isFree(variable) && variable.isVariable()) {
                        return Sum.indefiniteSum(preevaledSum, variable);
                    }
                }
                if (preevaledSum.size() == 3 && (result = Sum.matcher1().apply(preevaledSum)).isPresent()) {
                    return result;
                }
                IExpr argN = preevaledSum.last();
                IExpr temp = Sum.evaluateTableThrow(preevaledSum, F.Plus(), F.Plus(), engine);
                if (temp.isPresent()) {
                    return temp;
                }
                VariablesSet variablesSet = Sum.determineIteratorExprVariables(preevaledSum);
                IASTAppendable varList = variablesSet.getVarList();
                IIterator<IExpr> iterator = null;
                if (argN.isList()) {
                    if ((argN = Sum.evalBlockWithoutReap(argN, varList)).isList()) {
                        iterator = Iterator.create((IAST)argN, preevaledSum.argSize(), engine);
                    } else if (argN.isReal()) {
                        iterator = Iterator.create(F.list(argN), preevaledSum.argSize(), engine);
                    } else {
                        return IOFunctions.printMessage(preevaledSum.topHead(), "nliter", F.list(argN, F.ZZ(preevaledSum.size() - 1)), engine);
                    }
                }
                if ((arg1 = preevaledSum.arg1()).isTimes() && variablesSet.size() > 0 && (temp = Sum.collectConstantFactors(preevaledSum, (IAST)arg1, variablesSet)).isPresent()) {
                    return temp;
                }
                if (iterator != null) {
                    if (arg1.isZero()) {
                        return F.C0;
                    }
                    if (iterator.isValidVariable() && iterator.getUpperLimit().isInfinity()) {
                        if (arg1.isPositiveResult() && arg1.isIntegerResult()) {
                            return F.CInfinity;
                        }
                        if (arg1.isNegativeResult() && arg1.isIntegerResult()) {
                            return F.CNInfinity;
                        }
                    }
                    if (iterator.isValidVariable() && iterator.isNumericFunction()) {
                        IASTAppendable resultList = F.Plus();
                        temp = Sum.evaluateLast(preevaledSum.arg1(), iterator, resultList, F.C0);
                        if (!temp.isPresent() || temp.equals(resultList)) {
                            return F.NIL;
                        }
                        if (preevaledSum.isAST2()) {
                            return temp;
                        }
                        IASTAppendable result2 = preevaledSum.removeAtClone(preevaledSum.argSize());
                        result2.set(1, temp);
                        return result2;
                    }
                    if (iterator.isValidVariable() && !iterator.isNumericFunction() && iterator.getStep().isOne() && (temp = iterator.getUpperLimit().isDirectedInfinity() ? Sum.definiteSumInfinity(arg1, iterator, (IAST)argN, engine) : Sum.definiteSum(arg1, iterator, (IAST)argN, engine)).isPresent()) {
                        if (preevaledSum.isAST2()) {
                            return temp;
                        }
                        IASTAppendable result3 = preevaledSum.removeAtClone(preevaledSum.argSize());
                        result3.set(1, temp);
                        return result3;
                    }
                } else if (argN.isSymbol() && (temp = Sum.indefiniteSum(arg1, (ISymbol)argN)).isPresent()) {
                    if (preevaledSum.isAST2()) {
                        return temp;
                    }
                    IASTAppendable result4 = preevaledSum.removeAtClone(preevaledSum.argSize());
                    result4.set(1, temp);
                    return result4;
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(preevaledSum.topHead(), ve, engine);
            }
        }
        return F.NIL;
    }

    private static IExpr indefiniteSum(IAST ast, IExpr variable) {
        IASTMutable result = F.Times(ast.arg1(), variable);
        int argSize = ast.argSize();
        if (argSize == 2) {
            return result;
        }
        IASTAppendable newSum = ast.removeAtClone(argSize);
        newSum.set(1, result);
        return newSum;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_INFINITY;
    }

    private static IExpr collectConstantFactors(IAST ast, IAST prod, VariablesSet variablesSet) {
        IASTAppendable filterAST = F.TimesAlloc(16);
        IASTAppendable restAST = F.TimesAlloc(16);
        prod.filter(filterAST, restAST, VariablesSet.isFree(variablesSet));
        if (filterAST.size() > 1) {
            IASTMutable reducedSum = ast.setAtCopy(1, restAST.oneIdentity1());
            return F.Times(filterAST.oneIdentity0(), (IExpr)reducedSum);
        }
        return F.NIL;
    }

    private static IExpr definiteSum(IExpr expr, IIterator<IExpr> iterator, IAST list, EvalEngine engine) {
        IExpr temp2;
        IExpr temp1;
        final ISymbol var = iterator.getVariable();
        IExpr from = iterator.getLowerLimit();
        IExpr to = iterator.getUpperLimit();
        if (expr.isFree(var, true)) {
            if (from.isOne()) {
                return F.Times(to, expr);
            }
            if (from.isZero()) {
                return F.Times((IExpr)F.Plus(to, (IExpr)F.C1), expr);
            }
            if (!S.Greater.ofQ(engine, F.C1, from) && !S.Greater.ofQ(engine, from, to)) {
                return F.Times((IExpr)F.Plus((IExpr)F.C1, F.Negate(from), to), expr);
            }
        } else {
            IAST powAST;
            if (expr.isTimes()) {
                IExpr temp;
                IASTAppendable filterCollector = F.TimesAlloc(16);
                IASTAppendable restCollector = F.TimesAlloc(16);
                ((IAST)expr).filter(filterCollector, restCollector, (Predicate<? super IExpr>)new Predicate<IExpr>(){

                    @Override
                    public boolean test(IExpr input) {
                        return input.isFree(var, true);
                    }
                });
                if (filterCollector.size() > 1 && (temp = engine.evalQuiet(F.Sum(restCollector.oneIdentity1(), list))).isFreeAST(S.Sum)) {
                    filterCollector.append(temp);
                    return filterCollector;
                }
            }
            if (expr.equals(var) && (from.isVariable() && !from.equals(var) || to.isVariable() && !to.equals(var))) {
                return F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.Subtract(to, from), (IExpr)F.C1), (IExpr)F.Plus(from, to));
            }
            if (!engine.evalGreater(F.C0, from) && !engine.evalGreater(from, to)) {
                IExpr temp = F.NIL;
                if (expr.isPower()) {
                    temp = Sum.sumPower((IAST)expr, var, from, to);
                } else if (expr.equals(var)) {
                    temp = Sum.sumPowerFormula(from, to, F.C1);
                }
                if (temp.isPresent()) {
                    return temp;
                }
            }
            if (expr.isPower() && !engine.evalGreater(F.C1, from) && !engine.evalGreater(from, to) && (powAST = (IAST)expr).equalsAt(1, var) && powAST.arg2().isFree(var) && to.isFree(var)) {
                if (from.isOne()) {
                    return F.HarmonicNumber(to, powAST.arg2().negate());
                }
                return F.Subtract(F.HurwitzZeta(F.Negate(powAST.arg2()), from), F.HurwitzZeta(F.Negate(powAST.arg2()), F.Plus(1L, to)));
            }
            try {
                IASTAppendable resultList = F.Plus();
                IExpr temp = Sum.evaluateLast(expr, iterator, resultList, F.NIL);
                if (temp.isPresent() && !temp.equals(resultList)) {
                    return temp;
                }
            }
            catch (RecursionLimitExceeded rle) {
                LOGGER.log(engine.getLogLevel(), "Recursionlimit exceeded");
                return F.NIL;
            }
        }
        if (from.isPositive() && !(temp1 = engine.evalQuiet(F.Sum(expr, F.list(var, F.C0, from.minus(F.C1))))).isComplexInfinity() && temp1.isFreeAST(S.Sum) && (temp2 = engine.evalQuietNull(F.Sum(expr, F.list(var, F.C0, to)))).isPresent() && !temp2.isComplexInfinity()) {
            return F.Subtract(temp2, temp1);
        }
        return F.NIL;
    }

    private static IExpr definiteSumInfinity(IExpr expr, IIterator<IExpr> iterator, IAST list, EvalEngine engine) {
        IExpr subSum;
        ISymbol var = iterator.getVariable();
        IExpr from = iterator.getLowerLimit();
        IExpr to = iterator.getUpperLimit();
        if (expr.isZero()) {
            return F.C0;
        }
        if (from.isInteger() && !from.isOne() && (subSum = engine.evaluateNIL(F.Sum(expr, F.list(var, F.C1, to)))).isPresent()) {
            if (S.Less.ofQ(engine, from, F.C1)) {
                return F.Plus((IExpr)F.Sum(expr, F.list(var, from, F.C0)), subSum);
            }
            if (S.Greater.ofQ(engine, from, F.C1)) {
                return F.Subtract(subSum, F.Sum(expr, F.list(var, F.C1, from.minus(F.C1))));
            }
        }
        return F.NIL;
    }

    private static IExpr indefiniteSum(IExpr arg1, final ISymbol var) {
        if (arg1.isTimes()) {
            IASTAppendable filterCollector = F.TimesAlloc(16);
            IASTAppendable restCollector = F.TimesAlloc(16);
            ((IAST)arg1).filter(filterCollector, restCollector, (Predicate<? super IExpr>)new Predicate<IExpr>(){

                @Override
                public boolean test(IExpr input) {
                    return input.isFree(var, true);
                }
            });
            if (filterCollector.size() > 1) {
                if (restCollector.isAST1()) {
                    filterCollector.append(F.Sum(restCollector.arg1(), var));
                } else {
                    filterCollector.append(F.Sum(restCollector, var));
                }
                return filterCollector;
            }
        } else {
            if (arg1.isPower()) {
                return Sum.sumPower((IAST)arg1, var, F.C1, var);
            }
            if (arg1.equals(var)) {
                return Sum.sumPowerFormula(F.C1, var, F.C1);
            }
        }
        return F.NIL;
    }

    public static IExpr sumPower(IAST powAST, ISymbol var, IExpr from, IExpr to) {
        IInteger p;
        if (powAST.equalsAt(1, var) && powAST.arg2().isInteger() && (p = (IInteger)powAST.arg2()).isPositive()) {
            return Sum.sumPowerFormula(from, to, p);
        }
        return F.NIL;
    }

    public static IExpr sumPowerFormula(IExpr from, IExpr to, IInteger p) {
        IExpr term1 = F.NIL;
        if (!from.isOne()) {
            IAST fromMinusOne = F.Plus((IExpr)F.CN1, from);
            term1 = p.isOne() ? F.Times((IExpr)F.C1D2, (IExpr)fromMinusOne, (IExpr)F.Plus((IExpr)F.C1, (IExpr)fromMinusOne)) : F.eval(F.ExpandAll(F.Plus((IExpr)F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)fromMinusOne, (IExpr)F.C1), F.Plus((IExpr)p, (IExpr)F.C1)), (IExpr)F.Power((IExpr)F.Plus((IExpr)p, (IExpr)F.C1), F.CN1)), (IExpr)F.Sum(F.Times((IExpr)F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)fromMinusOne, (IExpr)F.C1), F.Plus((IExpr)F.Plus((IExpr)p, (IExpr)F.Times((IExpr)F.CN1, (IExpr)S.k)), (IExpr)F.C1)), (IExpr)F.Binomial(p, S.k)), (IExpr)F.BernoulliB(S.k)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Plus((IExpr)p, (IExpr)F.Times((IExpr)F.CN1, (IExpr)S.k)), (IExpr)F.C1), F.CN1)), F.list(S.k, F.C1, p)))));
        }
        IExpr term2 = p.isOne() ? F.Times((IExpr)F.C1D2, to, (IExpr)F.Plus((IExpr)F.C1, to)) : F.eval(F.ExpandAll(F.Plus((IExpr)F.Times((IExpr)F.Power((IExpr)F.Plus(to, (IExpr)F.C1), F.Plus((IExpr)p, (IExpr)F.C1)), (IExpr)F.Power((IExpr)F.Plus((IExpr)p, (IExpr)F.C1), F.CN1)), (IExpr)F.Sum(F.Times((IExpr)F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.Plus(to, (IExpr)F.C1), F.Plus((IExpr)F.Plus((IExpr)p, (IExpr)F.Times((IExpr)F.CN1, (IExpr)S.k)), (IExpr)F.C1)), (IExpr)F.Binomial(p, S.k)), (IExpr)F.BernoulliB(S.k)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Plus((IExpr)p, (IExpr)F.Times((IExpr)F.CN1, (IExpr)S.k)), (IExpr)F.C1), F.CN1)), F.List(S.k, F.C1, p)))));
        return term1.isPresent() ? F.Subtract(term2, term1) : term2;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(96);
        MATCHER1 = Suppliers.memoize(SumRules::init1);
    }
}

