/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.linear.FieldMatrix;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.BooleanFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.LinearAlgebra;
import org.matheclipse.core.builtin.PolynomialFunctions;
import org.matheclipse.core.builtin.RootsFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.convert.CreamConvert;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.NoEvalException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.eval.util.SolveUtils;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.QuarticSolver;
import org.matheclipse.core.reflection.system.Eliminate;
import org.matheclipse.core.reflection.system.InverseFunction;

public class Solve
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static IExpr NO_EQUATION_SOLUTION = F.CInfinity;

    protected static IASTAppendable analyzeSublist(ArrayList<ExprAnalyzer> analyzerList, IAST variables, IASTAppendable resultList, int maximumNumberOfResults, IASTAppendable matrix, IASTAppendable vector, EvalEngine engine) throws NoSolution {
        Collections.sort(analyzerList);
        for (int currEquation = 0; currEquation < analyzerList.size(); ++currEquation) {
            ExprAnalyzer exprAnalyzer = analyzerList.get(currEquation);
            if (exprAnalyzer.getNumberOfVars() == 0) {
                IExpr expr = exprAnalyzer.getNumerator();
                if (expr.isZero()) continue;
                if (expr.isNumber() || expr.isInfinity() || expr.isNegativeInfinity()) {
                    throw new NoSolution(0);
                }
                if (S.PossibleZeroQ.ofQ(engine, expr)) continue;
                throw new NoSolution(1);
            }
            if (exprAnalyzer.getNumberOfVars() == 1 && exprAnalyzer.isLinearOrPolynomial()) {
                IAST listOfRules = Solve.rootsOfUnivariatePolynomial(exprAnalyzer, engine);
                if (listOfRules.isPresent()) {
                    listOfRules = exprAnalyzer.mapOnOriginal(listOfRules);
                    boolean evaled = false;
                    ++currEquation;
                    for (int k = 1; k < listOfRules.size(); ++k) {
                        if (currEquation >= analyzerList.size()) {
                            resultList.append(F.list(listOfRules.getAST(k)));
                            if (maximumNumberOfResults > 0 && maximumNumberOfResults <= resultList.size()) {
                                return resultList;
                            }
                            evaled = true;
                            continue;
                        }
                        IAST kListOfSolveRules = listOfRules.getAST(k);
                        ArrayList<ExprAnalyzer> subAnalyzerList = Solve.substituteRulesInSubAnalyzerList(kListOfSolveRules, analyzerList, currEquation, variables, engine);
                        try {
                            IASTAppendable subResultList = Solve.analyzeSublist(subAnalyzerList, variables, F.ListAlloc(), maximumNumberOfResults, matrix, vector, engine);
                            if (!subResultList.isPresent()) continue;
                            evaled = true;
                            IASTAppendable tempResult = Solve.addSubResultsToResultsList(resultList, subResultList, kListOfSolveRules, maximumNumberOfResults);
                            if (!tempResult.isPresent()) continue;
                            return tempResult;
                        }
                        catch (NoSolution e) {
                            if (e.getType() != 0) continue;
                            evaled = true;
                        }
                    }
                    if (evaled) {
                        return resultList;
                    }
                }
                throw new NoSolution(1);
            }
            if (exprAnalyzer.isLinear()) {
                matrix.append(engine.evaluate(exprAnalyzer.getRow()));
                vector.append(engine.evaluate(F.Negate(exprAnalyzer.getValue())));
                continue;
            }
            throw new NoSolution(1);
        }
        return resultList;
    }

    private static IASTAppendable addSubResultsToResultsList(IASTAppendable resultList, IAST subResultList, IAST kListOfSolveRules, int maximumNumberOfResults) {
        for (IExpr expr : subResultList) {
            if (expr.isList()) {
                IASTAppendable list = expr instanceof IASTAppendable ? (IASTAppendable)expr : ((IAST)expr).copyAppendable();
                list.append(1, kListOfSolveRules);
                resultList.append(list);
                if (maximumNumberOfResults <= 0 || maximumNumberOfResults > resultList.size()) continue;
                return resultList;
            }
            resultList.append(expr);
            if (maximumNumberOfResults <= 0 || maximumNumberOfResults > resultList.size()) continue;
            return resultList;
        }
        return F.NIL;
    }

    private static ArrayList<ExprAnalyzer> substituteRulesInSubAnalyzerList(IAST kListOfSolveRules, ArrayList<ExprAnalyzer> analyzerList, int position, IAST variables, EvalEngine engine) {
        ArrayList<ExprAnalyzer> subAnalyzerList = new ArrayList<ExprAnalyzer>();
        for (int i = position; i < analyzerList.size(); ++i) {
            ExprAnalyzer exprAnalyzer;
            IExpr expr = analyzerList.get(i).getExpr();
            IExpr temp = expr.replaceAll(kListOfSolveRules);
            if (temp.isPresent()) {
                expr = engine.evaluate(temp);
                exprAnalyzer = new ExprAnalyzer(expr, variables, engine);
                exprAnalyzer.simplifyAndAnalyze();
            } else {
                exprAnalyzer = analyzerList.get(i);
            }
            subAnalyzerList.add(exprAnalyzer);
        }
        return subAnalyzerList;
    }

    private static IAST rootsOfUnivariatePolynomial(ExprAnalyzer exprAnalyzer, EvalEngine engine) {
        IExpr numerator = exprAnalyzer.getNumerator();
        IExpr denominator = exprAnalyzer.getDenominator();
        for (IExpr variable : exprAnalyzer.getVariableSet()) {
            IAST temp = Solve.rootsOfUnivariatePolynomial(numerator, denominator, variable, engine);
            if (!temp.isPresent()) continue;
            return temp;
        }
        return F.NIL;
    }

    private static IAST rootsOfUnivariatePolynomial(IExpr numerator, IExpr denominator, IExpr variable, EvalEngine engine) {
        IAST temp = F.NIL;
        if (numerator.isNumericMode() && denominator.isOne()) {
            temp = RootsFunctions.roots(numerator, F.list(variable), engine);
        }
        if (!temp.isPresent()) {
            temp = RootsFunctions.rootsOfVariable(numerator, denominator, F.list(variable), numerator.isNumericMode(), engine);
        }
        if (temp.isPresent() && temp.isSameHeadSizeGE(S.List, 2)) {
            IAST rootsList = temp;
            IASTAppendable resultList = F.ListAlloc(rootsList.size());
            for (IExpr root : rootsList) {
                resultList.append(F.Rule(variable, root));
            }
            return QuarticSolver.sortASTArguments(resultList);
        }
        return F.NIL;
    }

    private static IAST splitNumeratorDenominator(IAST expr, EvalEngine engine, boolean evalTogether) {
        IExpr numerator = evalTogether ? Algebra.together(expr, engine) : expr;
        IExpr denominator = engine.evaluate(F.Denominator(numerator));
        numerator = !denominator.isOne() ? engine.evaluate(F.Numerator(numerator)) : expr;
        return F.binaryAST2((IExpr)S.List, numerator, denominator);
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        return Solve.of(ast, false, engine);
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IExpr of(IAST ast, boolean numeric, EvalEngine engine) {
        boolean[] isNumeric = new boolean[]{numeric};
        try {
            if (ast.arg1().isEmptyList()) {
                return F.list(F.CEmptyList);
            }
            IAST userDefinedVariables = Validate.checkIsVariableOrVariableList(ast, 2, ast.topHead(), engine);
            if (!userDefinedVariables.isPresent()) return F.NIL;
            IAST equationVariables = VariablesSet.getVariables(ast.arg1());
            if (userDefinedVariables.isEmpty()) {
                userDefinedVariables = equationVariables;
            }
            ISymbol domain = S.Complexes;
            if (ast.isAST3()) {
                if (!ast.arg3().isSymbol()) {
                    LOGGER.log(engine.getLogLevel(), "{}: domain definition expected at position 3 instead of {}", (Object)ast.topHead(), (Object)ast.arg3());
                    return F.NIL;
                }
                domain = (ISymbol)ast.arg3();
                if (domain.equals(S.Booleans)) {
                    return BooleanFunctions.solveInstances(ast.arg1(), userDefinedVariables, Integer.MAX_VALUE);
                }
                if (domain.equals(S.Integers)) {
                    return Solve.solveIntegers(ast, equationVariables, userDefinedVariables, Integer.MAX_VALUE, engine);
                }
                if (!domain.equals(S.Reals) && !domain.equals(S.Complexes)) {
                    Level level = engine.getLogLevel();
                    LOGGER.log(level, "{}: domain definition expected at position 3 instead of {}", (Object)ast.topHead(), (Object)domain);
                    return F.NIL;
                }
            }
            IAssumptions oldAssumptions = engine.getAssumptions();
            try {
                boolean numericFlag;
                IAssumptions assum = Solve.setVariablesReals(userDefinedVariables, domain);
                if (assum != null) {
                    engine.setAssumptions(assum);
                }
                IASTAppendable termsList = Validate.checkEquationsAndInequations(ast, 1);
                IASTMutable[] lists = SolveUtils.filterSolveLists(termsList, F.NIL, isNumeric);
                boolean bl = numericFlag = isNumeric[0] || numeric;
                if (lists[2].isPresent()) {
                    IExpr result = Solve.solveNumeric(lists[2], numericFlag, engine);
                    if (!result.isPresent()) {
                        IAST iAST = IOFunctions.printMessage(ast.topHead(), "nsmet", F.list(ast.topHead()), engine);
                        return iAST;
                    }
                    IExpr iExpr = Solve.checkDomain(result, domain);
                    return iExpr;
                }
                IASTMutable termsEqualZeroList = lists[0];
                IExpr result = Solve.solveRecursive(termsEqualZeroList, lists[1], numericFlag, userDefinedVariables, engine);
                if (!result.isPresent()) {
                    IAST iAST = IOFunctions.printMessage(ast.topHead(), "nsmet", F.list(ast.topHead()), engine);
                    return iAST;
                }
                IExpr iExpr = Solve.checkDomain(result, domain);
                return iExpr;
            }
            finally {
                engine.setAssumptions(oldAssumptions);
            }
        }
        catch (ValidateException ve) {
            return IOFunctions.printMessage((ISymbol)S.Solve, ve, engine);
        }
        catch (LimitException e) {
            LOGGER.log(engine.getLogLevel(), (Object)S.Solve, (Throwable)((Object)e));
            return F.NIL;
        }
        catch (RuntimeException rex) {
            LOGGER.debug("Solve.of() failed() failed", (Throwable)rex);
        }
        return F.NIL;
    }

    private static IAssumptions setVariablesReals(IAST userDefinedVariables, ISymbol domain) {
        if (domain.equals(S.Reals)) {
            IASTAppendable list = F.ListAlloc(userDefinedVariables.size());
            for (int i = 1; i < userDefinedVariables.size(); ++i) {
                list.append(F.Element(userDefinedVariables.get(i), domain));
            }
            IAssumptions assum = Assumptions.getInstance(list);
            return assum;
        }
        return null;
    }

    public static IExpr solveIntegers(IAST ast, IAST equationVariables, IAST userDefinedVariables, int maximumNumberOfResults, EvalEngine engine) {
        if (!userDefinedVariables.isEmpty()) {
            IASTAppendable equationsAndInequations = Validate.checkEquationsAndInequations(ast, 1);
            if (equationsAndInequations.isEmpty()) {
                return F.NIL;
            }
            try {
                CreamConvert converter = new CreamConvert();
                IAST resultList = converter.integerSolve(equationsAndInequations, equationVariables, userDefinedVariables, maximumNumberOfResults, engine);
                if (resultList.isPresent()) {
                    EvalAttributes.sort((IASTMutable)resultList);
                    return resultList;
                }
            }
            catch (LimitException le) {
                LOGGER.debug("Solve.of() failed", (Throwable)((Object)le));
                throw le;
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), "Integers solution not found", (Throwable)rex);
                return F.NIL;
            }
        }
        return F.NIL;
    }

    private static IExpr checkDomain(IExpr expr, ISymbol domain) {
        if (expr.isListOfRules() && expr.argSize() > 0) {
            expr = F.list(expr);
        }
        if (expr.isList() && domain.equals(S.Reals)) {
            if (expr.isListOfLists()) {
                IASTAppendable result = F.ListAlloc(expr.size());
                for (int i = 1; i < expr.size(); ++i) {
                    IAST listOfRules = (IAST)((IAST)expr).get(i);
                    if (Solve.isComplex(listOfRules)) continue;
                    IASTAppendable appendable = listOfRules.copyAppendable();
                    result.append(appendable);
                }
                return result;
            }
            if (!Solve.isComplex((IAST)expr)) {
                return expr;
            }
            return F.CEmptyList;
        }
        return expr;
    }

    private static boolean isComplex(IAST listOfRules) {
        if (listOfRules.isListOfRules(false)) {
            return listOfRules.exists(x -> !x.second().isRealResult());
        }
        return false;
    }

    private static IExpr solveRecursive(IASTMutable termsEqualZeroList, IASTMutable inequationsList, boolean numericFlag, IAST variables, EvalEngine engine) {
        IASTMutable temp = Solve.solveTimesEquationsRecursively(termsEqualZeroList, inequationsList, numericFlag, variables, true, engine);
        if (temp.isPresent()) {
            return Solve.solveNumeric(QuarticSolver.sortASTArguments(temp), numericFlag, engine);
        }
        if (inequationsList.isEmpty() && termsEqualZeroList.size() == 2 && variables.size() == 2) {
            IExpr firstVariable = variables.arg1();
            IExpr res = Solve.eliminateOneVariable(termsEqualZeroList, firstVariable, true, engine);
            if (!res.isPresent() && numericFlag) {
                res = engine.evalQuiet(F.FindRoot(termsEqualZeroList.arg1(), F.list(firstVariable, F.C0)));
            }
            if (!res.isList() || !res.isFree(t -> t.isIndeterminate() || t.isDirectedInfinity(), true)) {
                return F.NIL;
            }
            return Solve.solveNumeric(res, numericFlag, engine);
        }
        if (termsEqualZeroList.size() > 2 && variables.size() >= 3) {
            IExpr firstEquation = termsEqualZeroList.arg1();
            IExpr firstVariable = variables.arg1();
            IAST[] reduced = Eliminate.eliminateOneVariable(F.list(F.Equal(firstEquation, (IExpr)F.C0)), firstVariable, true, engine);
            if (reduced != null) {
                IAST oneVariableRule;
                variables = variables.splice(1);
                IExpr replaced = (termsEqualZeroList = termsEqualZeroList.removeAtCopy(1)).replaceAll(oneVariableRule = reduced[1]);
                if (replaced.isList()) {
                    IExpr subResult = Solve.solveRecursive((IASTMutable)replaced, inequationsList, numericFlag, variables, engine);
                    if (subResult.isListOfLists()) {
                        IASTAppendable result = F.ListAlloc(subResult.size());
                        for (int i = 1; i < subResult.size(); ++i) {
                            IAST listOfRules = (IAST)subResult.getAt(i);
                            replaced = oneVariableRule.second().replaceAll(listOfRules);
                            if (!replaced.isPresent()) continue;
                            replaced = S.Simplify.of(engine, replaced);
                            IASTAppendable appendable = listOfRules.copyAppendable();
                            appendable.append(F.Rule(firstVariable, replaced));
                            result.append(appendable);
                        }
                        return result;
                    }
                    if (subResult.isList() && (replaced = oneVariableRule.second().replaceAll((IAST)subResult)).isPresent()) {
                        IASTAppendable appendable = ((IAST)subResult).copyAppendable();
                        appendable.append(F.Rule(firstVariable, replaced));
                        return appendable;
                    }
                }
            }
        }
        return F.NIL;
    }

    private static IExpr solveNumeric(IExpr expr, boolean isNumeric, EvalEngine engine) {
        return expr.isPresent() ? (isNumeric ? engine.evalN(expr) : expr) : F.NIL;
    }

    private static IAST eliminateOneVariable(IAST termsEqualZeroList, IExpr variable, boolean multipleValues, EvalEngine engine) {
        IAST lastRuleUsedForVariableElimination;
        if (!termsEqualZeroList.arg1().isFree(t -> t.isIndeterminate() || t.isDirectedInfinity(), true)) {
            return F.NIL;
        }
        IASTMutable equalsASTList = termsEqualZeroList.mapThread(F.Equal((IExpr)F.Slot1, (IExpr)F.C0), 1);
        IAST[] tempAST = Eliminate.eliminateOneVariable(equalsASTList, variable, multipleValues, engine);
        if (tempAST != null && (lastRuleUsedForVariableElimination = tempAST[1]) != null) {
            if (lastRuleUsedForVariableElimination.isRule() && lastRuleUsedForVariableElimination.second().isTrue()) {
                return F.CEmptyList;
            }
            if (lastRuleUsedForVariableElimination.isList()) {
                IAST list = lastRuleUsedForVariableElimination;
                IASTAppendable result = F.ListAlloc(list.size());
                list.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> result.append(F.list(x))));
                return result;
            }
            return F.list(F.list(lastRuleUsedForVariableElimination));
        }
        return F.NIL;
    }

    protected static IASTMutable solveEquations(IASTMutable termsEqualZeroList, IAST inequationsList, IAST variables, int maximumNumberOfResults, EvalEngine engine) {
        try {
            IASTAppendable list = PolynomialFunctions.solveGroebnerBasis(termsEqualZeroList, variables);
            if (list.isPresent()) {
                termsEqualZeroList = list;
            }
        }
        catch (JASConversionException e) {
            LOGGER.debug("Solve.solveEquations() failed", (Throwable)((Object)e));
        }
        for (int i = 1; i < termsEqualZeroList.size(); ++i) {
            Object arg1;
            IExpr eq;
            IExpr equationTerm = termsEqualZeroList.get(i);
            if (!equationTerm.isPlus() || !(eq = S.Equal.of(equationTerm, F.C0)).isEqual() || !(arg1 = eq.first()).isPlus2() || !arg1.first().isSqrtExpr() || !arg1.second().isSqrtExpr()) continue;
            termsEqualZeroList.set(i, S.Subtract.of(S.Expand.of(F.Sqr(arg1.second())), S.Expand.of(F.Sqr(F.Subtract(eq.second(), arg1.first())))));
        }
        ArrayList<ExprAnalyzer> analyzerList = new ArrayList<ExprAnalyzer>();
        IsWrongSolveExpression predicate = new IsWrongSolveExpression();
        for (IExpr expr : termsEqualZeroList) {
            if (expr.has(predicate, true)) {
                LOGGER.log(engine.getLogLevel(), "Solve: the system contains the wrong object: {}", (Object)predicate.getWrongExpr());
                throw new NoEvalException();
            }
            ExprAnalyzer exprAnalyzer = new ExprAnalyzer(expr, variables, engine);
            exprAnalyzer.simplifyAndAnalyze();
            analyzerList.add(exprAnalyzer);
        }
        IASTAppendable matrix = F.ListAlloc();
        IASTAppendable vector = F.ListAlloc();
        try {
            IASTAppendable resultList = F.ListAlloc();
            resultList = Solve.analyzeSublist(analyzerList, variables, resultList, maximumNumberOfResults, matrix, vector, engine);
            if (vector.size() > 1) {
                FieldMatrix<IExpr> augmentedMatrix = Convert.list2Matrix(matrix, vector);
                if (augmentedMatrix != null) {
                    IAST subSolutionList = LinearAlgebra.rowReduced2RulesList(augmentedMatrix, variables, resultList, engine);
                    return Solve.solveInequations((IASTMutable)subSolutionList, inequationsList, maximumNumberOfResults, engine);
                }
                return F.NIL;
            }
            return Solve.solveInequations(resultList, inequationsList, maximumNumberOfResults, engine);
        }
        catch (NoSolution e) {
            if (e.getType() == 0) {
                return F.ListAlloc();
            }
            return F.NIL;
        }
    }

    protected static IASTMutable solveInequations(IASTMutable subSolutionList, IAST inequationsList, int maximumNumberOfResults, EvalEngine engine) {
        if (inequationsList.isEmpty()) {
            return QuarticSolver.sortASTArguments(subSolutionList);
        }
        if (subSolutionList.isListOfLists()) {
            IASTAppendable result = F.ListAlloc(subSolutionList.size());
            for (int i = 1; i < subSolutionList.size(); ++i) {
                IASTMutable[] lists;
                IASTMutable list = (IASTMutable)subSolutionList.get(i);
                IExpr temp = F.subst((IExpr)inequationsList, list);
                boolean[] isNumeric = new boolean[]{false};
                if (!(temp = engine.evalQuiet(temp)).isAST() || !(lists = SolveUtils.filterSolveLists((IASTMutable)temp, list, isNumeric))[2].isPresent() || lists[2].isEmptyList()) continue;
                result.append(lists[2]);
            }
            return result;
        }
        return F.NIL;
    }

    private static IASTMutable solveTimesEquationsRecursively(IASTMutable termsEqualZeroList, IAST inequationsList, boolean numericFlag, IAST variables, boolean multipleValues, EvalEngine engine) {
        try {
            IASTMutable resultList = Solve.solveEquations(termsEqualZeroList, inequationsList, variables, 0, engine);
            if (resultList.isPresent() && !resultList.isEmpty()) {
                return resultList;
            }
            TreeSet<IExpr> subSolutionSet = new TreeSet<IExpr>();
            for (int i = 1; i < termsEqualZeroList.size(); ++i) {
                IExpr termEQZero = termsEqualZeroList.get(i);
                if (termEQZero.isTimes()) {
                    Solve.solveTimesAST((IAST)termEQZero, termsEqualZeroList, inequationsList, numericFlag, variables, multipleValues, engine, subSolutionSet, i);
                    continue;
                }
                if (!termEQZero.isAST() || !(termEQZero = S.Factor.of(engine, termEQZero)).isTimes()) continue;
                Solve.solveTimesAST((IAST)termEQZero, termsEqualZeroList, inequationsList, numericFlag, variables, multipleValues, engine, subSolutionSet, i);
            }
            if (subSolutionSet.size() > 0) {
                return F.ListAlloc(subSolutionSet);
            }
            return resultList;
        }
        catch (LimitException le) {
            LOGGER.debug("Solve.solveTimesEquationsRecursively() failed", (Throwable)((Object)le));
            throw le;
        }
        catch (RuntimeException rex) {
            LOGGER.debug("Solve.solveTimesEquationsRecursively() failed", (Throwable)rex);
            return F.NIL;
        }
    }

    private static void solveTimesAST(IAST times, IAST termsEqualZeroList, IAST inequationsList, boolean numericFlag, IAST variables, boolean multipleValues, EvalEngine engine, Set<IExpr> subSolutionSet, int i) {
        for (int j = 1; j < times.size(); ++j) {
            if (times.get(j).isFree(Predicates.in(variables), true)) continue;
            IASTMutable clonedEqualZeroList = termsEqualZeroList.setAtCopy(i, times.get(j));
            IASTMutable temp = Solve.solveEquations(clonedEqualZeroList, inequationsList, variables, 0, engine);
            if (temp.size() > 1) {
                for (int k = 1; k < temp.size(); ++k) {
                    IExpr solution = temp.get(k);
                    IExpr replaceAll = engine.evalQuiet(F.ReplaceAll(times, solution));
                    IExpr zeroCrossCheck = engine.evalN(replaceAll);
                    if (zeroCrossCheck.isZero()) {
                        subSolutionSet.add(solution);
                        continue;
                    }
                    if (!replaceAll.isPlusTimesPower() || !S.PossibleZeroQ.ofQ(engine, replaceAll)) continue;
                    subSolutionSet.add(solution);
                }
                continue;
            }
            if (clonedEqualZeroList.size() != 2 || variables.size() != 2) continue;
            IExpr firstVariable = variables.arg1();
            IExpr res = Solve.eliminateOneVariable(clonedEqualZeroList, firstVariable, multipleValues, engine);
            if (!res.isPresent() && numericFlag) {
                res = S.FindRoot.ofNIL(engine, clonedEqualZeroList.arg1(), F.list(firstVariable, F.C0));
            }
            if (!res.isList() || !res.isFree(t -> t.isIndeterminate() || t.isDirectedInfinity(), true)) continue;
            IAST subResult = res;
            for (int k = 1; k < subResult.size(); ++k) {
                subSolutionSet.add(Solve.solveNumeric(subResult.get(i), numericFlag, engine));
            }
        }
    }

    protected static class NoSolution
    extends Exception {
        private static final long serialVersionUID = -8578380756971796776L;
        public static final int NO_SOLUTION_FOUND = 1;
        public static final int WRONG_SOLUTION = 0;
        final int solType;

        public NoSolution(int solType) {
            this.solType = solType;
        }

        public int getType() {
            return this.solType;
        }
    }

    protected static final class IsWrongSolveExpression
    implements Predicate<IExpr> {
        IExpr wrongExpr = null;

        public IExpr getWrongExpr() {
            return this.wrongExpr;
        }

        @Override
        public boolean test(IExpr input) {
            if (input.isDirectedInfinity() || input.isIndeterminate()) {
                this.wrongExpr = input;
                return true;
            }
            return false;
        }
    }

    protected static class ExprAnalyzer
    implements Comparable<ExprAnalyzer> {
        public static final int LINEAR = 0;
        public static final int POLYNOMIAL = 1;
        public static final int OTHERS = 2;
        private int fEquationType;
        private IExpr fExpr;
        private IExpr fOriginalExpr = null;
        private IExpr fNumerator;
        private IExpr fDenominator;
        private long fLeafCount;
        private HashSet<IExpr> fVariableSet;
        private IASTAppendable fMatrixRow;
        private IASTAppendable fPlusAST;
        final IAST fListOfVariables;
        final EvalEngine fEngine;

        public ExprAnalyzer(IExpr expr, IAST listOfVariables, EvalEngine engine) {
            this.fEngine = engine;
            this.fExpr = expr;
            this.fNumerator = expr;
            this.fDenominator = F.C1;
            if (this.fExpr.isAST()) {
                this.splitNumeratorDenominator((IAST)this.fExpr);
            }
            this.fListOfVariables = listOfVariables;
            this.fVariableSet = new HashSet();
            this.fLeafCount = 0L;
            this.reset();
        }

        private void analyze(IExpr eqExpr) {
            if (eqExpr.isFree(Predicates.in(this.fListOfVariables), true)) {
                ++this.fLeafCount;
                this.fPlusAST.append(eqExpr);
            } else if (eqExpr.isPlus()) {
                ++this.fLeafCount;
                IAST plusAST = (IAST)eqExpr;
                for (int i = 1; i < plusAST.size(); ++i) {
                    IExpr expr = plusAST.get(i);
                    if (expr.isFree(Predicates.in(this.fListOfVariables), true)) {
                        ++this.fLeafCount;
                        this.fPlusAST.append(expr);
                        continue;
                    }
                    this.getPlusArgumentEquationType(expr);
                }
            } else {
                this.getPlusArgumentEquationType(eqExpr);
            }
        }

        @Override
        public int compareTo(ExprAnalyzer o) {
            if (this.fVariableSet.size() != o.fVariableSet.size()) {
                return this.fVariableSet.size() < o.fVariableSet.size() ? -1 : 1;
            }
            if (this.fEquationType != o.fEquationType) {
                return this.fEquationType < o.fEquationType ? -1 : 1;
            }
            if (this.fLeafCount != o.fLeafCount) {
                return this.fLeafCount < o.fLeafCount ? -1 : 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExprAnalyzer other = (ExprAnalyzer)obj;
            if (this.fDenominator == null ? other.fDenominator != null : !this.fDenominator.equals(other.fDenominator)) {
                return false;
            }
            if (this.fEquationType != other.fEquationType) {
                return false;
            }
            if (this.fExpr == null ? other.fExpr != null : !this.fExpr.equals(other.fExpr)) {
                return false;
            }
            if (this.fLeafCount != other.fLeafCount) {
                return false;
            }
            if (this.fMatrixRow == null ? other.fMatrixRow != null : !this.fMatrixRow.equals(other.fMatrixRow)) {
                return false;
            }
            if (this.fNumerator == null ? other.fNumerator != null : !this.fNumerator.equals(other.fNumerator)) {
                return false;
            }
            if (this.fPlusAST == null ? other.fPlusAST != null : !this.fPlusAST.equals(other.fPlusAST)) {
                return false;
            }
            if (this.fVariableSet == null ? other.fVariableSet != null : !this.fVariableSet.equals(other.fVariableSet)) {
                return false;
            }
            return !(this.fListOfVariables == null ? other.fListOfVariables != null : !this.fListOfVariables.equals(other.fListOfVariables));
        }

        public IExpr getDenominator() {
            return this.fDenominator;
        }

        public IExpr getExpr() {
            return this.fExpr;
        }

        public int getNumberOfVars() {
            return this.fVariableSet.size();
        }

        public IExpr getNumerator() {
            return this.fNumerator;
        }

        private void getPlusArgumentEquationType(IExpr eqExpr) {
            if (eqExpr.isTimes()) {
                IExpr variable = null;
                ++this.fLeafCount;
                IAST arg = (IAST)eqExpr;
                for (int i = 1; i < arg.size(); ++i) {
                    IExpr expr = arg.get(i);
                    if (expr.isFree(Predicates.in(this.fListOfVariables), true)) {
                        ++this.fLeafCount;
                        continue;
                    }
                    if (expr.isVariable()) {
                        ++this.fLeafCount;
                        for (int j = 1; j < this.fListOfVariables.size(); ++j) {
                            if (!this.fListOfVariables.get(j).equals(expr)) continue;
                            this.fVariableSet.add(expr);
                            if (variable != null) {
                                if (this.fEquationType != 0) continue;
                                this.fEquationType = 1;
                                continue;
                            }
                            variable = expr;
                            if (this.fEquationType != 0) continue;
                            IAST cloned = arg.splice(i);
                            this.fMatrixRow.set(j, F.Plus(this.fMatrixRow.get(j), (IExpr)cloned));
                        }
                        continue;
                    }
                    if (expr.isPower() && (expr.base().isInteger() || expr.exponent().isNumIntValue())) {
                        if (this.fEquationType == 0) {
                            this.fEquationType = 1;
                        }
                        this.getTimesArgumentEquationType(expr.base());
                        continue;
                    }
                    this.fLeafCount += eqExpr.leafCount();
                    if (this.fEquationType > 1) continue;
                    this.fEquationType = 2;
                }
                if (this.fEquationType == 0 && variable == null) {
                    LOGGER.error("sym == null???");
                }
            } else {
                this.getTimesArgumentEquationType(eqExpr);
            }
        }

        public IAST getRow() {
            return this.fMatrixRow;
        }

        public Set<IExpr> getVariableSet() {
            return this.fVariableSet;
        }

        private void getTimesArgumentEquationType(IExpr expr) {
            if (expr.isVariable()) {
                ++this.fLeafCount;
                int position = this.fListOfVariables.indexOf(expr);
                if (position > 0) {
                    this.fVariableSet.add(expr);
                    if (this.fEquationType == 0) {
                        this.fMatrixRow.set(position, F.Plus(this.fMatrixRow.get(position), (IExpr)F.C1));
                    }
                }
                return;
            }
            if (expr.isFree(Predicates.in(this.fListOfVariables), true)) {
                ++this.fLeafCount;
                this.fPlusAST.append(expr);
                return;
            }
            if (expr.isPower()) {
                IExpr base = expr.base();
                IExpr exponent = expr.exponent();
                if (exponent.isInteger()) {
                    if (this.fEquationType == 0) {
                        this.fEquationType = 1;
                    }
                    this.getTimesArgumentEquationType(base);
                    return;
                }
                if (exponent.isNumIntValue()) {
                    if (this.fEquationType == 0) {
                        this.fEquationType = 1;
                    }
                    this.getTimesArgumentEquationType(base);
                    return;
                }
            }
            this.fLeafCount += expr.leafCount();
            if (this.fEquationType <= 1) {
                this.fEquationType = 2;
            }
        }

        public IExpr getValue() {
            return this.fPlusAST.oneIdentity0();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fDenominator == null ? 0 : this.fDenominator.hashCode());
            result = 31 * result + this.fEquationType;
            result = 31 * result + (this.fExpr == null ? 0 : this.fExpr.hashCode());
            result = 31 * result + (int)(this.fLeafCount ^ this.fLeafCount >>> 32);
            result = 31 * result + (this.fMatrixRow == null ? 0 : this.fMatrixRow.hashCode());
            result = 31 * result + (this.fNumerator == null ? 0 : this.fNumerator.hashCode());
            result = 31 * result + (this.fPlusAST == null ? 0 : this.fPlusAST.hashCode());
            result = 31 * result + (this.fVariableSet == null ? 0 : this.fVariableSet.hashCode());
            result = 31 * result + (this.fListOfVariables == null ? 0 : this.fListOfVariables.hashCode());
            return result;
        }

        public boolean isLinear() {
            return this.fEquationType == 0;
        }

        public boolean isLinearOrPolynomial() {
            return this.fEquationType == 0 || this.fEquationType == 1;
        }

        public IAST mapOnOriginal(IAST listOfResultRules) {
            if (this.fOriginalExpr != null) {
                IASTAppendable list2 = F.ListAlloc(listOfResultRules.size());
                for (int i = 1; i < listOfResultRules.size(); ++i) {
                    IExpr temp = this.fOriginalExpr.replaceAll((IAST)listOfResultRules.get(i));
                    if (!temp.isPresent() || !(temp = this.fEngine.evaluate(temp)).isZero()) continue;
                    list2.append(listOfResultRules.get(i));
                }
                return list2;
            }
            return listOfResultRules;
        }

        public void reset() {
            int size = this.fListOfVariables.size();
            this.fMatrixRow = F.constantArray(F.C0, size - 1);
            this.fPlusAST = F.PlusAlloc(8);
            this.fEquationType = 0;
        }

        private IExpr rewriteInverseFunction(IAST ast, IExpr arg1) {
            IAST timesArg2;
            IASTAppendable inverseFunction;
            if (ast.isAbs() || ast.isAST(S.RealAbs, 2)) {
                return this.fEngine.evaluate(F.Expand(F.Times((IExpr)F.Subtract(ast.arg1(), F.Times((IExpr)F.CN1, arg1)), (IExpr)F.Subtract(ast.arg1(), arg1))));
            }
            if (ast.isAST1()) {
                IASTAppendable inverseFunction2 = InverseFunction.getUnaryInverseFunction(ast, true);
                if (inverseFunction2.isPresent()) {
                    IOFunctions.printIfunMessage(S.InverseFunction);
                    inverseFunction2.append(arg1);
                    return this.fEngine.evaluate(F.Subtract(ast.arg1(), inverseFunction2));
                }
            } else if (ast.isPower() && ast.base().isSymbol() && ast.exponent().isNumber()) {
                int position = this.fListOfVariables.indexOf(ast.base());
                if (position > 0) {
                    IOFunctions.printIfunMessage(S.InverseFunction);
                    IAST inverseFunction3 = F.Power(arg1, ast.exponent().inverse());
                    return this.fEngine.evaluate(F.Subtract(ast.base(), inverseFunction3));
                }
            } else if (ast.isTimes() && ast.size() == 3 && ast.first().isNumericFunction(true) && ast.second().isAST1() && (inverseFunction = InverseFunction.getUnaryInverseFunction(timesArg2 = (IAST)ast.second(), true)).isPresent()) {
                IOFunctions.printIfunMessage(S.InverseFunction);
                inverseFunction.append(F.Divide(arg1, ast.first()));
                return this.fEngine.evaluate(F.Subtract(timesArg2.arg1(), inverseFunction));
            }
            return F.NIL;
        }

        private IExpr rewriteInverseFunction(IAST plusAST, int position) {
            IAST ast = (IAST)plusAST.get(position);
            IExpr plus = plusAST.splice(position).oneIdentity0();
            if (ast.isAbs() || ast.isAST(S.RealAbs, 2)) {
                if ((plus.isNegative() || plus.isZero()) && plus.isFree(Predicates.in(this.fListOfVariables), true)) {
                    return this.rewriteInverseFunction(ast, F.Negate(plus));
                }
                return F.NIL;
            }
            if (plus.isFree(Predicates.in(this.fListOfVariables), true)) {
                return this.rewriteInverseFunction(ast, F.Negate(plus));
            }
            return F.NIL;
        }

        private IExpr rewritePlusWithInverseFunctions(IAST plusAST) {
            for (int i = 1; i < plusAST.size(); ++i) {
                IExpr temp;
                IExpr expr = plusAST.get(i);
                if (expr.isFree(Predicates.in(this.fListOfVariables), true) || !expr.isAST()) continue;
                IAST function = (IAST)expr;
                IASTAppendable inverseFunction = InverseFunction.getUnaryInverseFunction(function, true);
                if (inverseFunction.isPresent()) {
                    temp = this.rewriteInverseFunction(plusAST, i);
                    if (!temp.isPresent()) continue;
                    return temp;
                }
                if (function.isPower()) {
                    return this.rewritePowerFractions(plusAST, i, F.C1, function.base(), function.exponent());
                }
                if (function.isTimes() && function.size() == 3 && function.arg1().isNumericFunction(true)) {
                    IExpr temp2;
                    IASTAppendable inverseTimesFunction;
                    if (function.arg2().isPower()) {
                        IAST power = (IAST)function.arg2();
                        IExpr temp3 = this.rewritePowerFractions(plusAST, i, function.arg1(), power.base(), power.exponent());
                        if (!temp3.isPresent()) continue;
                        return this.fEngine.evaluate(temp3);
                    }
                    if (!function.arg2().isAST1() || !(inverseTimesFunction = InverseFunction.getUnaryInverseFunction((IAST)function.arg2(), true)).isPresent() || !(temp2 = this.rewriteInverseFunction(plusAST, i)).isPresent()) continue;
                    return temp2;
                }
                if (!function.isAST(S.GammaRegularized, 3)) continue;
                temp = plusAST.removeAtCopy(i);
                int position = this.fListOfVariables.indexOf(function.arg2());
                if (position <= 0 || !function.arg1().isFree(this.fListOfVariables) || !temp.isFree(this.fListOfVariables)) continue;
                IOFunctions.printIfunMessage(S.InverseFunction);
                return this.fEngine.evaluate(F.InverseGammaRegularized(function.arg1(), temp.negate()));
            }
            return F.NIL;
        }

        private IExpr rewritePowerFractions(IAST plusAST, int i, IExpr num, IExpr base, IExpr exponent) {
            if (exponent.isFraction() || exponent.isReal() && !exponent.isNumIntValue()) {
                ISignedNumber arg2 = (ISignedNumber)exponent;
                if (arg2.isPositive()) {
                    IExpr plus = plusAST.splice(i).oneIdentity0();
                    if (plus.isPositiveResult()) {
                        return NO_EQUATION_SOLUTION;
                    }
                    this.fOriginalExpr = plusAST;
                    if (num.isOne()) {
                        return this.fEngine.evaluate(F.Subtract(F.Expand(F.Power(F.Negate(plus), arg2.inverse())), base));
                    }
                    return this.fEngine.evaluate(F.Subtract(base, F.Expand(F.Power((IExpr)F.Times(num.inverse(), F.Negate(plus)), arg2.inverse()))));
                }
            } else if (base.isVariable() && base.equals(exponent)) {
                IExpr plus = plusAST.splice(i).oneIdentity0().negate().divide(num);
                IAST inverseFunction = F.Plus(base, (IExpr)F.Times(F.Log(plus).negate(), (IExpr)F.Power((IExpr)F.ProductLog(F.Log(plus)), F.CN1)));
                return this.fEngine.evaluate(inverseFunction);
            }
            if (this.fListOfVariables.size() == 2) {
                IExpr variable = this.fListOfVariables.arg1();
                return this.rewritePower2ProductLog(plusAST, i, num, base, exponent, variable);
            }
            return F.NIL;
        }

        private IExpr rewritePower2ProductLog(IAST plusAST, int i, IExpr num, IExpr base, IExpr exponent, IExpr variable) {
            if (variable.equals(exponent) && base.isFree(variable)) {
                IExpr restOfPlus = plusAST.splice(i).oneIdentity0();
                IExpr a = F.NIL;
                IExpr b = F.C0;
                if (restOfPlus.isPlus()) {
                    IExpr restOfPlus2;
                    int indx = restOfPlus.indexOf(x -> !x.isFree(variable));
                    if (indx > 0 && (restOfPlus2 = ((IAST)restOfPlus).splice(indx).oneIdentity1()).isFree(variable)) {
                        a = ExprAnalyzer.determineFactor(((IAST)restOfPlus).get(i), variable);
                        b = restOfPlus2;
                    }
                } else {
                    a = ExprAnalyzer.determineFactor(restOfPlus, variable);
                }
                if (a.isPresent()) {
                    IAST inverseFunction = F.Plus(variable, (IExpr)F.Times((IExpr)F.Plus((IExpr)F.Times(b, (IExpr)F.Log(base)), (IExpr)F.Times(a, (IExpr)F.ProductLog(F.Times(num, (IExpr)F.Log(base), (IExpr)F.Power((IExpr)F.Times(a, (IExpr)F.Power(base, F.Divide(b, a))), F.CN1))))), (IExpr)F.Power((IExpr)F.Times(a, (IExpr)F.Log(base)), F.CN1)));
                    return this.fEngine.evaluate(inverseFunction);
                }
            }
            return F.NIL;
        }

        private static IExpr determineFactor(IExpr restOfPlus, IExpr variable) {
            IExpr restOfTimes;
            int indx;
            if (restOfPlus.equals(variable)) {
                return F.C1;
            }
            if (restOfPlus.isTimes() && (indx = restOfPlus.indexOf(variable)) > 0 && (restOfTimes = ((IAST)restOfPlus).splice(indx).oneIdentity1()).isFree(variable)) {
                return restOfTimes;
            }
            return F.NIL;
        }

        private IExpr rewriteTimesWithInverseFunctions(IAST times) {
            IASTAppendable result = F.NIL;
            int j = 1;
            for (int i = 1; i < times.size(); ++i) {
                if (times.get(i).isFree(Predicates.in(this.fListOfVariables), true) && times.get(i).isNumericFunction(true)) {
                    if (!result.isPresent()) {
                        result = times.copyAppendable();
                    }
                    result.remove(j);
                    continue;
                }
                ++j;
            }
            if (!result.isPresent()) {
                return this.rewriteInverseFunction(times, F.C0);
            }
            IExpr temp0 = result.oneIdentity1();
            if (temp0.isAST()) {
                return this.rewriteInverseFunction((IAST)temp0, F.C0).orElse(temp0);
            }
            return temp0;
        }

        protected void simplifyAndAnalyze() {
            IExpr temp = F.NIL;
            if (this.fNumerator.isPlus()) {
                temp = this.rewritePlusWithInverseFunctions((IAST)this.fNumerator);
            } else if (this.fNumerator.isTimes() && !this.fNumerator.isFree(Predicates.in(this.fListOfVariables), true)) {
                temp = this.rewriteTimesWithInverseFunctions((IAST)this.fNumerator);
            } else if (this.fNumerator.isAST() && !this.fNumerator.isFree(Predicates.in(this.fListOfVariables), true)) {
                temp = this.rewriteInverseFunction((IAST)this.fNumerator, F.C0);
            }
            if (temp.isPresent()) {
                if (temp.isAST() && this.fDenominator.isOne()) {
                    this.splitNumeratorDenominator((IAST)temp);
                } else {
                    this.fNumerator = temp;
                }
            }
            this.analyze(this.fNumerator);
        }

        public void splitNumeratorDenominator(IAST ast) {
            IExpr[] result = Algebra.getNumeratorDenominator(ast, this.fEngine);
            this.fNumerator = result[0];
            this.fDenominator = result[1];
            this.fExpr = result[2];
        }
    }
}

