/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.visit.VisitorExpr;

public class Share
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (ast.arg1() instanceof IASTMutable) {
            return F.ZZ(Share.shareAST((IASTMutable)ast.arg1()));
        }
        return F.C0;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_1;
    }

    private static int shareAST(IASTMutable ast) {
        ShareReplaceAll sra = Share.createVisitor();
        ast.accept(sra);
        return sra.fCounter;
    }

    public static ShareReplaceAll createVisitor() {
        return new ShareReplaceAll(new ShareFunction());
    }

    private static class ShareReplaceAll
    extends VisitorExpr {
        final Function<IASTMutable, IExpr> fFunction;
        public int fCounter;

        public ShareReplaceAll(Function<IASTMutable, IExpr> function) {
            this.fFunction = function;
            this.fCounter = 0;
        }

        @Override
        public IExpr visit(IASTMutable ast) {
            if (ast.size() <= 1) {
                return F.NIL;
            }
            IExpr temp = this.fFunction.apply(ast);
            if (temp.isPresent()) {
                ++this.fCounter;
                return temp;
            }
            return this.visitAST(ast);
        }

        @Override
        protected IExpr visitAST(IAST ast) {
            boolean evaled = false;
            for (int i = 1; i < ast.size(); ++i) {
                IExpr temp;
                IExpr arg = ast.getRule(i);
                if (!(arg instanceof IASTMutable) || !(temp = this.visit((IASTMutable)arg)).isPresent()) continue;
                ((IASTMutable)ast).set(i, temp);
                evaled = true;
            }
            return evaled ? ast : F.NIL;
        }
    }

    private static class ShareFunction
    implements Function<IASTMutable, IExpr> {
        Map<IASTMutable, IASTMutable> map = new HashMap<IASTMutable, IASTMutable>(128);

        @Override
        public IExpr apply(IASTMutable t) {
            IExpr value = this.map.get(t);
            if (value == null) {
                this.map.put(t, t);
                return F.NIL;
            }
            if (value == t) {
                return F.NIL;
            }
            return value;
        }
    }
}

