/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.hipparchus.complex.Complex;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Eliminate;

public class Reduce
extends AbstractEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IAST vars;
        ISymbol domain = S.Reals;
        if (ast.isAST2() || ast.isAST3()) {
            vars = ast.arg2().isList() ? (IAST)ast.arg2() : F.list(ast.arg2());
        } else {
            VariablesSet eVar = new VariablesSet(ast.arg1());
            vars = eVar.getVarList();
        }
        if (!vars.isList1()) {
            return F.NIL;
        }
        if (ast.isAST3()) {
            if (ast.arg3().isSymbol()) {
                domain = (ISymbol)ast.arg3();
            } else {
                return F.NIL;
            }
        }
        if (domain != S.Reals) {
            return F.NIL;
        }
        try {
            IExpr expr = ast.arg1();
            if (ast.arg1().isList()) {
                expr = ((IAST)expr).setAtCopy(0, S.And);
            } else if (!expr.isBooleanFunction() && !expr.isComparatorFunction()) {
                expr = F.And(expr);
            }
            IExpr variable = vars.get(1);
            IExpr logicalExpand = S.LogicalExpand.of(engine, expr);
            if (logicalExpand.isTrue() || logicalExpand.isFalse()) {
                return logicalExpand;
            }
            if (!logicalExpand.isBooleanFunction()) {
                logicalExpand = F.And(logicalExpand);
            }
            if (logicalExpand.isAST(S.And)) {
                IAST andAST = (IAST)logicalExpand;
                IASTMutable andResult = andAST.copy();
                for (int i = 1; i < andAST.size(); ++i) {
                    IExpr roots;
                    IExpr arg = andAST.get(i);
                    if (!arg.isEqual() || !(roots = S.Roots.ofNIL(engine, arg, variable)).isPresent()) continue;
                    andResult.set(i, roots);
                }
                logicalExpand = S.LogicalExpand.of(engine, andResult);
                if (logicalExpand.isTrue() || logicalExpand.isFalse()) {
                    return logicalExpand;
                }
            }
            ReduceComparison rc = new ReduceComparison(variable);
            IExpr reduced = rc.evaluate(logicalExpand);
            return reduced.orElse(logicalExpand);
        }
        catch (RuntimeException rex) {
            rex.printStackTrace();
            return F.NIL;
        }
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_3;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
    }

    static class ReduceComparison {
        final IExpr variable;

        public ReduceComparison(IExpr variable) {
            this.variable = variable;
        }

        protected IExpr evaluate(IExpr logicalExpand) throws ArgumentTypeException {
            return this.reduceAndOr(logicalExpand);
        }

        private IExpr reduceAndOr(IExpr expr) throws ArgumentTypeException {
            if (expr.isAST(S.And)) {
                VariableInterval cd = new VariableInterval(this.variable);
                IExpr temp = this.reduceAnd((IAST)expr, cd);
                if (temp.isPresent()) {
                    if (temp == S.Continue) {
                        return cd.toExpr();
                    }
                    return temp;
                }
                return F.NIL;
            }
            if (expr.isAST(S.Or)) {
                VariableInterval cd = new VariableInterval(this.variable);
                IExpr temp = this.reduceOr((IAST)expr, cd);
                if (temp.isPresent()) {
                    if (temp == S.Continue) {
                        return cd.toExpr();
                    }
                    return temp;
                }
                return F.NIL;
            }
            return F.NIL;
        }

        private IExpr reduceOr(IAST expr, VariableInterval cd) throws ArgumentTypeException {
            IAST orAST = expr;
            if (orAST.isAST0()) {
                throw new ArgumentTypeException("Or: size == 0");
            }
            if (orAST.isAST1()) {
                return orAST.arg1();
            }
            for (int i = 1; i < orAST.size(); ++i) {
                IExpr arg = orAST.get(i);
                if (arg.isAST(S.And)) {
                    VariableInterval andCD = new VariableInterval(this.variable);
                    IExpr temp = this.reduceAnd((IAST)arg, andCD);
                    if (temp.isPresent()) {
                        if (temp == S.Continue) {
                            if (cd.isInitial()) {
                                cd.set(andCD);
                                continue;
                            }
                            if (cd.reduceOr(andCD)) continue;
                            return F.NIL;
                        }
                        return temp;
                    }
                    return F.NIL;
                }
                IExpr temp = S.Simplify.of(arg);
                if (!temp.isAST2() || !temp.first().equals(this.variable)) continue;
                VariableInterval comparatorCD = new VariableInterval(this.variable);
                if ((temp = comparatorCD.reduceAnd(temp.headID(), temp.second())) != S.Continue) {
                    if (temp.isTrue()) continue;
                    if (temp.isFalse()) {
                        return S.False;
                    }
                    return temp;
                }
                if (cd.isInitial()) {
                    cd.set(comparatorCD);
                    continue;
                }
                if (cd.reduceOr(comparatorCD)) continue;
                return F.NIL;
            }
            return S.Continue;
        }

        public IExpr reduceAnd(IAST andExpr, VariableInterval variableInterval) throws ArgumentTypeException {
            IASTMutable andAST = andExpr.copy();
            if (andAST.isAST0()) {
                throw new ArgumentTypeException("And: size == 0");
            }
            if (andAST.isAST1()) {
                return andAST.arg1();
            }
            boolean andEvaled = false;
            boolean variableInternalContinued = true;
            IExpr lastArg = this.rewriteVariableValue(variableInterval, andAST.arg1());
            int lastIndex = 1;
            IExpr temp = F.NIL;
            if (lastArg.isAST2() && lastArg.first().equals(variableInterval.variable) && (temp = variableInterval.reduceAnd(lastArg.headID(), lastArg.second())).isPresent()) {
                if (temp.isFalse()) {
                    return S.False;
                }
                if (temp != S.Continue) {
                    andAST.set(1, temp);
                    andEvaled = true;
                    lastArg = temp;
                }
            }
            if (temp != S.Continue) {
                variableInternalContinued = false;
            }
            for (int i = 2; i < andAST.size(); ++i) {
                IExpr arg = this.rewriteVariableValue(variableInterval, andAST.get(i));
                IExpr reducedArg = F.NIL;
                if (!arg.isAST2() || !arg.first().equals(variableInterval.variable)) continue;
                reducedArg = variableInterval.reduceAnd(arg.headID(), arg.second());
                if (reducedArg.isPresent()) {
                    if (reducedArg.isFalse()) {
                        return S.False;
                    }
                    if (reducedArg != S.Continue) {
                        andAST.set(i, reducedArg);
                        andEvaled = true;
                        arg = reducedArg;
                    }
                }
                if (reducedArg != S.Continue) {
                    variableInternalContinued = false;
                }
                IASTMutable orAST = F.NIL;
                boolean evaled = false;
                if (arg.isComparatorFunction() && lastArg.isAST(S.Or)) {
                    orAST = ((IAST)lastArg).copy();
                    evaled = this.mapOrReduced(arg, orAST);
                } else if (lastArg.isComparatorFunction() && arg.isAST(S.Or)) {
                    orAST = ((IAST)arg).copy();
                    evaled = this.mapOrReduced(lastArg, orAST);
                }
                if (!evaled) continue;
                temp = EvalEngine.get().evaluate(orAST);
                andAST.set(lastIndex, S.True);
                lastArg = temp;
                lastIndex = i;
                andAST.set(i, lastArg);
                andEvaled = true;
            }
            if (andEvaled) {
                return andAST;
            }
            if (variableInternalContinued) {
                return S.Continue;
            }
            return F.NIL;
        }

        private boolean mapOrReduced(IExpr arg, IASTMutable orAST) {
            boolean evaled = false;
            for (int j = 1; j < orAST.size(); ++j) {
                IExpr r = this.reduceAndBinary(arg, orAST.get(j));
                if (!r.isPresent()) continue;
                orAST.set(j, r);
                evaled = true;
            }
            return evaled;
        }

        private IExpr rewriteVariableValue(VariableInterval cd, IExpr lastArg) {
            if (lastArg.isEqual()) {
                IAST[] reduced = Eliminate.eliminateOneVariable(F.list(lastArg), cd.variable, false, EvalEngine.get());
                if (reduced != null && reduced[0].isEmptyList() && reduced[1].isRule()) {
                    IAST rule = reduced[1];
                    lastArg = F.Equal(this.variable, rule.second());
                }
            } else {
                lastArg = S.Simplify.of(lastArg, cd.variable);
            }
            return lastArg;
        }

        private IExpr reduceAndBinary(IExpr arg, IExpr orArg) {
            ReduceComparison rcAnd = new ReduceComparison(this.variable);
            IExpr reduced = rcAnd.evaluate(F.And(arg, orArg));
            if (reduced.isPresent()) {
                if (reduced == S.Continue || reduced.isAST(S.And)) {
                    return F.NIL;
                }
                return reduced;
            }
            return F.NIL;
        }

        static class VariableInterval {
            final IExpr variable;
            IExpr xMin;
            IExpr xMax;
            int minType;
            int maxType;

            public VariableInterval(IExpr variable) {
                this.variable = variable;
                this.xMin = F.CNInfinity;
                this.xMax = F.CInfinity;
                this.minType = 1;
                this.maxType = 1;
            }

            public void set(VariableInterval cd) {
                this.xMin = cd.xMin;
                this.xMax = cd.xMax;
                this.minType = cd.minType;
                this.maxType = cd.maxType;
            }

            public boolean reduceOr(VariableInterval cd) {
                if (S.Equal.ofQ(this.xMax, cd.xMin)) {
                    if (this.maxType >= 2 || cd.minType >= 2) {
                        this.xMax = cd.xMax;
                        this.maxType = cd.maxType;
                        return true;
                    }
                } else if (S.Equal.ofQ(cd.xMax, this.xMin)) {
                    if (this.maxType >= 2 || cd.minType >= 2) {
                        this.xMin = cd.xMin;
                        this.minType = cd.minType;
                        return true;
                    }
                } else if (S.GreaterEqual.ofQ(cd.xMin, this.xMin)) {
                    if (S.LessEqual.ofQ(cd.xMax, this.xMax)) {
                        return true;
                    }
                } else if (S.GreaterEqual.ofQ(this.xMin, cd.xMin) && S.LessEqual.ofQ(this.xMax, cd.xMax)) {
                    this.xMin = cd.xMin;
                    this.xMax = cd.xMax;
                    this.minType = cd.minType;
                    this.maxType = cd.maxType;
                    return true;
                }
                if (S.Greater.ofQ(this.xMax, cd.xMin)) {
                    if (S.Less.ofQ(this.xMax, cd.xMax)) {
                        this.xMax = cd.xMax;
                        this.maxType = cd.maxType;
                        return true;
                    }
                } else if (S.Greater.ofQ(this.xMin, cd.xMin) && S.Less.ofQ(this.xMin, cd.xMax)) {
                    this.xMin = cd.xMin;
                    this.minType = cd.minType;
                    return true;
                }
                return false;
            }

            boolean isInitial() {
                return this.xMin == F.CNInfinity && this.xMax == F.CInfinity;
            }

            private IExpr toExpr() {
                if (!this.xMin.equals(F.CNInfinity)) {
                    IAST gt;
                    if (this.xMax.equals(this.xMin)) {
                        if (this.minType >= 2 && this.maxType >= 2) {
                            return F.Equal(this.variable, this.xMin);
                        }
                        return F.False;
                    }
                    IAST iAST = gt = this.minType >= 2 ? F.GreaterEqual(this.variable, this.xMin) : F.Greater(this.variable, this.xMin);
                    if (!this.xMax.equals(F.CInfinity)) {
                        IAST lt = this.maxType >= 2 ? F.LessEqual(this.variable, this.xMax) : F.Less(this.variable, this.xMax);
                        return F.And((IExpr)gt, (IExpr)lt);
                    }
                    return gt;
                }
                if (!this.xMax.equals(F.CInfinity)) {
                    IAST lt = this.maxType >= 2 ? F.LessEqual(this.variable, this.xMax) : F.Less(this.variable, this.xMax);
                    return lt;
                }
                return F.NIL;
            }

            public String toString() {
                String minStr;
                String string = this.minType == 1 ? " < " : (minStr = this.minType == 2 ? " <= " : " == ");
                String maxStr = this.maxType == 1 ? " < " : (this.maxType == 2 ? " <= " : " == ");
                return "|" + this.xMin.toString() + minStr + this.variable + maxStr + this.xMax.toString() + "|";
            }

            public IExpr reduceAnd(int headID, IExpr rhs) throws ArgumentTypeException {
                try {
                    Complex c = rhs.evalComplex();
                    if (c != null && !F.isZero(c.getImaginary())) {
                        return S.False;
                    }
                }
                catch (ArgumentTypeException c) {
                    // empty catch block
                }
                switch (headID) {
                    case 423: {
                        if (S.GreaterEqual.ofQ(rhs, this.xMin) && S.LessEqual.ofQ(rhs, this.xMax)) {
                            if (this.maxType == 1 && S.Equal.ofQ(rhs, this.xMax)) {
                                return S.False;
                            }
                            if (this.minType == 1 && S.Equal.ofQ(rhs, this.xMin)) {
                                return S.False;
                            }
                            this.xMax = rhs;
                            this.xMin = rhs;
                            this.minType = 3;
                            this.maxType = 3;
                            return S.Continue;
                        }
                        IExpr gt = S.Greater.of(rhs, this.xMax);
                        if (gt.isTrue()) {
                            return S.False;
                        }
                        IExpr lt = S.Less.of(rhs, this.xMin);
                        if (lt.isTrue()) {
                            return S.False;
                        }
                        if (!gt.isFalse() || !lt.isFalse()) break;
                        this.xMax = rhs;
                        this.xMin = rhs;
                        this.minType = 3;
                        this.maxType = 3;
                        return S.Continue;
                    }
                    case 753: {
                        if (S.Less.ofQ(rhs, this.xMax)) {
                            if (this.minType == 1 && S.LessEqual.ofQ(rhs, this.xMin)) {
                                return S.False;
                            }
                            if (S.Less.ofQ(rhs, this.xMin)) {
                                return S.False;
                            }
                            this.xMax = rhs;
                            this.maxType = 1;
                        } else if (S.LessEqual.ofQ(rhs, this.xMin)) {
                            return S.False;
                        }
                        return S.Continue;
                    }
                    case 754: {
                        if (S.LessEqual.ofQ(rhs, this.xMax)) {
                            if (this.minType == 1 && S.LessEqual.ofQ(rhs, this.xMin)) {
                                return S.False;
                            }
                            if (S.Less.ofQ(rhs, this.xMin)) {
                                return S.False;
                            }
                            this.xMax = rhs;
                            this.maxType = 2;
                        } else if (S.Less.ofQ(rhs, this.xMin)) {
                            return S.False;
                        }
                        return S.Continue;
                    }
                    case 571: {
                        if (S.Greater.ofQ(rhs, this.xMin)) {
                            if (this.maxType == 1 && S.GreaterEqual.ofQ(rhs, this.xMax)) {
                                return S.False;
                            }
                            if (S.Greater.ofQ(rhs, this.xMax)) {
                                return S.False;
                            }
                            this.xMin = rhs;
                            this.minType = 1;
                        } else if (S.GreaterEqual.ofQ(rhs, this.xMax)) {
                            return S.False;
                        }
                        return S.Continue;
                    }
                    case 572: {
                        if (S.GreaterEqual.ofQ(rhs, this.xMin)) {
                            if (this.maxType == 1 && S.GreaterEqual.ofQ(rhs, this.xMax)) {
                                return S.False;
                            }
                            if (S.Greater.ofQ(rhs, this.xMax)) {
                                return S.False;
                            }
                            this.xMin = rhs;
                            this.minType = 2;
                        } else if (S.Greater.ofQ(rhs, this.xMax)) {
                            return S.False;
                        }
                        return S.Continue;
                    }
                    default: {
                        return F.NIL;
                    }
                }
                return F.NIL;
            }
        }
    }
}

