/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.ListFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.Iterator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IIterator;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.Matcher;
import org.matheclipse.core.reflection.system.rulesets.ProductRules;

public class Product
extends ListFunctions.Table
implements ProductRules {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Supplier<Matcher> MATCHER1;

    private static Matcher matcher1() {
        return MATCHER1.get();
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr arg1 = ast.arg1();
        if (arg1.isAST() && !(arg1 = F.expand(arg1, false, false, false)).isPresent()) {
            arg1 = ast.arg1();
        }
        if (arg1.isTimes()) {
            return ((IAST)arg1).mapThread(ast, 1);
        }
        IAST preevaledProduct = engine.preevalForwardBackwardAST(ast, 1);
        arg1 = preevaledProduct.arg1();
        return this.evaluateProduct(preevaledProduct, arg1, engine);
    }

    private IExpr evaluateProduct(IAST preevaledProduct, IExpr arg1, EvalEngine engine) {
        IExpr result;
        IAST list;
        if (preevaledProduct.size() > 2 && (list = preevaledProduct.last().isList() ? (IAST)preevaledProduct.last() : F.list(preevaledProduct.last())).isAST1()) {
            IExpr variable = list.arg1();
            if (preevaledProduct.arg1().isFree(variable) && variable.isVariable()) {
                return Product.indefiniteProduct(preevaledProduct, variable);
            }
        }
        IExpr temp = F.NIL;
        if (preevaledProduct.size() == 3 && (result = Product.matcher1().apply(preevaledProduct)).isPresent()) {
            return result;
        }
        try {
            temp = Product.evaluateTableThrow(preevaledProduct, F.Times(), F.Times(), engine);
            if (temp.isPresent()) {
                return temp;
            }
        }
        catch (ValidateException ve) {
            return IOFunctions.printMessage((ISymbol)S.Product, ve, engine);
        }
        if (arg1.isPower()) {
            IExpr exponent = arg1.exponent();
            boolean flag = true;
            for (int i = 2; i < preevaledProduct.size(); ++i) {
                IIterator<IExpr> iterator = preevaledProduct.get(i).isList() ? Iterator.create((IAST)preevaledProduct.get(i), i, engine) : Iterator.create(F.list(preevaledProduct.get(i)), i, engine);
                if (iterator.isValidVariable() && exponent.isFree(iterator.getVariable())) continue;
                flag = false;
                break;
            }
            if (flag) {
                IASTMutable prod = preevaledProduct.copy();
                prod.set(1, arg1.base());
                return F.Power((IExpr)prod, exponent);
            }
        }
        IExpr argN = preevaledProduct.last();
        if (preevaledProduct.size() >= 3 && argN.isList()) {
            try {
                if (arg1.isZero()) {
                    return F.C0;
                }
                IIterator<IExpr> iterator = Iterator.create((IAST)argN, preevaledProduct.argSize(), engine);
                if (iterator.isValidVariable() && iterator.getUpperLimit().isInfinity()) {
                    if (arg1.isOne()) {
                        return F.C1;
                    }
                    if (arg1.isPositiveResult() && arg1.isIntegerResult()) {
                        return F.CInfinity;
                    }
                }
                if (iterator.isValidVariable() && !iterator.isNumericFunction() && iterator.getUpperLimit().isSymbol() && iterator.getStep().isOne()) {
                    IExpr exponent;
                    IExpr base;
                    ISymbol var = iterator.getVariable();
                    IExpr from = iterator.getLowerLimit();
                    ISymbol to = (ISymbol)iterator.getUpperLimit();
                    if (arg1.isPower() && (base = arg1.base()).isFree(var) && iterator.getLowerLimit().isOne() && (exponent = arg1.exponent()).equals(var)) {
                        if (preevaledProduct.isAST2()) {
                            return F.Power(base, F.Times((IExpr)F.C1D2, (IExpr)to, (IExpr)F.Plus((IExpr)F.C1, (IExpr)to)));
                        }
                        IASTAppendable result2 = preevaledProduct.removeAtClone(preevaledProduct.argSize());
                        result2.set(1, F.Power(base, F.Times((IExpr)F.C1D2, (IExpr)to, (IExpr)F.Plus((IExpr)F.C1, (IExpr)to))));
                        return result2;
                    }
                    if (arg1.isFree(var)) {
                        if (preevaledProduct.isAST2()) {
                            if (from.isOne()) {
                                return F.Power(preevaledProduct.arg1(), to);
                            }
                            if (from.isZero()) {
                                return F.Power(preevaledProduct.arg1(), F.Plus((IExpr)to, (IExpr)F.C1));
                            }
                            if (from.isSymbol()) {
                                return F.Power(arg1, F.Plus((IExpr)F.C1, from.negate(), (IExpr)to));
                            }
                        } else {
                            IASTAppendable result3 = preevaledProduct.removeAtClone(preevaledProduct.argSize());
                            if (from.isOne()) {
                                result3.set(1, F.Power(preevaledProduct.arg1(), to));
                                return result3;
                            }
                            if (from.isZero()) {
                                result3.set(1, F.Power(preevaledProduct.arg1(), F.Plus((IExpr)to, (IExpr)F.C1)));
                                return result3;
                            }
                            if (from.isSymbol()) {
                                result3.set(1, F.Power(arg1, F.Plus((IExpr)F.C1, from.negate(), (IExpr)to)));
                                return result3;
                            }
                        }
                    }
                }
                temp = F.NIL;
                IASTAppendable resultList = F.Times();
                temp = Product.evaluateLast(preevaledProduct.arg1(), iterator, resultList, F.C1);
                if (!temp.isPresent() || temp.equals(resultList)) {
                    return F.NIL;
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage((ISymbol)S.Product, ve, engine);
            }
            catch (RecursionLimitExceeded rle) {
                int recursionLimit = engine.getRecursionLimit();
                IOFunctions.printMessage(S.Product, "reclim2", F.list(recursionLimit < 0 ? F.CInfinity : F.ZZ(recursionLimit), preevaledProduct), engine);
                return F.NIL;
            }
            if (preevaledProduct.isAST2()) {
                return temp;
            }
            IASTAppendable result4 = preevaledProduct.removeAtClone(preevaledProduct.argSize());
            result4.set(1, temp);
            return result4;
        }
        return F.NIL;
    }

    private static IExpr indefiniteProduct(IAST ast, IExpr variable) {
        IAST result = F.Power(ast.arg1(), F.Plus((IExpr)F.CN1, variable));
        int argSize = ast.argSize();
        if (argSize == 2) {
            return result;
        }
        IASTAppendable newSum = ast.removeAtClone(argSize);
        newSum.set(1, result);
        return newSum;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_INFINITY;
    }

    @Override
    public IExpr numericEval(IAST functionList, EvalEngine engine) {
        return this.evaluate(functionList, engine);
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(96);
        MATCHER1 = Suppliers.memoize(ProductRules::init1);
    }
}

