/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.BinaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class Plot3D
extends AbstractEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Plot3D CONST = new Plot3D();
    private static final int NUMBER_OF_DIVISIONS = 21;

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (Config.USE_MANIPULATE_JS) {
            IExpr temp = S.Manipulate.of(engine, ast);
            if (temp.headID() == 696) {
                return temp;
            }
            return F.NIL;
        }
        if (ast.size() >= 4 && ast.arg2().isList() && ast.arg3().isList()) {
            try {
                IASTAppendable graphics = F.SurfaceGraphics();
                IAST lst1 = (IAST)ast.arg2();
                IAST lst2 = (IAST)ast.arg3();
                if (lst1.isAST3() && lst2.isAST3()) {
                    IExpr xMin = engine.evalN(lst1.arg2());
                    IExpr xMax = engine.evalN(lst1.arg3());
                    IExpr yMin = engine.evalN(lst2.arg2());
                    IExpr yMax = engine.evalN(lst2.arg3());
                    if (!(xMin instanceof INum && xMax instanceof INum && yMin instanceof INum && yMax instanceof INum)) {
                        return F.NIL;
                    }
                    double xMinD = ((INum)xMin).getRealPart();
                    double xMaxD = ((INum)xMax).getRealPart();
                    double yMinD = ((INum)yMin).getRealPart();
                    double yMaxD = ((INum)yMax).getRealPart();
                    if (xMaxD <= xMinD) {
                        return F.NIL;
                    }
                    if (yMaxD <= yMinD) {
                        return F.NIL;
                    }
                    IExpr temp = Plot3D.plotArray(xMinD, xMaxD, yMinD, yMaxD, ast.arg1(), (ISymbol)lst1.arg1(), (ISymbol)lst2.arg1(), engine);
                    graphics.append(temp);
                    IASTAppendable options = F.ListAlloc();
                    options.append(F.Rule((IExpr)S.PlotRange, (IExpr)S.Automatic));
                    options.append(F.Rule((IExpr)S.MeshRange, (IExpr)F.list(F.list(xMin, xMax), F.List(yMin, yMax))));
                    graphics.appendAll(options, 1, options.size());
                    return F.Show(graphics);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("Plot3D.evaluate() failed", (Throwable)rex);
            }
        }
        return F.NIL;
    }

    public static IExpr plotArray(double xMin, double xMax, double yMin, double yMax, IExpr function, ISymbol xVar, ISymbol yVar, EvalEngine engine) {
        double xStep = (xMax - xMin) / 21.0;
        double yStep = (yMax - yMin) / 21.0;
        BinaryNumerical hbn = new BinaryNumerical(function, xVar, yVar, engine);
        double[][] data = new double[22][22];
        double x = xMin;
        for (int i = 0; i < 21; ++i) {
            double y = yMin;
            for (int j = 0; j < 21; ++j) {
                double z;
                data[i][j] = z = hbn.value(x, y);
                y += yStep;
            }
            x += xStep;
        }
        return Object2Expr.convert(data, true, false);
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(96);
    }
}

