/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.moment.StandardDeviation;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.graphics.Dimensions2D;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class Plot
extends AbstractEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Plot CONST = new Plot();
    private static final int N = 100;

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (Config.USE_MANIPULATE_JS) {
            IExpr temp = S.Manipulate.of(engine, ast);
            if (temp.headID() == 696) {
                return temp;
            }
            return F.NIL;
        }
        if (ast.size() >= 3 && ast.size() <= 4 && ast.arg2().isList()) {
            try {
                IAST rangeList = (IAST)ast.arg2();
                if (rangeList.isAST3()) {
                    IExpr temp;
                    IAST lsty;
                    if (!rangeList.arg1().isSymbol()) {
                        return IOFunctions.printMessage(S.Plot, "ivar", F.list(rangeList.arg1()), engine);
                    }
                    ISymbol x = (ISymbol)rangeList.arg1();
                    IExpr xMin = engine.evalN(rangeList.arg2());
                    IExpr xMax = engine.evalN(rangeList.arg3());
                    if (!(xMin instanceof INum) || !(xMax instanceof INum)) {
                        return F.NIL;
                    }
                    double xMinD = ((INum)xMin).getRealPart();
                    double xMaxd = ((INum)xMax).getRealPart();
                    if (xMaxd <= xMinD) {
                        return F.NIL;
                    }
                    double yMinD = 0.0;
                    double yMaxD = 0.0;
                    if (ast.isAST3() && ast.arg3().isList() && (lsty = (IAST)ast.arg3()).isAST2()) {
                        IExpr y0 = engine.evalN(lsty.arg1());
                        IExpr y1 = engine.evalN(lsty.arg2());
                        if (y0 instanceof INum && y1 instanceof INum) {
                            yMinD = ((INum)y0).getRealPart();
                            yMaxD = ((INum)y1).getRealPart();
                        }
                    }
                    IASTAppendable graphics = F.Graphics();
                    IASTAppendable line = F.Line();
                    Dimensions2D dim = new Dimensions2D();
                    if (ast.arg1().isList()) {
                        IAST list = (IAST)ast.arg1();
                        int size = list.size();
                        IASTAppendable primitives = F.ListAlloc(size);
                        for (int i = 1; i < size; ++i) {
                            temp = this.plotLine(xMinD, xMaxd, yMinD, yMaxD, list.get(i), x, dim, engine);
                            if (temp.isPresent()) {
                                line.append(temp);
                                primitives.append(line);
                            }
                            if (i >= size - 1) continue;
                            line = F.Line();
                        }
                        graphics.append(primitives);
                    } else {
                        temp = this.plotLine(xMinD, xMaxd, yMinD, yMaxD, ast.arg1(), x, dim, engine);
                        if (temp.isPresent()) {
                            line.append(temp);
                            graphics.append(line);
                        }
                    }
                    IAST plotRange = dim.isValidRange() ? F.Rule((IExpr)S.PlotRange, (IExpr)F.list(F.List(dim.xMin, dim.xMax), F.List(dim.yMin, dim.yMax))) : F.Rule((IExpr)S.PlotRange, (IExpr)S.Automatic);
                    IExpr[] options = new IExpr[]{plotRange, F.Rule((IExpr)S.AxesStyle, (IExpr)S.Automatic), F.Rule((IExpr)S.AxesOrigin, (IExpr)F.list(F.C0, F.C0)), F.Rule((IExpr)S.Axes, (IExpr)S.True), F.Rule((IExpr)S.Background, (IExpr)S.White)};
                    graphics.appendAll(F.function(S.List, options), 1, options.length);
                    return F.Show(graphics);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("Plot.evaluate() failed", (Throwable)rex);
            }
        }
        return F.NIL;
    }

    private double[] automaticPlotRange(double[] values) {
        double thresh = 2.0;
        double[] yValues = new double[values.length];
        System.arraycopy(values, 0, yValues, 0, values.length);
        Arrays.sort(yValues);
        double valavg = new Mean().evaluate(yValues);
        double valdev = new StandardDeviation().evaluate(yValues, valavg);
        int n1 = 0;
        int n2 = values.length - 1;
        if (valdev != 0.0) {
            double v;
            for (double v2 : yValues) {
                if (Math.abs(v2 - valavg) / valdev < thresh) break;
                ++n1;
            }
            for (int i = yValues.length - 1; i >= 0 && !(Math.abs((v = yValues[i]) - valavg) / valdev < thresh); --i) {
                --n2;
            }
        }
        double vrange = yValues[n2] - yValues[n1];
        double vmin = yValues[n1] - 0.05 * vrange;
        double vmax = yValues[n2] + 0.05 * vrange;
        return new double[]{vmin, vmax};
    }

    public IExpr plotLine(double xMin, double xMax, double yMin, double yMax, IExpr function, ISymbol xVar, Dimensions2D autoPlotRange, EvalEngine engine) {
        double step = (xMax - xMin) / 100.0;
        UnaryNumerical hun = new UnaryNumerical(function, xVar, engine);
        double[][] data = new double[2][101];
        double x = xMin;
        for (int i = 0; i < 101; ++i) {
            double y = hun.value(x);
            if (yMin != 0.0 || yMax != 0.0) {
                if (y >= yMin && y <= yMax) {
                    data[0][i] = x;
                    data[1][i] = y;
                } else if (y < yMin) {
                    data[0][i] = x;
                    data[1][i] = yMin;
                } else {
                    data[0][i] = x;
                    data[1][i] = yMax;
                }
            } else {
                data[0][i] = x;
                data[1][i] = y;
            }
            x += step;
        }
        double[] vMinMax = this.automaticPlotRange(data[1]);
        autoPlotRange.minMax(xMin, x, vMinMax[0], vMinMax[1]);
        return Convert.toExprTransposed(data);
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(96);
    }
}

