/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;

public class Outer
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr head = null;
        for (int i = 2; i < ast.size(); ++i) {
            IExpr list = ast.get(i);
            if (!list.isAST()) {
                return F.NIL;
            }
            if (head == null) {
                head = list.head();
                continue;
            }
            if (head.equals(list.head())) continue;
            return F.NIL;
        }
        OuterAlgorithm algorithm = new OuterAlgorithm(ast, head);
        return algorithm.outer(3, ast.arg2(), F.ast((IExpr)S.List, ast.argSize()));
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_3_INFINITY;
    }

    private static class OuterAlgorithm {
        final IAST ast;
        final IExpr f;
        final IExpr head;

        public OuterAlgorithm(IAST ast, IExpr head) {
            this.ast = ast;
            this.f = ast.arg1();
            this.head = head;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IAST outer(int astPosition, IExpr expr, IASTAppendable current) {
            if (expr.isAST() && this.head.equals(expr.head())) {
                IAST list = (IAST)expr;
                int size = list.size();
                IASTAppendable result = F.ast(this.head, size);
                return result.appendArgs(size, i -> this.outer(astPosition, list.get(i), current));
            }
            if (this.ast.size() > astPosition) {
                try {
                    current.append(expr);
                    IAST list = this.outer(astPosition + 1, this.ast.get(astPosition), current);
                    return list;
                }
                finally {
                    current.remove(current.argSize());
                }
            }
            IASTAppendable result = F.ast(this.f);
            result.appendArgs(current);
            result.append(expr);
            return result;
        }
    }
}

