/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorExpr;

public class OptimizeExpression
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (ast.arg1() instanceof IASTMutable) {
            return OptimizeExpression.optimizeExpression((IASTMutable)ast.arg1());
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_1_1;
    }

    private static IExpr optimizeExpression(IASTMutable ast) {
        ShareFunction function = new ShareFunction();
        ShareReplaceAll sra = new ShareReplaceAll(function);
        IExpr sharedExpr = ast.accept(sra);
        if (sharedExpr.isPresent()) {
            ArrayList<ReferenceCounter> list = new ArrayList<ReferenceCounter>();
            for (Map.Entry<IASTMutable, ReferenceCounter> entry : function.map.entrySet()) {
                ReferenceCounter rc = entry.getValue();
                if (rc.counter <= 1) continue;
                list.add(rc);
            }
            int varCounter = 1;
            Collections.sort(list, Collections.reverseOrder());
            IASTAppendable variableSubstitutions = F.ListAlloc(list.size());
            IASTAppendable replaceList = F.ListAlloc(list.size());
            for (ReferenceCounter referenceCounter : list) {
                IASTMutable reference = referenceCounter.reference;
                IExpr temp = reference.replaceAll(variableSubstitutions).orElse(reference);
                ISymbol dummyVariable = F.Dummy("v" + varCounter);
                replaceList.append(F.Rule((IExpr)dummyVariable, temp));
                variableSubstitutions.append(F.Rule((IExpr)reference, (IExpr)dummyVariable));
                ++varCounter;
            }
            if ((sharedExpr = sharedExpr.replaceRepeated(variableSubstitutions)).isPresent()) {
                return F.list(sharedExpr, replaceList);
            }
        }
        return F.list(ast);
    }

    public static IAST cseArray(IAST ast, int minReferences, int minLeafCounter) {
        ShareFunction function = new ShareFunction();
        ShareReplaceAll sra = new ShareReplaceAll(function);
        IExpr sharedExpr = ast.accept(sra);
        if (sharedExpr.isPresent()) {
            ArrayList<ReferenceCounter> list = new ArrayList<ReferenceCounter>();
            for (Map.Entry<IASTMutable, ReferenceCounter> entry : function.map.entrySet()) {
                ReferenceCounter rc = entry.getValue();
                if (rc.counter < minReferences || rc.reference.leafCount() <= (long)minLeafCounter) continue;
                list.add(rc);
            }
            Collections.sort(list, Collections.reverseOrder());
            IASTAppendable result = F.ListAlloc(list.size());
            for (ReferenceCounter rc : list) {
                IASTMutable ref = rc.reference;
                result.append(ref);
            }
            return result;
        }
        return F.NIL;
    }

    private static class ShareReplaceAll
    extends VisitorExpr {
        final Function<IASTMutable, IASTMutable> fFunction;

        public ShareReplaceAll(Function<IASTMutable, IASTMutable> function) {
            this.fFunction = function;
        }

        @Override
        public IExpr visit(IASTMutable ast) {
            if (ast.size() <= 1) {
                return F.NIL;
            }
            IExpr temp = this.fFunction.apply(ast);
            if (temp.isPresent()) {
                return temp;
            }
            return this.visitAST(ast);
        }

        @Override
        protected IExpr visitAST(IAST ast) {
            boolean evaled = false;
            for (int i = 1; i < ast.size(); ++i) {
                IExpr temp;
                IExpr arg = ast.getRule(i);
                if (!(arg instanceof IASTMutable) || !(temp = this.visit((IASTMutable)arg)).isPresent()) continue;
                ((IASTMutable)ast).set(i, temp);
                evaled = true;
            }
            return evaled ? ast : F.NIL;
        }
    }

    private static class ShareFunction
    implements Function<IASTMutable, IASTMutable> {
        Map<IASTMutable, ReferenceCounter> map = new TreeMap<IASTMutable, ReferenceCounter>();

        @Override
        public IASTMutable apply(IASTMutable t) {
            ReferenceCounter value = this.map.get(t);
            if (value == null) {
                value = new ReferenceCounter(t);
                this.map.put(t, value);
                return F.NIL;
            }
            value.incCounter();
            if (value.reference == t) {
                return F.NIL;
            }
            return value.reference;
        }
    }

    private static class ReferenceCounter
    implements Comparable<ReferenceCounter> {
        IASTMutable reference;
        int counter;

        public ReferenceCounter(IASTMutable reference) {
            this.reference = reference;
            this.counter = 1;
        }

        public void incCounter() {
            ++this.counter;
        }

        @Override
        public int compareTo(ReferenceCounter o) {
            return this.counter > o.counter ? 1 : (this.counter == o.counter ? 0 : -1);
        }
    }
}

