/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.integration.RombergIntegrator;
import org.hipparchus.analysis.integration.SimpsonIntegrator;
import org.hipparchus.analysis.integration.TrapezoidIntegrator;
import org.hipparchus.analysis.integration.gauss.GaussIntegrator;
import org.hipparchus.analysis.integration.gauss.GaussIntegratorFactory;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.Precision;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class NIntegrate
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int DEFAULT_MAX_POINTS = 100;
    public static final int DEFAULT_MAX_ITERATIONS = 10000;

    public static double integrate(String method, IAST list, double min, double max, IExpr function, int maxPoints, int maxIterations) throws MathIllegalStateException {
        SimpsonIntegrator integrator;
        GaussIntegratorFactory factory = new GaussIntegratorFactory();
        if (!list.arg1().isSymbol()) {
            String str = IOFunctions.getMessage("ivar", F.list(list.arg1()), EvalEngine.get());
            throw new ArgumentTypeException(str);
        }
        ISymbol xVar = (ISymbol)list.arg1();
        EvalEngine engine = EvalEngine.get();
        IExpr tempFunction = F.eval(function);
        UnaryNumerical f = new UnaryNumerical(tempFunction, xVar, engine);
        if ("Simpson".equalsIgnoreCase(method)) {
            integrator = new SimpsonIntegrator();
        } else if ("Romberg".equalsIgnoreCase(method)) {
            integrator = new RombergIntegrator();
        } else if ("Trapezoid".equalsIgnoreCase(method)) {
            integrator = new TrapezoidIntegrator();
        } else {
            if (maxPoints > 1000) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{maxPoints, 1000});
            }
            GaussIntegrator integ = factory.legendre(maxPoints, min, max);
            return integ.integrate((UnivariateFunction)f);
        }
        return integrator.integrate(maxIterations, (UnivariateFunction)f, min, max);
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        String method = "LegendreGauss";
        int maxPoints = 100;
        int maxIterations = 10000;
        int precisionGoal = 16;
        if (ast.size() >= 4) {
            OptionArgs options = new OptionArgs(ast.topHead(), ast, 3, engine);
            IExpr option = options.getOption(S.Method);
            if (option.isSymbol()) {
                method = option.toString();
            }
            if ((option = options.getOption(S.MaxPoints)).isReal() && (maxPoints = ((ISignedNumber)option).toIntDefault(-1)) <= 0) {
                LOGGER.log(engine.getLogLevel(), "NIntegrate: Error in option MaxPoints. Using default value: {}", (Object)maxPoints);
                maxPoints = 100;
            }
            if ((maxIterations = options.getOptionMaxIterations(S.MaxIterations)) == Integer.MIN_VALUE) {
                return F.NIL;
            }
            if (maxIterations < 0) {
                maxIterations = 10000;
            }
            if ((option = options.getOption(S.PrecisionGoal)).isReal() && (precisionGoal = ((ISignedNumber)option).toIntDefault(-1)) <= 0) {
                LOGGER.log(engine.getLogLevel(), "NIntegrate: Error in option PrecisionGoal. Using default value: {}", (Object)precisionGoal);
                precisionGoal = 16;
            }
        }
        if (ast.arg2().isList()) {
            IAST list = (IAST)ast.arg2();
            IExpr function = ast.arg1();
            if (list.isAST3() && list.arg1().isSymbol()) {
                ISignedNumber min = list.arg2().evalReal();
                ISignedNumber max = list.arg3().evalReal();
                if (min != null && max != null) {
                    if (function.isEqual()) {
                        IAST equalAST = (IAST)function;
                        function = F.Plus(equalAST.arg1(), F.Negate(equalAST.arg2()));
                    }
                    try {
                        double result = NIntegrate.integrate(method, list, min.doubleValue(), max.doubleValue(), function, maxPoints, maxIterations);
                        result = Precision.round((double)result, (int)precisionGoal);
                        return Num.valueOf(result);
                    }
                    catch (MathIllegalArgumentException | MathIllegalStateException miae) {
                        return IOFunctions.printMessage(ast.topHead(), "error", F.list(F.$str(miae.getMessage())), engine);
                    }
                    catch (MathRuntimeException mre) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mre);
                    }
                    catch (Exception e) {
                        LOGGER.log(engine.getLogLevel(), "NIntegrate: (method={}) ", (Object)method, (Object)e);
                    }
                }
            }
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_2_INFINITY;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
        newSymbol.setAttributes(32);
    }
}

