/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.matheclipse.core.basic.ToggleFeature;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.DSolve;

public class NDSolve
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        if (!ToggleFeature.DSOLVE) {
            return F.NIL;
        }
        if (ast.arg3().isList()) {
            IAST tRangeList = (IAST)ast.arg3();
            if (!tRangeList.isAST2() && !tRangeList.isAST3()) {
                return F.NIL;
            }
            try {
                IAST listOfVariables = Validate.checkIsVariableOrVariableList(ast, 2, ast.topHead(), engine);
                if (!listOfVariables.isPresent()) {
                    return F.NIL;
                }
                int numberOfVariables = listOfVariables.argSize();
                ISymbol timeVar = (ISymbol)tRangeList.arg1();
                IExpr tMinExpr = F.C0;
                IExpr tMaxExpr = tRangeList.arg2();
                if (tRangeList.isAST3()) {
                    tMinExpr = tRangeList.arg2();
                    tMaxExpr = tRangeList.arg3();
                }
                double tMin = tMinExpr.evalDouble();
                double tMax = tMaxExpr.evalDouble();
                double tStep = 0.1;
                IASTAppendable listOfEquations = Validate.checkEquations(ast, 1).copyAppendable();
                IExpr[][] boundaryCondition = new IExpr[2][numberOfVariables];
                int i = 1;
                while (i < listOfEquations.size()) {
                    IExpr equation = listOfEquations.get(i);
                    if (equation.isFree(timeVar) && NDSolve.determineSingleBoundary(equation, listOfVariables, timeVar, boundaryCondition, engine)) {
                        listOfEquations.remove(i);
                        continue;
                    }
                    ++i;
                }
                IExpr[] dotEquations = new IExpr[numberOfVariables];
                i = 1;
                while (i < listOfEquations.size()) {
                    IExpr equation = listOfEquations.get(i);
                    if (!equation.isFree(timeVar) && NDSolve.determineSingleDotEquation(equation, listOfVariables, timeVar, dotEquations, engine)) {
                        listOfEquations.remove(i);
                        continue;
                    }
                    ++i;
                }
                if (listOfVariables.isList()) {
                    DormandPrince853Integrator abstractIntegrator = new DormandPrince853Integrator(1.0E-8, 100.0, 1.0E-10, 1.0E-10);
                    double[] primaryState = new double[numberOfVariables];
                    for (int j = 0; j < numberOfVariables; ++j) {
                        primaryState[j] = ((INum)engine.evalN(boundaryCondition[1][j])).doubleValue();
                    }
                    FirstODE ode = new FirstODE(engine, dotEquations, listOfVariables, timeVar);
                    if (listOfVariables.size() > 1) {
                        IASTAppendable[] resultLists = new IASTAppendable[numberOfVariables];
                        for (int j = 0; j < primaryState.length; ++j) {
                            resultLists[j] = F.ListAlloc();
                        }
                        for (double time = tMin; time < tMax; time += 0.1) {
                            ODEStateAndDerivative finalstate = abstractIntegrator.integrate((OrdinaryDifferentialEquation)ode, new ODEState(time, primaryState), time + 0.1);
                            primaryState = finalstate.getPrimaryState();
                            for (int j = 0; j < primaryState.length; ++j) {
                                resultLists[j].append(F.list(F.num(time), F.num(primaryState[j])));
                            }
                        }
                        IASTAppendable primaryList = F.ListAlloc();
                        IASTAppendable secondaryList = F.ListAlloc();
                        for (int j = 1; j < listOfVariables.size(); ++j) {
                            secondaryList.append(F.Rule(listOfVariables.get(j), engine.evaluate(F.Interpolation(resultLists[j - 1]))));
                        }
                        primaryList.append(secondaryList);
                        return primaryList;
                    }
                }
            }
            catch (LimitException le) {
                throw le;
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_3_3;
    }

    private static boolean determineSingleBoundary(IExpr equation, IAST uFunctionSymbols, IExpr xVar, IExpr[][] boundaryCondition, EvalEngine engine) {
        if (equation.isAST()) {
            IASTAppendable eq = ((IAST)equation).copyAppendable();
            if (!eq.isPlus()) {
                eq = F.Plus((IExpr)eq);
            }
            IExpr uArg1 = null;
            IASTAppendable rest = F.PlusAlloc(16);
            for (int j = 1; j < eq.size(); ++j) {
                IExpr temp = eq.get(j);
                for (int i = 1; i < uFunctionSymbols.size(); ++i) {
                    boolean negate = true;
                    if (temp.isAST2() && temp.first().isMinusOne()) {
                        temp = temp.second();
                        negate = false;
                    }
                    if (!temp.isAST(uFunctionSymbols.get(i))) continue;
                    uArg1 = temp.first();
                    if (boundaryCondition[0][i - 1] != null) {
                        return false;
                    }
                    boundaryCondition[0][i - 1] = uArg1;
                    return NDSolve.removeDeriveFromPlus(boundaryCondition[1], i - 1, eq, j, rest, negate, engine);
                }
                rest.append(eq.get(j));
            }
        }
        return false;
    }

    private static boolean determineSingleDotEquation(IExpr equation, IAST uFunctionSymbols, IExpr xVar, IExpr[] dotEquations, EvalEngine engine) {
        if (equation.isAST()) {
            IASTAppendable eq = ((IAST)equation).copyAppendable();
            if (!eq.isPlus()) {
                eq = F.Plus((IExpr)eq);
            }
            IASTAppendable rest = F.PlusAlloc(16);
            for (int j = 1; j < eq.size(); ++j) {
                IAST[] deriveExpr;
                boolean negate = true;
                IExpr temp = eq.get(j);
                if (temp.isAST2() && temp.first().isMinusOne()) {
                    temp = temp.second();
                    negate = false;
                }
                if ((deriveExpr = temp.isDerivativeAST1()) != null) {
                    for (int i = 1; i < uFunctionSymbols.size(); ++i) {
                        if (!deriveExpr[1].arg1().equals(uFunctionSymbols.get(i))) continue;
                        if (DSolve.derivativeOrder(deriveExpr) != 1) {
                            return false;
                        }
                        if (dotEquations[i - 1] != null) {
                            return false;
                        }
                        return NDSolve.removeDeriveFromPlus(dotEquations, i - 1, eq, j, rest, negate, engine);
                    }
                    continue;
                }
                rest.append(eq.get(j));
            }
        }
        return false;
    }

    private static boolean removeDeriveFromPlus(IExpr[] dotEquations, int i, IASTAppendable plusAST, int j, IASTAppendable expr, boolean negate, EvalEngine engine) {
        IExpr temp = negate ? expr.oneIdentity0().negate() : expr.oneIdentity0();
        dotEquations[i] = engine.evaluate(temp);
        plusAST.remove(j);
        return true;
    }

    private static class FirstODE
    implements OrdinaryDifferentialEquation {
        private final EvalEngine fEngine;
        private final IExpr[] fDotEquations;
        private final int fDimension;
        private final IAST fVariables;
        private final ISymbol fT;

        public FirstODE(EvalEngine engine, IExpr[] dotEquations, IAST variables, ISymbol t) {
            this.fEngine = engine;
            this.fDotEquations = dotEquations;
            this.fDimension = this.fDotEquations.length;
            this.fVariables = variables;
            this.fT = t;
        }

        public int getDimension() {
            return this.fDimension;
        }

        public double[] computeDerivatives(double t, double[] xyz) {
            int i;
            double[] xyzDot = new double[this.fDimension];
            IExpr[] replacements = new IExpr[this.fDimension];
            IASTAppendable rules = F.ListAlloc(this.fDimension + 1);
            for (int i2 = 0; i2 < this.fDimension; ++i2) {
                replacements[i2] = F.$(this.fVariables.get(i2 + 1), this.fT);
                rules.append(F.Rule(replacements[i2], (IExpr)F.num(xyz[i2])));
            }
            rules.append(F.Rule((IExpr)this.fT, (IExpr)F.num(t)));
            IExpr[] dotEquations = new IExpr[this.fDimension];
            for (i = 0; i < this.fDimension; ++i) {
                dotEquations[i] = this.fDotEquations[i].replaceAll(rules);
            }
            for (i = 0; i < this.fDimension; ++i) {
                xyzDot[i] = ((INum)this.fEngine.evalN(dotEquations[i])).doubleValue();
            }
            return xyzDot;
        }
    }
}

