/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FiniteDifferencesDifferentiator;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.complex.Complex;
import org.hipparchus.exception.MathRuntimeException;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ND
extends AbstractFunctionEvaluator {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IExpr arg1 = ast.arg1();
        IExpr arg2 = ast.arg2();
        IExpr arg3 = ast.arg3();
        try {
            int dim = arg2.isVector();
            if (dim == 2) {
                int order = arg2.second().toIntDefault();
                if (order > 0 && arg2.first().isSymbol()) {
                    return this.partialDerivative(arg1, (ISymbol)arg2.first(), order, arg3, engine);
                }
            } else if (arg2.isSymbol()) {
                return this.partialDerivative(arg1, (ISymbol)arg2, 1, arg3, engine);
            }
        }
        catch (MathRuntimeException e) {
            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
        }
        return F.NIL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IExpr partialDerivative(IExpr function, ISymbol variable, int order, IExpr value, EvalEngine engine) {
        double a3Double = Double.NaN;
        try {
            a3Double = value.evalDouble();
        }
        catch (ValidateException validateException) {
            // empty catch block
        }
        if (Double.isNaN(a3Double)) {
            Complex a3Complex = Complex.NaN;
            a3Complex = value.evalComplex();
            if (a3Complex == null) return F.NIL;
            return F.NIL;
        }
        DSFactory factory = new DSFactory(1, order);
        FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(15, 0.01);
        UnivariateDifferentiableFunction f = differentiator.differentiate((UnivariateFunction)new UnaryNumerical(function, variable, EvalEngine.get()));
        return F.num(((DerivativeStructure)f.value((Derivative)factory.variable(0, a3Double))).getPartialDerivative(new int[]{order}));
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return IFunctionEvaluator.ARGS_3_3;
    }
}

