/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.BinaryBindIth1st;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.reflection.system.rules.MatrixDRules;

public class MatrixD
extends AbstractFunctionEvaluator
implements MatrixDRules {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IOFunctions.printExperimental(S.MatrixD);
        if (ast.size() < 3) {
            return F.NIL;
        }
        IExpr fx = ast.arg1();
        if (fx.isIndeterminate()) {
            return S.Indeterminate;
        }
        if (ast.size() > 3) {
            return ast.foldLeft((x, y) -> engine.evaluateNIL(F.MatrixD(x, y)), fx, 2);
        }
        IExpr x2 = ast.arg2();
        if (!x2.isVariable() && !x2.isList()) {
            return IOFunctions.printMessage(ast.topHead(), "ivar", F.list(x2), engine);
        }
        if (fx.isList()) {
            IAST list = (IAST)fx;
            return list.mapThreadEvaled(engine, F.ListAlloc(list.size()), ast, 1);
        }
        if (x2.isList()) {
            IAST xList = (IAST)x2;
            if (xList.isAST1() && xList.arg1().isListOfLists()) {
                IAST subList = (IAST)xList.arg1();
                IASTAppendable result = F.ListAlloc(subList.size());
                result.appendArgs(subList.size(), i -> F.MatrixD(fx, F.list(subList.get(i))));
                return result;
            }
            if (xList.isAST1() && xList.arg1().isList()) {
                IAST subList = (IAST)xList.arg1();
                return subList.mapLeft(F.ListAlloc(), (a, b) -> engine.evaluateNIL(F.MatrixD(a, b)), fx);
            }
            if (xList.isAST2()) {
                x2 = xList.arg1().isList() ? F.list(xList.arg1()) : xList.arg1();
                IExpr arg2 = xList.arg2();
                int n = arg2.toIntDefault();
                if (n >= 0) {
                    IExpr temp = fx;
                    for (int i2 = 0; i2 < n; ++i2) {
                        if ((temp = S.MatrixD.ofNIL(engine, temp, x2)).isPresent()) continue;
                        return F.NIL;
                    }
                    return temp;
                }
                if (arg2.isFree(num -> num.isNumber(), false)) {
                    IAST function;
                    if (fx.equals(x2)) {
                        return S.$SingleEntryMatrix;
                    }
                    if (fx.isAST() && (function = (IAST)fx).isPlus()) {
                        return function.mapThread(F.MatrixD(F.Slot1, xList), 1);
                    }
                    return F.NIL;
                }
                if (!x2.isVariable()) {
                    return IOFunctions.printMessage(ast.topHead(), "ivar", F.list(x2), engine);
                }
                if (arg2.isAST()) {
                    return F.NIL;
                }
                return IOFunctions.printMessage(ast.topHead(), "dvar", F.list(xList), engine);
            }
            return F.NIL;
        }
        if (!x2.isVariable()) {
            return IOFunctions.printMessage(ast.topHead(), "ivar", F.list(x2), engine);
        }
        return MatrixD.binaryMatrixD(fx, x2);
    }

    private static IExpr binaryMatrixD(IExpr functionOfX, IExpr x) {
        if (functionOfX.isFree(x, true)) {
            return F.C0;
        }
        if (functionOfX.equals(x)) {
            return S.$SingleEntryMatrix;
        }
        if (functionOfX.isAST() && functionOfX.size() >= 2) {
            IAST function = (IAST)functionOfX;
            if (function.isPlus()) {
                return function.mapThread(F.MatrixD(F.Slot1, x), 1);
            }
            if (function.isTimes() || function.isASTSizeGE(S.Dot, 3) || function.isASTSizeGE(S.KroneckerProduct, 3)) {
                return function.map(F.PlusAlloc(16), new BinaryBindIth1st(function, F.MatrixD(S.Null, x)));
            }
        }
        return F.NIL;
    }

    @Override
    public int[] expectedArgSize(IAST ast) {
        return ARGS_2_INFINITY;
    }
}

