/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ListPlot3D
extends AbstractEvaluator {
    @Override
    public IExpr evaluate(IAST ast, EvalEngine engine) {
        IOFunctions.printExperimental(S.ListPlot3D);
        if (ast.argSize() > 0) {
            OptionArgs options;
            if (ast.argSize() > 1 && (options = new OptionArgs(ast.topHead(), ast, 2, engine)).isInvalidPosition(1)) {
                return options.printNonopt(ast, 1, engine);
            }
            int[] dimension = ast.arg1().isMatrix(false);
            if (dimension != null && dimension.length == 2) {
                IAST values = (IAST)ast.arg1().normal(false);
                if (dimension[0] == 3 && dimension[1] == 3) {
                    IAST polygons = F.Polygon(F.list(F.list(((IAST)values.arg1()).arg1(), ((IAST)values.arg2()).arg1(), ((IAST)values.arg3()).arg1()), F.list(((IAST)values.arg1()).arg2(), ((IAST)values.arg2()).arg2(), ((IAST)values.arg3()).arg2()), F.list(((IAST)values.arg1()).arg3(), ((IAST)values.arg2()).arg3(), ((IAST)values.arg3()).arg3())));
                    IASTAppendable result = F.Graphics3D(polygons);
                    if (ast.argSize() > 1) {
                        result.appendAll(ast, 2, ast.size());
                    }
                    return result;
                }
                if (dimension[1] == 4) {
                    double minHeight;
                    IASTAppendable polygonList = F.ListAlloc((values.argSize() - 1) * (values.arg1().argSize() - 1) * 2);
                    double maxHeight = minHeight = ((IAST)values.arg1()).arg1().evalDouble();
                    ArrayList<double[]> heightRows = new ArrayList<double[]>();
                    for (int i = 1; i <= values.argSize(); ++i) {
                        IAST row = (IAST)values.get(i);
                        try {
                            heightRows.add(new double[0]);
                            double[] heights = new double[row.argSize()];
                            for (int j = 1; j <= row.argSize(); ++j) {
                                heights[j - 1] = row.get(j).evalDouble();
                                double height = heights[j - 1];
                                if (height < minHeight) {
                                    minHeight = height;
                                }
                                if (!(height > maxHeight)) continue;
                                maxHeight = height;
                            }
                            heightRows.set(i - 1, heights);
                            continue;
                        }
                        catch (ArgumentTypeException heights) {
                            // empty catch block
                        }
                    }
                    double deltaHeight = maxHeight - minHeight;
                    for (int i = 0; i < heightRows.size() - 1; ++i) {
                        double[] heights = (double[])heightRows.get(i);
                        double[] nextHeights = (double[])heightRows.get(i + 1);
                        if (heights.length <= 0 || nextHeights.length != heights.length) continue;
                        for (int j = 0; j < heights.length - 1; ++j) {
                            polygonList.append(F.Polygon(F.list(F.list(F.num(i + 1), F.num(j + 1), F.num(heights[j] / deltaHeight)), F.list(F.num(i + 2), F.num(j + 2), F.num(nextHeights[j + 1] / deltaHeight)), F.list(F.num(i + 1), F.num(j + 2), F.num(heights[j + 1] / deltaHeight)))));
                            polygonList.append(F.Polygon(F.list(F.list(F.num(i + 1), F.num(j + 1), F.num(heights[j] / deltaHeight)), F.list(F.num(i + 2), F.num(j + 2), F.num(nextHeights[j + 1] / deltaHeight)), F.list(F.num(i + 2), F.num(j + 1), F.num(nextHeights[j] / deltaHeight)))));
                        }
                    }
                    IASTAppendable result = F.Graphics3D(polygonList);
                    if (ast.argSize() > 1) {
                        result.appendAll(ast, 2, ast.size());
                    }
                    return result;
                }
            }
        }
        return F.NIL;
    }

    @Override
    public void setUp(ISymbol newSymbol) {
    }
}

